/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.rocketchatnotifier.workflow;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.plugins.rocketchatnotifier.Messages;
import jenkins.plugins.rocketchatnotifier.RocketChatNotifier;
import jenkins.plugins.rocketchatnotifier.RocketClient;
import jenkins.plugins.rocketchatnotifier.RocketClientImpl;
import jenkins.plugins.rocketchatnotifier.RocketClientWebhookImpl;
import jenkins.plugins.rocketchatnotifier.model.MessageAttachment;
import jenkins.plugins.rocketchatnotifier.rocket.errorhandling.RocketClientException;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class RocketSendStep
extends AbstractStepImpl {
    private static final Logger LOG = Logger.getLogger(RocketSendStep.class.getName());
    @NonNull
    private final String message;
    private String serverUrl;
    private boolean trustSSL;
    private String channel;
    private boolean failOnError;
    private String webhookToken;
    private String webhookTokenCredentialId;
    private String emoji;
    private String avatar;
    private String color;
    private boolean rawMessage;
    private List<MessageAttachment> attachments;
    private boolean useGlobalWebhookToken;

    @NonNull
    public String getMessage() {
        return this.message;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public boolean isTrustSSL() {
        return this.trustSSL;
    }

    public String getEmoji() {
        return this.emoji;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isRawMessage() {
        return this.rawMessage;
    }

    public String getWebhookToken() {
        return this.webhookToken;
    }

    public String getWebhookTokenCredentialId() {
        return this.webhookTokenCredentialId;
    }

    public List<MessageAttachment> getAttachments() {
        return this.attachments;
    }

    public boolean isUseGlobalWebhookToken() {
        return this.useGlobalWebhookToken;
    }

    @DataBoundSetter
    public void setEmoji(String emoji) {
        this.emoji = Util.fixEmpty((String)emoji);
    }

    @DataBoundSetter
    public void setAvatar(String avatar) {
        this.avatar = Util.fixEmpty((String)avatar);
    }

    @DataBoundSetter
    public void setColor(String color) {
        this.color = Util.fixEmpty((String)color);
    }

    @DataBoundSetter
    public void setAttachments(List<MessageAttachment> attachments) {
        this.attachments = attachments;
    }

    @DataBoundSetter
    public void setChannel(String channel) {
        this.channel = Util.fixEmpty((String)channel);
    }

    @DataBoundSetter
    public void setServerUrl(String serverUrl) {
        this.serverUrl = Util.fixEmpty((String)serverUrl);
    }

    @DataBoundSetter
    public void setTrustSSL(boolean trustSSL) {
        this.trustSSL = trustSSL;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @DataBoundSetter
    public void setRawMessage(boolean rawMessage) {
        this.rawMessage = rawMessage;
    }

    @DataBoundSetter
    public void setWebhookToken(String webhookToken) {
        this.webhookToken = Util.fixEmpty((String)webhookToken);
    }

    @DataBoundSetter
    public void setWebhookTokenCredentialId(String webhookTokenCredentialId) {
        this.webhookTokenCredentialId = Util.fixEmpty((String)webhookTokenCredentialId);
    }

    @DataBoundSetter
    public void setUseGlobalWebhookToken(boolean useGlobalWebhookToken) {
        this.useGlobalWebhookToken = useGlobalWebhookToken;
    }

    @DataBoundConstructor
    public RocketSendStep(@NonNull String message) {
        this.message = message;
    }

    public static class RocketSendStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        transient RocketSendStep step;
        @StepContextParameter
        transient TaskListener listener;
        @StepContextParameter
        transient Run run;

        protected Void run() throws Exception {
            String webhookTokenCredentialId;
            String webhookToken;
            Jenkins jenkins;
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOG.log(Level.SEVERE, String.valueOf(t) + " runStep threw an exception: ", e);
                }
            });
            try {
                jenkins = Jenkins.get();
            }
            catch (IllegalStateException ne) {
                this.listener.error(Messages.NotificationFailedWithException(ne));
                return null;
            }
            RocketChatNotifier.DescriptorImpl rocketDesc = (RocketChatNotifier.DescriptorImpl)jenkins.getDescriptorByType(RocketChatNotifier.DescriptorImpl.class);
            String server = this.step.serverUrl != null ? this.step.serverUrl : rocketDesc.getRocketServerUrl();
            boolean trustSSL = this.step.trustSSL || rocketDesc.isTrustSSL();
            String user = rocketDesc.getUsername();
            String password = rocketDesc.getPassword();
            String channel = this.step.channel != null ? this.step.channel : rocketDesc.getChannel();
            String jenkinsUrl = rocketDesc.getBuildServerUrl();
            if (!this.step.useGlobalWebhookToken) {
                webhookToken = this.step.getWebhookToken();
                webhookTokenCredentialId = this.step.getWebhookTokenCredentialId();
            } else {
                webhookToken = rocketDesc.getWebhookToken();
                webhookTokenCredentialId = rocketDesc.getWebhookTokenCredentialId();
            }
            this.listener.getLogger().println(Messages.RocketSendStepConfig(server, trustSSL, channel, this.step.message));
            try {
                boolean publishSuccess;
                RocketClient rocketClient = this.getRocketClient(server, trustSSL, user, password, channel, webhookToken, webhookTokenCredentialId);
                Object msg = this.step.message;
                if (!this.step.rawMessage) {
                    msg = (String)msg + "," + this.run.getFullDisplayName() + "," + jenkinsUrl + this.run.getUrl();
                }
                if (!(publishSuccess = rocketClient.publish((String)msg, this.step.emoji, this.step.avatar, MessageAttachment.convertMessageAttachmentsToMaps(this.step.attachments))) && this.step.failOnError) {
                    throw new AbortException(Messages.NotificationFailed());
                }
                if (!publishSuccess) {
                    this.listener.error(Messages.NotificationFailed());
                }
                return null;
            }
            catch (RocketClientException rce) {
                if (this.step.failOnError) {
                    throw rce;
                }
                this.listener.error(Messages.NotificationFailedWithException(rce));
                return null;
            }
        }

        RocketClient getRocketClient(String server, boolean trustSSL, String user, String password, String channel, String webhookToken, String webhookTokenCredentialId) throws RocketClientException {
            if (!StringUtils.isEmpty((String)webhookToken) || !StringUtils.isEmpty((String)webhookTokenCredentialId)) {
                return new RocketClientWebhookImpl(server, trustSSL, webhookToken, webhookTokenCredentialId, channel);
            }
            return new RocketClientImpl(server, trustSSL, user, password, channel);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(RocketSendStepExecution.class);
        }

        public String getFunctionName() {
            return "rocketSend";
        }

        public String getDisplayName() {
            return Messages.RocketSendStepDisplayName();
        }

        public ListBoxModel doFillWebhookTokenCredentialIdItems() {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }

        public FormValidation doCheckWebhookToken(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)"Exposing your Integration Token is a security risk. Please use the Webhook Token Credential ID");
        }
    }
}

