/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.rocketchatnotifier;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.JobProperty;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.plugins.rocketchatnotifier.ActiveNotifier;
import jenkins.plugins.rocketchatnotifier.CommitInfoChoice;
import jenkins.plugins.rocketchatnotifier.RocketClient;
import jenkins.plugins.rocketchatnotifier.RocketClientImpl;
import jenkins.plugins.rocketchatnotifier.RocketClientWebhookImpl;
import jenkins.plugins.rocketchatnotifier.model.MessageAttachment;
import jenkins.plugins.rocketchatnotifier.rocket.errorhandling.RocketClientException;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class RocketChatNotifier
extends Notifier {
    private static final Logger LOGGER = Logger.getLogger(RocketChatNotifier.class.getName());
    private String rocketServerUrl;
    private boolean trustSSL;
    private String username;
    private String password;
    private String channel;
    private String buildServerUrl;
    private boolean notifyStart;
    private boolean notifySuccess;
    private boolean notifyAborted;
    private boolean notifyNotBuilt;
    private boolean notifyUnstable;
    private boolean notifyFailure;
    private boolean notifyBackToNormal;
    private boolean notifyRepeatedFailure;
    private boolean includeTestSummary;
    private boolean includeTestLog;
    private CommitInfoChoice commitInfoChoice;
    private boolean includeCustomMessage;
    private String customMessage;
    private boolean rawMessage;
    private List<MessageAttachment> attachments;
    private String webhookToken;
    private String webhookTokenCredentialId;

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getBuildServerUrl() {
        LOGGER.log(Level.FINE, "Getting build server URL");
        if (this.buildServerUrl == null || this.buildServerUrl.equalsIgnoreCase("")) {
            return this.getJenkinsLocationConfiguration().getUrl();
        }
        return this.buildServerUrl;
    }

    private JenkinsLocationConfiguration getJenkinsLocationConfiguration() {
        JenkinsLocationConfiguration jlc = JenkinsLocationConfiguration.get();
        if (jlc == null) {
            throw new IllegalStateException("JenkinsLocationConfiguration not available");
        }
        return jlc;
    }

    public String getChannel() {
        return this.channel;
    }

    public boolean isRawMessage() {
        return this.rawMessage;
    }

    public List<MessageAttachment> getAttachments() {
        return this.attachments;
    }

    public boolean getNotifyStart() {
        return this.notifyStart;
    }

    public boolean getNotifySuccess() {
        return this.notifySuccess;
    }

    public CommitInfoChoice getCommitInfoChoice() {
        return this.commitInfoChoice;
    }

    public boolean getNotifyAborted() {
        return this.notifyAborted;
    }

    public boolean getNotifyFailure() {
        return this.notifyFailure;
    }

    public boolean getNotifyNotBuilt() {
        return this.notifyNotBuilt;
    }

    public boolean getNotifyUnstable() {
        return this.notifyUnstable;
    }

    public boolean getNotifyBackToNormal() {
        return this.notifyBackToNormal;
    }

    public boolean includeTestSummary() {
        return this.includeTestSummary;
    }

    public boolean includeTestLog() {
        return this.includeTestLog;
    }

    public boolean getNotifyRepeatedFailure() {
        return this.notifyRepeatedFailure;
    }

    public boolean includeCustomMessage() {
        return this.includeCustomMessage;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    public String getWebhookToken() {
        return this.webhookToken;
    }

    public String getWebhookTokenCredentialId() {
        return this.webhookTokenCredentialId;
    }

    public String getRocketServerUrl() {
        return this.rocketServerUrl;
    }

    public boolean isTrustSSL() {
        return this.trustSSL;
    }

    @DataBoundSetter
    public void setChannel(String channel) {
        this.channel = channel;
    }

    public boolean isNotifyStart() {
        return this.notifyStart;
    }

    @DataBoundSetter
    public void setNotifyStart(boolean notifyStart) {
        this.notifyStart = notifyStart;
    }

    public boolean isNotifySuccess() {
        return this.notifySuccess;
    }

    @DataBoundSetter
    public void setNotifySuccess(boolean notifySuccess) {
        this.notifySuccess = notifySuccess;
    }

    public boolean isNotifyAborted() {
        return this.notifyAborted;
    }

    @DataBoundSetter
    public void setNotifyAborted(boolean notifyAborted) {
        this.notifyAborted = notifyAborted;
    }

    public boolean isNotifyNotBuilt() {
        return this.notifyNotBuilt;
    }

    @DataBoundSetter
    public void setNotifyNotBuilt(boolean notifyNotBuilt) {
        this.notifyNotBuilt = notifyNotBuilt;
    }

    public boolean isNotifyUnstable() {
        return this.notifyUnstable;
    }

    @DataBoundSetter
    public void setNotifyUnstable(boolean notifyUnstable) {
        this.notifyUnstable = notifyUnstable;
    }

    public boolean isNotifyFailure() {
        return this.notifyFailure;
    }

    @DataBoundSetter
    public void setNotifyFailure(boolean notifyFailure) {
        this.notifyFailure = notifyFailure;
    }

    public boolean isNotifyBackToNormal() {
        return this.notifyBackToNormal;
    }

    @DataBoundSetter
    public void setNotifyBackToNormal(boolean notifyBackToNormal) {
        this.notifyBackToNormal = notifyBackToNormal;
    }

    public boolean isNotifyRepeatedFailure() {
        return this.notifyRepeatedFailure;
    }

    @DataBoundSetter
    public void setNotifyRepeatedFailure(boolean notifyRepeatedFailure) {
        this.notifyRepeatedFailure = notifyRepeatedFailure;
    }

    public boolean isIncludeTestSummary() {
        return this.includeTestSummary;
    }

    @DataBoundSetter
    public void setIncludeTestSummary(boolean includeTestSummary) {
        this.includeTestSummary = includeTestSummary;
    }

    public boolean isIncludeTestLog() {
        return this.includeTestLog;
    }

    @DataBoundSetter
    public void setIncludeTestLog(boolean includeTestLog) {
        this.includeTestLog = includeTestLog;
    }

    @DataBoundSetter
    public void setCommitInfoChoice(CommitInfoChoice commitInfoChoice) {
        this.commitInfoChoice = commitInfoChoice;
    }

    @DataBoundSetter
    public void setRawMessage(boolean rawMessage) {
        this.rawMessage = rawMessage;
    }

    public boolean isIncludeCustomMessage() {
        return this.includeCustomMessage;
    }

    @DataBoundSetter
    public void setIncludeCustomMessage(boolean includeCustomMessage) {
        this.includeCustomMessage = includeCustomMessage;
    }

    @DataBoundSetter
    public void setCustomMessage(String customMessage) {
        this.customMessage = customMessage;
    }

    @DataBoundSetter
    public void setAttachments(List<MessageAttachment> attachments) {
        this.attachments = attachments;
    }

    @DataBoundSetter
    public void setWebhookToken(String webhookToken) {
        this.webhookToken = webhookToken;
    }

    @DataBoundSetter
    public void setWebhookTokenCredentialId(String webhookTokenCredentialId) {
        this.webhookTokenCredentialId = webhookTokenCredentialId;
    }

    @DataBoundConstructor
    public RocketChatNotifier() {
    }

    @DataBoundSetter
    public void setRocketServerUrl(String rocketServerUrl) {
        this.rocketServerUrl = rocketServerUrl;
    }

    @DataBoundSetter
    public void setTrustSSL(boolean trustSSL) {
        this.trustSSL = trustSSL;
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.username = username;
    }

    @DataBoundSetter
    public void setPassword(String password) {
        this.password = password;
    }

    @DataBoundSetter
    public void setBuildServerUrl(String buildServerUrl) {
        this.buildServerUrl = buildServerUrl;
        if (buildServerUrl == null || buildServerUrl.equalsIgnoreCase("")) {
            JenkinsLocationConfiguration jenkinsConfig = new JenkinsLocationConfiguration();
            this.buildServerUrl = jenkinsConfig.getUrl();
        }
        if (buildServerUrl != null && !buildServerUrl.endsWith("/")) {
            this.buildServerUrl = buildServerUrl + "/";
        }
    }

    public RocketChatNotifier(String rocketServerUrl, boolean trustSSL, String username, String password, String channel, String buildServerUrl, boolean notifyStart, boolean notifyAborted, boolean notifyFailure, boolean notifyNotBuilt, boolean notifySuccess, boolean notifyUnstable, boolean notifyBackToNormal, boolean notifyRepeatedFailure, boolean includeTestSummary, boolean includeTestLog, CommitInfoChoice commitInfoChoice, boolean includeCustomMessage, boolean rawMessage, String customMessage, List<MessageAttachment> attachments, String webhookToken, String webhookTokenCredentialId) {
        this.rocketServerUrl = rocketServerUrl;
        this.trustSSL = trustSSL;
        this.username = username;
        this.password = password;
        this.buildServerUrl = buildServerUrl;
        this.channel = channel;
        this.notifyStart = notifyStart;
        this.notifyAborted = notifyAborted;
        this.notifyFailure = notifyFailure;
        this.notifyNotBuilt = notifyNotBuilt;
        this.notifySuccess = notifySuccess;
        this.notifyUnstable = notifyUnstable;
        this.notifyBackToNormal = notifyBackToNormal;
        this.notifyRepeatedFailure = notifyRepeatedFailure;
        this.includeTestSummary = includeTestSummary;
        this.includeTestLog = includeTestLog;
        this.commitInfoChoice = commitInfoChoice;
        this.includeCustomMessage = includeCustomMessage;
        this.rawMessage = rawMessage;
        this.customMessage = customMessage;
        this.attachments = attachments;
        this.webhookToken = webhookToken;
        this.webhookTokenCredentialId = webhookTokenCredentialId;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public RocketClient newRocketChatClient(AbstractBuild r, BuildListener listener) throws RocketClientException {
        EnvVars env;
        String webhookToken;
        String webhookTokenCredentialId;
        String channel;
        String password;
        String username;
        String serverUrl = this.rocketServerUrl;
        if (StringUtils.isEmpty((String)serverUrl)) {
            serverUrl = this.getDescriptor().getRocketServerUrl();
        }
        if (StringUtils.isEmpty((String)(username = this.username))) {
            username = this.getDescriptor().getUsername();
        }
        if (StringUtils.isEmpty((String)(password = this.password))) {
            password = this.getDescriptor().getPassword();
        }
        if (StringUtils.isEmpty((String)(channel = this.channel))) {
            channel = this.getDescriptor().getChannel();
        }
        if (StringUtils.isEmpty((String)(webhookTokenCredentialId = this.webhookTokenCredentialId))) {
            webhookTokenCredentialId = this.getDescriptor().getWebhookTokenCredentialId();
        }
        if (StringUtils.isEmpty((String)(webhookToken = this.webhookToken))) {
            webhookToken = this.getDescriptor().getWebhookToken();
        }
        try {
            env = r.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            listener.getLogger().println("Error retrieving environment vars: " + e.getMessage());
            env = new EnvVars();
        }
        serverUrl = env.expand(serverUrl);
        username = env.expand(username);
        password = env.expand(password);
        return RocketChatNotifier.getRocketClient(serverUrl, username, password, channel, webhookToken, webhookTokenCredentialId, this.trustSSL);
    }

    public static RocketClient getRocketClient(String serverUrl, String username, String password, String channel, String webhookToken, String webhookTokenCredentialId, boolean trustSSL) throws RocketClientException {
        if (!StringUtils.isEmpty((String)webhookToken) || !StringUtils.isEmpty((String)webhookTokenCredentialId)) {
            return new RocketClientWebhookImpl(serverUrl, trustSSL, webhookToken, webhookTokenCredentialId, channel);
        }
        return new RocketClientImpl(serverUrl, trustSSL, username, password, channel);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Map map = build.getProject().getPublishersList().toMap();
        for (Publisher publisher : map.values()) {
            if (!(publisher instanceof RocketChatNotifier)) continue;
            LOGGER.info("Invoking Completed...");
            new ActiveNotifier((RocketChatNotifier)publisher, listener).completed(build);
        }
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        if (this.notifyStart) {
            Map map = build.getProject().getPublishersList().toMap();
            for (Publisher publisher : map.values()) {
                if (!(publisher instanceof RocketChatNotifier)) continue;
                LOGGER.info("Invoking Started...");
                new ActiveNotifier((RocketChatNotifier)publisher, listener).started(build);
            }
        }
        return super.prebuild(build, listener);
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String rocketServerUrl;
        private boolean trustSSL;
        private String username;
        private String password;
        private String channel;
        private String buildServerUrl;
        private String webhookToken;
        private String webhookTokenCredentialId;
        public static final CommitInfoChoice[] COMMIT_INFO_CHOICES = CommitInfoChoice.values();

        public DescriptorImpl() {
            this.load();
        }

        public String getRocketServerUrl() {
            return this.rocketServerUrl;
        }

        public boolean isTrustSSL() {
            return this.trustSSL;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getWebhookToken() {
            return this.webhookToken;
        }

        public String getWebhookTokenCredentialId() {
            return this.webhookTokenCredentialId;
        }

        public String getBuildServerUrl() {
            if (this.buildServerUrl == null || this.buildServerUrl.equalsIgnoreCase("")) {
                JenkinsLocationConfiguration jenkinsConfig = new JenkinsLocationConfiguration();
                return jenkinsConfig.getUrl();
            }
            return this.buildServerUrl;
        }

        @DataBoundSetter
        public void setRocketServerUrl(String rocketServerUrl) {
            this.rocketServerUrl = rocketServerUrl;
        }

        @DataBoundSetter
        public void setUsername(String username) {
            this.username = username;
        }

        @DataBoundSetter
        public void setPassword(String password) {
            this.password = password;
        }

        @DataBoundSetter
        public void setChannel(String channel) {
            this.channel = channel;
        }

        @DataBoundSetter
        public void setBuildServerUrl(String buildServerUrl) {
            this.buildServerUrl = buildServerUrl;
            if (buildServerUrl == null || buildServerUrl.equalsIgnoreCase("")) {
                JenkinsLocationConfiguration jenkinsConfig = new JenkinsLocationConfiguration();
                this.buildServerUrl = jenkinsConfig.getUrl();
            }
            if (buildServerUrl != null && !buildServerUrl.endsWith("/")) {
                this.buildServerUrl = buildServerUrl + "/";
            }
        }

        @DataBoundSetter
        public void setTrustSSL(boolean trustSSL) {
            this.trustSSL = trustSSL;
        }

        @DataBoundSetter
        public void setWebhookToken(String webhookToken) {
            this.webhookToken = webhookToken;
        }

        @DataBoundSetter
        public void setWebhookTokenCredentialId(String webhookTokenCredentialId) {
            this.webhookTokenCredentialId = webhookTokenCredentialId;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            req.bindJSON((Object)this, json);
            this.save();
            return true;
        }

        public String getDisplayName() {
            return "RocketChat Notifications";
        }

        @RequirePOST
        public FormValidation doTestConnection(@QueryParameter(value="rocketServerUrl") String rocketServerUrl, @QueryParameter(value="trustSSL") String trustSSL, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="channel") String channel, @QueryParameter(value="buildServerUrl") String buildServerUrl, @QueryParameter(value="webhookToken") String token, @QueryParameter(value="webhookTokenCredentialId") String webhookTokenCredentialId) throws Descriptor.FormException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                String targetWebhookTokenCredentialId;
                String targetWebhookToken;
                String targetBuildServerUrl;
                String targetChannel;
                String targetPassword;
                String targetUsername;
                Object targetServerUrl = rocketServerUrl + "/api/";
                if (StringUtils.isEmpty((String)rocketServerUrl)) {
                    targetServerUrl = this.rocketServerUrl;
                }
                boolean targetTrustSSL = this.trustSSL;
                if (StringUtils.isNotEmpty((String)trustSSL)) {
                    targetTrustSSL = BooleanUtils.toBoolean((String)trustSSL);
                }
                if (StringUtils.isEmpty((String)(targetUsername = username))) {
                    targetUsername = this.username;
                }
                if (StringUtils.isEmpty((String)(targetPassword = password))) {
                    targetPassword = this.password;
                }
                if (StringUtils.isEmpty((String)(targetChannel = channel))) {
                    targetChannel = this.channel;
                }
                if (StringUtils.isEmpty((String)(targetBuildServerUrl = buildServerUrl))) {
                    targetBuildServerUrl = this.buildServerUrl;
                }
                if (StringUtils.isEmpty((String)(targetWebhookToken = token))) {
                    targetWebhookToken = this.webhookToken;
                }
                if (StringUtils.isEmpty((String)(targetWebhookTokenCredentialId = webhookTokenCredentialId))) {
                    targetWebhookTokenCredentialId = this.webhookTokenCredentialId;
                }
                RocketClient rocketChatClient = !StringUtils.isEmpty((String)targetWebhookToken) || !StringUtils.isEmpty((String)targetWebhookTokenCredentialId) ? new RocketClientWebhookImpl((String)targetServerUrl, targetTrustSSL, targetWebhookToken, targetWebhookTokenCredentialId, channel) : new RocketClientImpl((String)targetServerUrl, targetTrustSSL, targetUsername, targetPassword, targetChannel);
                String message = "RocketChat/Jenkins plugin: you're all set on " + targetBuildServerUrl;
                LOGGER.fine("Start validating config");
                rocketChatClient.validate();
                LOGGER.fine("Done validating config");
                LOGGER.fine("Start publishing message");
                rocketChatClient.publish(message, null);
                LOGGER.fine("Done publishing message");
                return FormValidation.ok((String)"Success");
            }
            catch (Exception e) {
                if (e.getCause() != null && (e.getCause().getClass() == SSLHandshakeException.class || e.getCause().getClass() == CertificateException.class)) {
                    LOGGER.log(Level.SEVERE, "SSL error during trying to send rocket message", e);
                    return FormValidation.error((Throwable)e, (String)"SSL error", (Object[])new Object[]{e});
                }
                LOGGER.log(Level.SEVERE, "Client error during trying to send rocket message", e);
                return FormValidation.error((Throwable)e, (String)"Client error - Could not send message");
            }
        }

        public ListBoxModel doFillWebhookTokenCredentialIdItems() {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }

        public FormValidation doCheckWebhookToken(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)"Exposing your Integration Token is a security risk. Please use the Webhook Token Credential ID");
        }
    }

    @Deprecated
    public static class RocketJobProperty
    extends JobProperty<AbstractProject<?, ?>> {
        private String rocketServerUrl;
        private String username;
        private String password;
        private String channel;
        private boolean trustSSL;
        private boolean notifyStart;
        private boolean notifySuccess;
        private boolean notifyAborted;
        private boolean notifyNotBuilt;
        private boolean notifyUnstable;
        private boolean notifyFailure;
        private boolean notifyBackToNormal;
        private boolean notifyRepeatedFailure;
        private boolean includeTestSummary;
        private boolean includeTestLog;
        private boolean showCommitList;
        private boolean includeCustomMessage;
        private String customMessage;

        @DataBoundConstructor
        public RocketJobProperty(String rocketServerUrl, boolean trustSSL, String username, String password, String channel, boolean notifyStart, boolean notifyAborted, boolean notifyFailure, boolean notifyNotBuilt, boolean notifySuccess, boolean notifyUnstable, boolean notifyBackToNormal, boolean notifyRepeatedFailure, boolean includeTestSummary, boolean includeTestLog, boolean showCommitList, boolean includeCustomMessage, String customMessage) {
            this.rocketServerUrl = rocketServerUrl;
            this.trustSSL = trustSSL;
            this.username = username;
            this.password = password;
            this.channel = channel;
            this.notifyStart = notifyStart;
            this.notifyAborted = notifyAborted;
            this.notifyFailure = notifyFailure;
            this.notifyNotBuilt = notifyNotBuilt;
            this.notifySuccess = notifySuccess;
            this.notifyUnstable = notifyUnstable;
            this.notifyBackToNormal = notifyBackToNormal;
            this.notifyRepeatedFailure = notifyRepeatedFailure;
            this.includeTestSummary = includeTestSummary;
            this.includeTestLog = includeTestLog;
            this.showCommitList = showCommitList;
            this.includeCustomMessage = includeCustomMessage;
            this.customMessage = customMessage;
        }

        @Exported
        public String getRocketServerUrl() {
            return this.rocketServerUrl;
        }

        @Exported
        public boolean isTrustSSL() {
            return this.trustSSL;
        }

        @Exported
        public String getUsername() {
            return this.username;
        }

        @Exported
        public String getPassword() {
            return this.password;
        }

        @Exported
        public String getChannel() {
            return this.channel;
        }

        @Exported
        public boolean getNotifyStart() {
            return this.notifyStart;
        }

        @Exported
        public boolean getNotifySuccess() {
            return this.notifySuccess;
        }

        @Exported
        public boolean getShowCommitList() {
            return this.showCommitList;
        }

        public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
            return super.prebuild(build, listener);
        }

        @Exported
        public boolean getNotifyAborted() {
            return this.notifyAborted;
        }

        @Exported
        public boolean getNotifyFailure() {
            return this.notifyFailure;
        }

        @Exported
        public boolean getNotifyNotBuilt() {
            return this.notifyNotBuilt;
        }

        @Exported
        public boolean getNotifyUnstable() {
            return this.notifyUnstable;
        }

        @Exported
        public boolean getNotifyBackToNormal() {
            return this.notifyBackToNormal;
        }

        @Exported
        public boolean includeTestSummary() {
            return this.includeTestSummary;
        }

        @Exported
        public boolean includeTestLog() {
            return this.includeTestLog;
        }

        @Exported
        public boolean getNotifyRepeatedFailure() {
            return this.notifyRepeatedFailure;
        }

        @Exported
        public boolean includeCustomMessage() {
            return this.includeCustomMessage;
        }

        @Exported
        public String getCustomMessage() {
            return this.customMessage;
        }
    }
}

