/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Run;
import hudson.plugins.robot.model.RobotCaseResult;
import hudson.plugins.robot.model.RobotResult;
import hudson.plugins.robot.model.RobotSuiteResult;
import hudson.plugins.robot.model.RobotTestObject;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.remoting.RoleChecker;

public class RobotParser {
    public RobotResult parse(String outputFileLocations, String outputPath, Run<?, ?> build, FilePath workSpace, String logFileName, String reportFileName) throws InterruptedException, IOException {
        return (RobotResult)new FilePath(workSpace, outputPath).act((FilePath.FileCallable)new RobotParserCallable(outputFileLocations, logFileName, reportFileName));
    }

    public static final class RobotParserCallable
    implements FilePath.FileCallable<RobotResult> {
        private static final long serialVersionUID = 1L;
        private final String outputFileLocations;
        private final String logFileName;
        private final String reportFileName;
        private int schemaVersion;
        private String startLocalName = "starttime";
        private String elapsedLocalName = "elapsedtime";
        private String endLocalName = "endtime";

        public RobotParserCallable(String outputFileLocations, String logFileName, String reportFileName) {
            this.outputFileLocations = outputFileLocations;
            this.logFileName = logFileName;
            this.reportFileName = reportFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RobotResult invoke(File ws, VirtualChannel channel) throws IOException {
            FileSet setInWorkspace = Util.createFileSet((File)ws, (String)this.outputFileLocations);
            DirectoryScanner resultScanner = setInWorkspace.getDirectoryScanner();
            String[] files = resultScanner.getIncludedFiles();
            if (files.length == 0) {
                throw new AbortException("No files found in path " + ws.getAbsolutePath() + " with configured filemask: " + this.outputFileLocations);
            }
            RobotResult result = new RobotResult();
            result.setLogFile(this.logFileName);
            result.setReportFile(this.reportFileName);
            for (String file : files) {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
                factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                File baseDirectory = resultScanner.getBasedir();
                File reportFile = new File(baseDirectory, file);
                String dirFromFileGLOB = new File(file).getParent();
                if (dirFromFileGLOB != null) {
                    baseDirectory = new File(baseDirectory, dirFromFileGLOB);
                }
                try (FileInputStream inputStream = new FileInputStream(reportFile);
                     XMLStreamReader reader = factory.createXMLStreamReader(inputStream, "UTF-8");){
                    this.parseResult(result, reader, baseDirectory);
                }
                catch (XMLStreamException e1) {
                    throw new IOException("Parsing of output xml failed!", e1);
                }
            }
            return result;
        }

        private RobotResult parseResult(RobotResult result, XMLStreamReader reader, File baseDirectory) throws XMLStreamException, IOException {
            while (reader.hasNext()) {
                reader.next();
                if (!reader.isStartElement()) continue;
                String tagName = reader.getLocalName();
                if ("statistics".equals(tagName)) break;
                if ("robot".equals(tagName)) {
                    String value = reader.getAttributeValue(null, "schemaversion");
                    value = value == null ? "0" : value;
                    this.schemaVersion = Integer.parseInt(value);
                    if (this.schemaVersion >= 5) {
                        this.startLocalName = "start";
                        this.elapsedLocalName = "elapsed";
                    }
                    result.setTimeStamp(reader.getAttributeValue(null, "generated"));
                    continue;
                }
                if (!"suite".equals(tagName)) continue;
                result.addSuite(this.processSuite(reader, result, baseDirectory));
            }
            return result;
        }

        private RobotSuiteResult processSuite(XMLStreamReader reader, RobotTestObject parent, File baseDirectory) throws IOException, XMLStreamException {
            String splitXMLPath = reader.getAttributeValue(null, "src");
            if (splitXMLPath != null) {
                return this.getSplitXMLSuite(parent, baseDirectory, splitXMLPath);
            }
            RobotSuiteResult suite = new RobotSuiteResult();
            suite.setSchemaVersion(this.schemaVersion);
            suite.setLogFile(this.logFileName);
            suite.setReportFile(this.reportFileName);
            suite.setParent(parent);
            suite.setName(reader.getAttributeValue(null, "name"));
            suite.setId(reader.getAttributeValue(null, "id"));
            suite.setDescription("");
            while (reader.hasNext()) {
                reader.next();
                if (reader.isStartElement()) {
                    String tagName = reader.getLocalName();
                    if ("doc".equals(tagName)) {
                        reader.next();
                        if (!reader.hasText()) continue;
                        suite.setDescription(reader.getText());
                        continue;
                    }
                    if ("suite".equals(tagName)) {
                        suite.addChild(this.processSuite(reader, suite, baseDirectory));
                        continue;
                    }
                    if ("test".equals(tagName)) {
                        suite.addCaseResult(this.processTest(reader, suite));
                        continue;
                    }
                    if ("kw".equals(tagName) && "teardown".equalsIgnoreCase(reader.getAttributeValue(null, "type"))) {
                        this.ignoreUntilStarts(reader, "status");
                        if (!"FAIL".equals(reader.getAttributeValue(null, "status"))) continue;
                        suite.failTeardown();
                        continue;
                    }
                    if (!"status".equals(tagName)) continue;
                    suite.setElapsedTime(reader.getAttributeValue(null, this.elapsedLocalName));
                    suite.setStartTime(reader.getAttributeValue(null, this.startLocalName));
                    suite.setEndTime(reader.getAttributeValue(null, this.endLocalName));
                    continue;
                }
                if (!reader.isEndElement() || !"suite".equals(reader.getLocalName())) continue;
                return suite;
            }
            throw this.xmlException("No matching end tag found for test suite: " + suite.getName(), reader);
        }

        private XMLStreamException xmlException(String message, XMLStreamReader reader) {
            Location location = reader.getLocation();
            return new XMLStreamException(message + " (at line: " + location.getLineNumber() + " column: " + location.getColumnNumber() + ")");
        }

        private RobotSuiteResult getSplitXMLSuite(RobotTestObject parent, File baseDirectory, String path) throws XMLStreamException, IOException {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            try (FileInputStream inputStream = new FileInputStream(new File(baseDirectory, path));
                 XMLStreamReader splitReader = factory.createXMLStreamReader(inputStream, "UTF-8");){
                while (splitReader.hasNext()) {
                    splitReader.next();
                    if (!splitReader.isStartElement() || !"suite".equals(splitReader.getLocalName())) continue;
                    RobotSuiteResult robotSuiteResult = this.processSuite(splitReader, parent, baseDirectory);
                    return robotSuiteResult;
                }
                throw this.xmlException("Illegal split xml output. Could not find suite element.", splitReader);
            }
        }

        private String ignoreUntilStarts(XMLStreamReader reader, String ... elements) throws XMLStreamException {
            ArrayList<String> elementStack = new ArrayList<String>();
            while (reader.hasNext()) {
                reader.next();
                if (reader.isStartElement()) {
                    String elem = reader.getLocalName();
                    if (elementStack.isEmpty() && this.isNameInElements(elem, elements)) {
                        return elem;
                    }
                    elementStack.add(reader.getLocalName());
                    continue;
                }
                if (!reader.isEndElement()) continue;
                if (elementStack.isEmpty()) {
                    throw this.xmlException("Could not find elements " + Arrays.toString(elements), reader);
                }
                if (!((String)elementStack.get(elementStack.size() - 1)).equals(reader.getLocalName())) {
                    throw this.xmlException("Illegal xml input. End element " + reader.getLocalName() + " while waiting for element " + (String)elementStack.get(elementStack.size() - 1), reader);
                }
                elementStack.remove(elementStack.size() - 1);
            }
            throw this.xmlException("Could not find elements " + Arrays.toString(elements), reader);
        }

        private boolean isNameInElements(String name, String[] elements) {
            for (String element : elements) {
                if (!name.equals(element)) continue;
                return true;
            }
            return false;
        }

        private void ignoreUntilEnds(XMLStreamReader reader, String element) throws XMLStreamException {
            ArrayList<String> elementStack = new ArrayList<String>();
            while (reader.hasNext()) {
                reader.next();
                if (reader.isStartElement()) {
                    elementStack.add(reader.getLocalName());
                    continue;
                }
                if (!reader.isEndElement()) continue;
                String tagName = reader.getLocalName();
                if (elementStack.isEmpty()) {
                    if (tagName.equals(element)) {
                        return;
                    }
                    throw this.xmlException("Illegal xml input. Could not find end of element " + element + ". Unexpected end of element " + tagName, reader);
                }
                if (!((String)elementStack.get(elementStack.size() - 1)).equals(tagName)) {
                    throw this.xmlException("Illegal xml input. End element " + tagName + " while waiting for element " + (String)elementStack.get(elementStack.size() - 1), reader);
                }
                elementStack.remove(elementStack.size() - 1);
            }
            throw this.xmlException("Could not find end of element " + element, reader);
        }

        private String getSpacesPerNestedLevel(int level) {
            StringBuilder spaces = new StringBuilder();
            if (level > 0) {
                spaces.append("\n");
            }
            spaces.append("  ".repeat(Math.max(0, level)));
            return spaces.toString();
        }

        private RobotCaseResult processTest(XMLStreamReader reader, RobotSuiteResult result) throws XMLStreamException {
            RobotCaseResult caseResult = new RobotCaseResult();
            caseResult.setParent(result);
            caseResult.setLogFile(this.logFileName);
            caseResult.setName(reader.getAttributeValue(null, "name"));
            caseResult.setId(reader.getAttributeValue(null, "id"));
            caseResult.setDescription("");
            caseResult.addTags(new ArrayList<String>());
            StringBuilder stackTrace = new StringBuilder();
            String[] possible_elements = new String[]{"kw", "for", "if", "try", "while", "doc", "tags", "tag", "status"};
            String[] elements = new String[]{"kw", "for", "if", "try", "while"};
            String xmlTag = this.ignoreUntilStarts(reader, possible_elements);
            while (this.isNameInElements(xmlTag, elements)) {
                switch (xmlTag) {
                    case "if": 
                    case "try": {
                        stackTrace.append(this.processBranchable(reader, 0));
                        break;
                    }
                    case "for": 
                    case "while": {
                        stackTrace.append(this.processLoop(reader, 0));
                        break;
                    }
                    default: {
                        stackTrace.append(this.processKeyword(reader, 0));
                    }
                }
                xmlTag = this.ignoreUntilStarts(reader, possible_elements);
            }
            caseResult.setStackTrace(stackTrace.toString().trim().replaceAll("\n+", "\n"));
            if (xmlTag.equals("doc")) {
                reader.next();
                if (reader.hasText()) {
                    caseResult.setDescription(reader.getText());
                }
                reader.next();
                xmlTag = this.ignoreUntilStarts(reader, "tags", "tag", "status");
            }
            if (xmlTag.equals("tags") || xmlTag.equals("tag")) {
                caseResult.addTags(this.processTags(reader));
                if (!reader.getLocalName().equals("status")) {
                    this.ignoreUntilStarts(reader, "status");
                }
            }
            caseResult.setPassed("PASS".equals(reader.getAttributeValue(null, "status")));
            caseResult.setSkipped("SKIP".equals(reader.getAttributeValue(null, "status")));
            caseResult.setStarttime(reader.getAttributeValue(null, this.startLocalName));
            caseResult.setEndtime(reader.getAttributeValue(null, this.endLocalName));
            if (this.schemaVersion >= 5) {
                caseResult.setElapsedTime(reader.getAttributeValue(null, this.elapsedLocalName));
            }
            while (reader.hasNext()) {
                reader.next();
                if (reader.isCharacters()) {
                    String error = reader.getText();
                    caseResult.setErrorMsg(error);
                    continue;
                }
                if (!reader.isEndElement()) continue;
                if ("status".equals(reader.getLocalName())) break;
                throw this.xmlException("No end tag found for status while parsing test case: " + caseResult.getName(), reader);
            }
            if (caseResult.isPassed() || caseResult.isSkipped()) {
                caseResult.setStackTrace("");
            }
            this.ignoreUntilEnds(reader, "test");
            return caseResult;
        }

        private String processLoop(XMLStreamReader reader, int nestedCount) throws XMLStreamException {
            StringBuilder stackTrace = new StringBuilder();
            String indentation = this.getSpacesPerNestedLevel(nestedCount);
            String kind = reader.getLocalName();
            stackTrace.append(indentation + kind.toUpperCase());
            if (kind.equals("for")) {
                stackTrace.append(" " + reader.getAttributeValue(null, "flavor"));
            }
            while (!(!reader.hasNext() || reader.isEndElement() && reader.getLocalName().equals(kind))) {
                if (reader.isStartElement() && reader.getLocalName().equals("iter")) {
                    stackTrace.append(this.processIteration(reader, nestedCount + 1));
                }
                reader.next();
            }
            stackTrace.append(indentation + "END\n");
            return stackTrace.toString();
        }

        private String processIteration(XMLStreamReader reader, int nestedCount) throws XMLStreamException {
            StringBuilder stackTrace = new StringBuilder();
            while (!(!reader.hasNext() || reader.isEndElement() && reader.getLocalName().equals("iter"))) {
                if (reader.isStartElement()) {
                    String xmlTag;
                    switch (xmlTag = reader.getLocalName()) {
                        case "for": 
                        case "while": {
                            stackTrace.append(this.processLoop(reader, nestedCount));
                            break;
                        }
                        case "kw": {
                            stackTrace.append(this.processKeyword(reader, nestedCount));
                            break;
                        }
                        case "if": 
                        case "try": {
                            stackTrace.append(this.processBranchable(reader, nestedCount));
                            break;
                        }
                        case "return": 
                        case "break": 
                        case "continue": {
                            stackTrace.append(this.processReturnBreakContinue(reader, nestedCount));
                            break;
                        }
                    }
                }
                reader.next();
            }
            return stackTrace.toString();
        }

        private String processBranchable(XMLStreamReader reader, int nestedCount) throws XMLStreamException {
            StringBuilder stackTrace = new StringBuilder();
            String indentation = this.getSpacesPerNestedLevel(nestedCount);
            String kind = reader.getLocalName();
            while (!(!reader.hasNext() || reader.isEndElement() && reader.getLocalName().equals(kind))) {
                if (reader.isStartElement() && reader.getLocalName().equals("branch")) {
                    stackTrace.append(indentation + reader.getAttributeValue(null, "type"));
                    stackTrace.append(this.processBranch(reader, nestedCount + 1));
                }
                reader.next();
            }
            stackTrace.append(indentation + "END\n");
            return stackTrace.toString();
        }

        private String processBranch(XMLStreamReader reader, int nestedCount) throws XMLStreamException {
            StringBuilder stackTrace = new StringBuilder();
            while (!(!reader.hasNext() || reader.isEndElement() && reader.getLocalName().equals("branch"))) {
                if (reader.isStartElement()) {
                    String xmlTag;
                    switch (xmlTag = reader.getLocalName()) {
                        case "for": 
                        case "while": {
                            stackTrace.append(this.processLoop(reader, nestedCount));
                            break;
                        }
                        case "kw": {
                            stackTrace.append(this.processKeyword(reader, nestedCount));
                            break;
                        }
                        case "if": 
                        case "try": {
                            stackTrace.append(this.processBranchable(reader, nestedCount));
                            break;
                        }
                        case "return": 
                        case "break": 
                        case "continue": {
                            stackTrace.append(this.processReturnBreakContinue(reader, nestedCount));
                            break;
                        }
                    }
                }
                reader.next();
            }
            return stackTrace.toString();
        }

        private String processKeyword(XMLStreamReader reader, int nestedCount) throws XMLStreamException {
            StringBuilder stackTrace = new StringBuilder();
            String kw = reader.getAttributeValue(null, "name");
            String indentation = this.getSpacesPerNestedLevel(nestedCount);
            stackTrace.append(indentation).append(kw);
            reader.next();
            block19: while (!(!reader.hasNext() || reader.isEndElement() && reader.getLocalName().equals("kw"))) {
                if (reader.isStartElement()) {
                    String xmlTag;
                    switch (xmlTag = reader.getLocalName()) {
                        case "arguments": 
                        case "arg": {
                            stackTrace.append(this.processArgs(reader));
                            continue block19;
                        }
                        case "for": 
                        case "while": {
                            stackTrace.append(this.processLoop(reader, nestedCount + 1));
                            break;
                        }
                        case "kw": {
                            stackTrace.append(this.processKeyword(reader, nestedCount + 1));
                            break;
                        }
                        case "if": 
                        case "try": {
                            stackTrace.append(this.processBranchable(reader, nestedCount + 1));
                            break;
                        }
                        case "return": 
                        case "break": 
                        case "continue": {
                            stackTrace.append(this.processReturnBreakContinue(reader, nestedCount + 1));
                            break;
                        }
                    }
                }
                reader.next();
            }
            stackTrace.append("\n");
            return stackTrace.toString();
        }

        private String processArgs(XMLStreamReader reader) throws XMLStreamException {
            StringBuilder stringBuilder = new StringBuilder();
            while (reader.hasNext()) {
                if (reader.isEndElement() || reader.isStartElement()) {
                    String xmlTag = reader.getLocalName();
                    if (reader.isEndElement() && xmlTag.equals("arguments") || reader.isStartElement() && xmlTag.equals("status") || reader.isStartElement() && xmlTag.equals("kw")) break;
                    if (reader.isStartElement() && xmlTag.equals("arg")) {
                        reader.next();
                        try {
                            stringBuilder.append("    ").append(reader.getText());
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                }
                reader.next();
            }
            return stringBuilder.toString();
        }

        private List<String> processTags(XMLStreamReader reader) throws XMLStreamException {
            ArrayList<String> tagList = new ArrayList<String>();
            while (reader.hasNext()) {
                if (reader.isStartElement() && "tag".equals(reader.getLocalName())) {
                    while (reader.hasNext()) {
                        reader.next();
                        if (reader.isCharacters()) {
                            tagList.add(reader.getText());
                            continue;
                        }
                        if (!reader.isEndElement() || !"tag".equals(reader.getLocalName())) continue;
                        break;
                    }
                } else if (reader.isEndElement() && "tags".equals(reader.getLocalName()) || reader.isStartElement() && "status".equals(reader.getLocalName())) break;
                reader.next();
            }
            return tagList;
        }

        private String processReturnBreakContinue(XMLStreamReader reader, int nestedCount) throws XMLStreamException {
            StringBuilder stringBuilder = new StringBuilder();
            String kind = reader.getLocalName();
            stringBuilder.append(this.getSpacesPerNestedLevel(nestedCount)).append(kind.toUpperCase());
            while (!(!reader.hasNext() || reader.isEndElement() && reader.getLocalName().equals(kind))) {
                if (reader.isStartElement() && reader.getLocalName().equals("kw")) {
                    stringBuilder.append(this.processKeyword(reader, nestedCount + 1));
                }
                reader.next();
            }
            return stringBuilder.toString();
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
        }
    }
}

