/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot;

import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Run;
import hudson.plugins.robot.Messages;
import hudson.plugins.robot.RobotBuildAction;
import hudson.plugins.robot.RobotConfig;
import hudson.plugins.robot.graph.RobotGraph;
import hudson.plugins.robot.graph.RobotGraphHelper;
import hudson.plugins.robot.model.RobotResult;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class AggregatedRobotAction
implements Action {
    private AggregatedRobotResult aggregatedResult;
    private MatrixBuild build;

    public AggregatedRobotAction(MatrixBuild build) {
        this.build = build;
    }

    public void addResult(RobotResult result) {
        if (this.aggregatedResult == null) {
            this.aggregatedResult = new AggregatedRobotResult(this);
        }
        this.aggregatedResult.addResult(result);
    }

    public AggregatedRobotResult getResult() {
        return this.aggregatedResult;
    }

    public AbstractBuild getOwner() {
        return this.build;
    }

    public static RobotBuildAction getChildBuildAction(Run run) {
        return (RobotBuildAction)run.getAction(RobotBuildAction.class);
    }

    public double getOverallPassPercentage() {
        return this.aggregatedResult.getPassPercentage(false);
    }

    public String getIconFileName() {
        return "/plugin/robot/robot.png";
    }

    public String getDisplayName() {
        return Messages.robot_sidebar_link();
    }

    public String getUrlName() {
        return "robot";
    }

    public void doGraph(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar t = this.build.getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        String label = AggregatedRobotAction.getChildBuildAction((Run)this.build).getxAxisLabel();
        String labelFormat = StringUtils.isBlank((String)label) ? RobotConfig.getInstance().getXAxisLabelFormat() : label;
        RobotGraph g = RobotGraphHelper.createTestResultsGraphForTestObject(this.getResult(), Boolean.parseBoolean(req.getParameter("zoomSignificant")), false, Boolean.parseBoolean(req.getParameter("hd")), Boolean.parseBoolean(req.getParameter("failedOnly")), labelFormat, Integer.parseInt(req.getParameter("maxBuildsToShow")));
        g.doPng(req, rsp);
    }

    public static class AggregatedRobotResult
    extends RobotResult {
        private static final long serialVersionUID = 1L;
        private final transient AggregatedRobotAction parent;
        private int passed;
        private int failed;
        private int skipped;

        public AggregatedRobotResult(AggregatedRobotAction parent) {
            this.parent = parent;
        }

        public void addResult(RobotResult result) {
            this.failed = (int)((long)this.failed + result.getOverallFailed());
            this.passed = (int)((long)this.passed + result.getOverallPassed());
            this.skipped = (int)((long)this.skipped + result.getOverallSkipped());
        }

        @Override
        public long getOverallPassed() {
            return this.passed;
        }

        @Override
        public long getOverallFailed() {
            return this.failed;
        }

        @Override
        public long getOverallSkipped() {
            return this.skipped;
        }

        @Override
        public long getOverallTotal() {
            return this.failed + this.passed + this.skipped;
        }

        @Override
        public int getFailed() {
            return (int)this.getOverallFailed();
        }

        @Override
        public int getPassed() {
            return (int)this.getOverallPassed();
        }

        @Override
        public int getSkipped() {
            return (int)this.getOverallSkipped();
        }

        public AbstractBuild getOwner() {
            return this.parent.getOwner();
        }

        @Override
        public RobotResult getPreviousResult() {
            AbstractBuild build = this.getOwner();
            if (build == null) {
                return null;
            }
            while ((build = build.getPreviousBuild()) != null) {
                AggregatedRobotAction parentAction = (AggregatedRobotAction)build.getAction(AggregatedRobotAction.class);
                if (parentAction == null) continue;
                AggregatedRobotResult result = parentAction.getResult();
                return result;
            }
            return null;
        }
    }
}

