/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.repo;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.TaskListener;
import hudson.plugins.repo.ChangeLog;
import hudson.plugins.repo.ManifestAction;
import hudson.plugins.repo.ManifestValidator;
import hudson.plugins.repo.ProjectState;
import hudson.plugins.repo.RevisionState;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.FormValidation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class RepoScm
extends SCM
implements Serializable {
    private static final int MAX_ARG_STRLEN = 131072;
    private static Logger debug = Logger.getLogger("hudson.plugins.repo.RepoScm");
    static final String ALLOW_LOCAL_CHECKOUT_PROPERTY = RepoScm.class.getName() + ".ALLOW_LOCAL_CHECKOUT";
    static boolean ALLOW_LOCAL_CHECKOUT = Boolean.parseBoolean(System.getProperty(ALLOW_LOCAL_CHECKOUT_PROPERTY, "false"));
    private final String manifestRepositoryUrl;
    @CheckForNull
    private String manifestFile;
    @CheckForNull
    private String manifestGroup;
    @CheckForNull
    private String manifestPlatform;
    @CheckForNull
    private String repoUrl;
    @CheckForNull
    private String repoBranch;
    @CheckForNull
    private String mirrorDir;
    @CheckForNull
    private String manifestBranch;
    @CheckForNull
    private int jobs;
    @CheckForNull
    private int depth;
    @CheckForNull
    private String localManifest;
    @CheckForNull
    private String destinationDir;
    @CheckForNull
    private boolean currentBranch;
    @CheckForNull
    private boolean resetFirst;
    @CheckForNull
    private boolean cleanFirst;
    @CheckForNull
    private boolean quiet;
    @CheckForNull
    private boolean forceSync;
    @CheckForNull
    private boolean trace;
    @CheckForNull
    private boolean showAllChanges;
    @CheckForNull
    private boolean noTags;
    @CheckForNull
    private boolean manifestSubmodules;
    @CheckForNull
    private boolean fetchSubmodules;
    @CheckForNull
    private Set<String> ignoreProjects;
    @CheckForNull
    private EnvVars extraEnvVars;
    @CheckForNull
    private boolean noCloneBundle;
    @CheckForNull
    private boolean worktree;
    @CheckForNull
    private boolean noSync;
    @CheckForNull
    private boolean gitLfs;

    @Exported
    public String getManifestRepositoryUrl() {
        return this.manifestRepositoryUrl;
    }

    @Exported
    public String getManifestBranch() {
        return this.manifestBranch;
    }

    private EnvVars getEnvVars(EnvVars environment, Job<?, ?> project) {
        EnvVars finalEnv = new EnvVars();
        ParametersDefinitionProperty params = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        if (params != null) {
            for (ParameterDefinition param : params.getParameterDefinitions()) {
                StringParameterDefinition stpd;
                String dflt;
                if (!(param instanceof StringParameterDefinition) || (dflt = (stpd = (StringParameterDefinition)param).getDefaultValue()) == null) continue;
                finalEnv.put(param.getName(), dflt);
            }
        }
        if (environment != null) {
            finalEnv.overrideAll((Map)environment);
        }
        if (this.extraEnvVars != null) {
            finalEnv.overrideAll((Map)this.extraEnvVars);
        }
        EnvVars.resolve((Map)finalEnv);
        return finalEnv;
    }

    @Exported
    public String getManifestFile() {
        return this.manifestFile;
    }

    @Exported
    public String getManifestGroup() {
        return this.manifestGroup;
    }

    @CheckForNull
    public String getManifestPlatform() {
        return this.manifestPlatform;
    }

    @Exported
    public String getRepoUrl() {
        return this.repoUrl;
    }

    @Exported
    public String getRepoBranch() {
        return this.repoBranch;
    }

    @Exported
    public String getMirrorDir() {
        return this.mirrorDir;
    }

    @Exported
    public int getJobs() {
        return this.jobs;
    }

    @Exported
    public int getDepth() {
        return this.depth;
    }

    @Exported
    public String getLocalManifest() {
        return this.localManifest;
    }

    @Exported
    public String getDestinationDir() {
        return this.destinationDir;
    }

    @Exported
    public String getIgnoreProjects() {
        return StringUtils.join(this.ignoreProjects, (char)'\n');
    }

    @Exported
    public boolean isCurrentBranch() {
        return this.currentBranch;
    }

    @Exported
    public boolean isResetFirst() {
        return this.resetFirst;
    }

    @Exported
    public boolean isCleanFirst() {
        return this.cleanFirst;
    }

    @Exported
    public boolean isShowAllChanges() {
        return this.showAllChanges;
    }

    @Exported
    public boolean isQuiet() {
        return this.quiet;
    }

    @Exported
    public boolean isForceSync() {
        return this.forceSync;
    }

    @Exported
    public boolean isTrace() {
        return this.trace;
    }

    @Exported
    public boolean isNoTags() {
        return this.noTags;
    }

    @Exported
    public boolean isNoCloneBundle() {
        return this.noCloneBundle;
    }

    @Exported
    public boolean isWorktree() {
        return this.worktree;
    }

    @Exported
    public boolean isManifestSubmodules() {
        return this.manifestSubmodules;
    }

    public boolean isFetchSubmodules() {
        return this.fetchSubmodules;
    }

    public boolean isGitLfs() {
        return this.gitLfs;
    }

    @Exported
    public Map<String, String> getExtraEnvVars() {
        return this.extraEnvVars;
    }

    public boolean isNoSync() {
        return this.noSync;
    }

    @Deprecated
    public RepoScm(String manifestRepositoryUrl, String manifestBranch, String manifestFile, String manifestGroup, String mirrorDir, int jobs, int depth, String localManifest, String destinationDir, String repoUrl, boolean currentBranch, boolean resetFirst, boolean quiet, boolean trace, boolean showAllChanges) {
        this(manifestRepositoryUrl);
        this.setManifestBranch(manifestBranch);
        this.setManifestGroup(manifestGroup);
        this.setManifestFile(manifestFile);
        this.setMirrorDir(mirrorDir);
        this.setJobs(jobs);
        this.setDepth(depth);
        this.setLocalManifest(localManifest);
        this.setDestinationDir(destinationDir);
        this.setCurrentBranch(currentBranch);
        this.setResetFirst(resetFirst);
        this.setCleanFirst(false);
        this.setQuiet(quiet);
        this.setTrace(trace);
        this.setShowAllChanges(showAllChanges);
        this.setRepoUrl(repoUrl);
        this.ignoreProjects = Collections.emptySet();
        this.setWorktree(false);
    }

    @DataBoundConstructor
    public RepoScm(String manifestRepositoryUrl) {
        this.manifestRepositoryUrl = manifestRepositoryUrl;
        this.manifestFile = null;
        this.manifestGroup = null;
        this.repoUrl = null;
        this.repoBranch = null;
        this.mirrorDir = null;
        this.manifestBranch = null;
        this.jobs = 0;
        this.depth = 0;
        this.localManifest = null;
        this.destinationDir = null;
        this.currentBranch = false;
        this.resetFirst = false;
        this.cleanFirst = false;
        this.quiet = false;
        this.forceSync = false;
        this.trace = false;
        this.showAllChanges = false;
        this.noTags = false;
        this.manifestSubmodules = false;
        this.fetchSubmodules = false;
        this.ignoreProjects = Collections.emptySet();
        this.noCloneBundle = false;
        this.worktree = false;
        this.noSync = false;
        this.gitLfs = false;
    }

    @DataBoundSetter
    public void setManifestBranch(@CheckForNull String manifestBranch) {
        this.manifestBranch = Util.fixEmptyAndTrim((String)manifestBranch);
    }

    @DataBoundSetter
    public void setManifestFile(@CheckForNull String manifestFile) {
        this.manifestFile = Util.fixEmptyAndTrim((String)manifestFile);
    }

    @DataBoundSetter
    public void setManifestGroup(@CheckForNull String manifestGroup) {
        this.manifestGroup = Util.fixEmptyAndTrim((String)manifestGroup);
    }

    @DataBoundSetter
    public void setManifestPlatform(@CheckForNull String manifestPlatform) {
        this.manifestPlatform = Util.fixEmptyAndTrim((String)manifestPlatform);
    }

    @DataBoundSetter
    public void setMirrorDir(@CheckForNull String mirrorDir) {
        this.mirrorDir = Util.fixEmptyAndTrim((String)mirrorDir);
    }

    @DataBoundSetter
    public void setJobs(int jobs) {
        this.jobs = jobs;
    }

    @DataBoundSetter
    public void setDepth(int depth) {
        this.depth = depth;
    }

    @DataBoundSetter
    public void setLocalManifest(@CheckForNull String localManifest) {
        this.localManifest = Util.fixEmptyAndTrim((String)localManifest);
    }

    @DataBoundSetter
    public void setDestinationDir(@CheckForNull String destinationDir) {
        this.destinationDir = Util.fixEmptyAndTrim((String)destinationDir);
    }

    @DataBoundSetter
    public void setCurrentBranch(boolean currentBranch) {
        this.currentBranch = currentBranch;
    }

    @DataBoundSetter
    public void setResetFirst(boolean resetFirst) {
        this.resetFirst = resetFirst;
    }

    @DataBoundSetter
    public void setCleanFirst(boolean cleanFirst) {
        this.cleanFirst = cleanFirst;
    }

    @DataBoundSetter
    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @DataBoundSetter
    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @DataBoundSetter
    public void setShowAllChanges(boolean showAllChanges) {
        this.showAllChanges = showAllChanges;
    }

    @DataBoundSetter
    public void setNoCloneBundle(boolean noCloneBundle) {
        this.noCloneBundle = noCloneBundle;
    }

    @DataBoundSetter
    public void setWorktree(boolean worktree) {
        this.worktree = worktree;
    }

    @DataBoundSetter
    public void setRepoUrl(@CheckForNull String repoUrl) {
        this.repoUrl = Util.fixEmptyAndTrim((String)repoUrl);
    }

    @DataBoundSetter
    public void setRepoBranch(@CheckForNull String repoBranch) {
        this.repoBranch = Util.fixEmptyAndTrim((String)repoBranch);
    }

    @DataBoundSetter
    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    @DataBoundSetter
    public void setNoSync(boolean noSync) {
        this.noSync = noSync;
    }

    @DataBoundSetter
    public final void setNoTags(boolean noTags) {
        this.noTags = noTags;
    }

    @DataBoundSetter
    public void setManifestSubmodules(boolean manifestSubmodules) {
        this.manifestSubmodules = manifestSubmodules;
    }

    @DataBoundSetter
    public void setFetchSubmodules(boolean fetchSubmodules) {
        this.fetchSubmodules = fetchSubmodules;
    }

    @DataBoundSetter
    public void setGitLfs(boolean gitLfs) {
        this.gitLfs = gitLfs;
    }

    @DataBoundSetter
    public final void setIgnoreProjects(String ignoreProjects) {
        if (ignoreProjects == null) {
            this.ignoreProjects = Collections.emptySet();
            return;
        }
        this.ignoreProjects = new LinkedHashSet<String>(Arrays.asList(ignoreProjects.split("\\s+")));
    }

    @DataBoundSetter
    public void setExtraEnvVars(@CheckForNull Map<String, String> extraEnvVars) {
        this.extraEnvVars = extraEnvVars != null ? new EnvVars(extraEnvVars) : null;
    }

    public SCMRevisionState calcRevisionsFromBuild(@Nonnull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        return SCMRevisionState.NONE;
    }

    private boolean shouldIgnoreChanges(RevisionState current, RevisionState baseline) {
        List<ProjectState> changedProjects = current.whatChanged(baseline);
        if (changedProjects == null || this.ignoreProjects == null) {
            return false;
        }
        if (this.ignoreProjects.isEmpty()) {
            return false;
        }
        for (ProjectState changed : changedProjects) {
            if (this.ignoreProjects.contains(changed.getServerPath())) continue;
            return false;
        }
        return true;
    }

    public PollingResult compareRemoteRevisionWith(@Nonnull Job<?, ?> job, @Nullable Launcher launcher, @Nullable FilePath workspace, @Nonnull TaskListener listener, @Nonnull SCMRevisionState baseline) throws IOException, InterruptedException {
        SCMRevisionState myBaseline = baseline;
        EnvVars env = this.getEnvVars(null, job);
        String expandedManifestUrl = env.expand(this.manifestRepositoryUrl);
        String expandedManifestBranch = env.expand(this.manifestBranch);
        String expandedManifestFile = env.expand(this.manifestFile);
        Run lastRun = job.getLastBuild();
        if (myBaseline == SCMRevisionState.NONE && (myBaseline = this.getLastState(lastRun, expandedManifestUrl, expandedManifestBranch, expandedManifestFile)) == SCMRevisionState.NONE) {
            return PollingResult.BUILD_NOW;
        }
        FilePath repoDir = this.destinationDir != null ? workspace.child(env.expand(this.destinationDir)) : workspace;
        if (!repoDir.isDirectory()) {
            repoDir.mkdirs();
        }
        if (!this.checkoutCode(launcher, repoDir, env, listener.getLogger())) {
            return new PollingResult(myBaseline, myBaseline, PollingResult.Change.INCOMPARABLE);
        }
        RevisionState currentState = new RevisionState(this.getStaticManifest(launcher, repoDir, listener.getLogger(), env), this.getManifestRevision(launcher, repoDir, listener.getLogger(), env), expandedManifestUrl, expandedManifestBranch, expandedManifestFile, listener.getLogger());
        PollingResult.Change change = currentState.equals(myBaseline) ? PollingResult.Change.NONE : (this.shouldIgnoreChanges(currentState, myBaseline instanceof RevisionState ? (RevisionState)myBaseline : null) ? PollingResult.Change.NONE : PollingResult.Change.SIGNIFICANT);
        return new PollingResult(myBaseline, (SCMRevisionState)currentState, change);
    }

    public void checkout(@Nonnull Run<?, ?> build, @Nonnull Launcher launcher, @Nonnull FilePath workspace, @Nonnull TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState baseline) throws IOException, InterruptedException {
        if (!ALLOW_LOCAL_CHECKOUT && !workspace.isRemote()) {
            this.abortIfUrlLocal();
        }
        Job job = build.getParent();
        EnvVars env = build.getEnvironment(listener);
        env = this.getEnvVars(env, job);
        FilePath repoDir = this.destinationDir != null ? workspace.child(env.expand(this.destinationDir)) : workspace;
        if (!repoDir.isDirectory()) {
            repoDir.mkdirs();
        }
        if (!this.checkoutCode(launcher, repoDir, env, listener.getLogger())) {
            throw new IOException("Could not checkout");
        }
        String manifest = this.getStaticManifest(launcher, repoDir, listener.getLogger(), env);
        String manifestRevision = this.getManifestRevision(launcher, repoDir, listener.getLogger(), env);
        String expandedUrl = env.expand(this.manifestRepositoryUrl);
        String expandedBranch = env.expand(this.manifestBranch);
        String expandedFile = env.expand(this.manifestFile);
        RevisionState currentState = new RevisionState(manifest, manifestRevision, expandedUrl, expandedBranch, expandedFile, listener.getLogger());
        build.addAction((Action)currentState);
        Run previousBuild = build.getPreviousBuild();
        SCMRevisionState previousState = this.getLastState(previousBuild, expandedUrl, expandedBranch, expandedFile);
        if (changelogFile != null) {
            ChangeLog.saveChangeLog(currentState, previousState == SCMRevisionState.NONE ? null : (RevisionState)previousState, changelogFile, launcher, repoDir, this.showAllChanges);
        }
        if (build.getActions(ManifestAction.class).size() == 0) {
            build.addAction((Action)new ManifestAction(build));
        }
    }

    private void abortIfUrlLocal() throws AbortException {
        if (StringUtils.isNotEmpty((String)this.manifestRepositoryUrl) && (this.manifestRepositoryUrl.toLowerCase(Locale.ENGLISH).startsWith("file://") || Files.exists(Paths.get(this.manifestRepositoryUrl, new String[0]), new LinkOption[0]))) {
            throw new AbortException("Checkout of Repo url '" + this.manifestRepositoryUrl + "' aborted because it references a local directory, which may be insecure. You can allow local checkouts anyway by setting the system property '" + ALLOW_LOCAL_CHECKOUT_PROPERTY + "' to true.");
        }
    }

    private int doSync(Launcher launcher, @Nonnull FilePath workspace, OutputStream logger, EnvVars env) throws IOException, InterruptedException {
        ArrayList<Object> commands = new ArrayList<Object>(4);
        debug.log(Level.FINE, "Syncing out code in: " + workspace.getName());
        commands.clear();
        if (this.resetFirst) {
            commands.add(this.getDescriptor().getExecutable());
            commands.add("forall");
            if (this.jobs > 0) {
                commands.add("--jobs=" + this.jobs);
            }
            commands.add("-c");
            commands.add("git reset --hard");
            int resetCode = launcher.launch().stdout(logger).stderr(logger).pwd(workspace).cmds(commands).envs((Map)env).join();
            if (resetCode != 0) {
                debug.log(Level.WARNING, "Failed to reset first.");
            }
            commands.clear();
        }
        if (this.cleanFirst) {
            commands.add(this.getDescriptor().getExecutable());
            commands.add("forall");
            if (this.jobs > 0) {
                commands.add("--jobs=" + this.jobs);
            }
            commands.add("-c");
            commands.add("git clean -fdx");
            int cleanCode = launcher.launch().stdout(logger).stderr(logger).pwd(workspace).cmds(commands).envs((Map)env).join();
            if (cleanCode != 0) {
                debug.log(Level.WARNING, "Failed to clean first.");
            }
            commands.clear();
        }
        commands.add(this.getDescriptor().getExecutable());
        if (this.trace) {
            commands.add("--trace");
        }
        commands.add("sync");
        commands.add("-d");
        if (this.isCurrentBranch()) {
            commands.add("-c");
        }
        if (this.isQuiet()) {
            commands.add("-q");
        }
        if (this.isForceSync()) {
            commands.add("--force-sync");
        }
        if (this.jobs > 0) {
            commands.add("--jobs=" + this.jobs);
        }
        if (this.isNoTags()) {
            commands.add("--no-tags");
        }
        if (this.isNoCloneBundle()) {
            commands.add("--no-clone-bundle");
        }
        if (this.fetchSubmodules) {
            commands.add("--fetch-submodules");
        }
        if (this.repoUrl != null) {
            commands.add("--no-repo-verify");
        }
        return launcher.launch().stdout(logger).pwd(workspace).cmds(commands).envs((Map)env).join();
    }

    private boolean checkoutCode(Launcher launcher, @Nonnull FilePath workspace, EnvVars env, OutputStream logger) throws IOException, InterruptedException {
        int returnCode;
        ArrayList<Object> commands = new ArrayList<Object>(4);
        debug.log(Level.INFO, "Checking out code in: {0}", workspace.getName());
        FilePath rdir = workspace.child(".repo");
        FilePath lmdir = rdir.child("local_manifests");
        if (rdir.exists()) {
            rdir.child("local_manifest.xml").delete();
            if (lmdir.exists()) {
                lmdir.deleteContents();
            }
        }
        commands.add(this.getDescriptor().getExecutable());
        if (this.trace) {
            commands.add("--trace");
        }
        commands.add("init");
        commands.add("-u");
        commands.add(env.expand(this.manifestRepositoryUrl));
        if (this.manifestBranch != null) {
            commands.add("-b");
            commands.add(env.expand(this.manifestBranch));
        }
        if (this.manifestFile != null) {
            commands.add("-m");
            commands.add(env.expand(this.manifestFile));
        }
        if (this.mirrorDir != null) {
            commands.add("--reference=" + env.expand(this.mirrorDir));
        }
        if (this.repoUrl != null) {
            commands.add("--repo-url=" + env.expand(this.repoUrl));
            commands.add("--no-repo-verify");
        }
        if (this.repoBranch != null) {
            commands.add("--repo-branch=" + env.expand(this.repoBranch));
        }
        if (this.manifestGroup != null) {
            commands.add("-g");
            commands.add(env.expand(this.manifestGroup));
        }
        if (this.manifestPlatform != null) {
            commands.add("-p");
            commands.add(env.expand(this.manifestPlatform));
        }
        if (this.depth != 0) {
            commands.add("--depth=" + this.depth);
        }
        if (this.isNoCloneBundle()) {
            commands.add("--no-clone-bundle");
        }
        if (this.isWorktree()) {
            commands.add("--worktree");
        }
        if (this.currentBranch) {
            commands.add("--current-branch");
        }
        if (this.noTags) {
            commands.add("--no-tags");
        }
        if (this.manifestSubmodules) {
            commands.add("--submodules");
        }
        if (this.gitLfs) {
            commands.add("--git-lfs");
        }
        if ((returnCode = launcher.launch().stdout(logger).pwd(workspace).cmds(commands).envs((Map)env).join()) != 0) {
            return false;
        }
        if (this.isNoSync()) {
            debug.log(Level.FINEST, "Repo init completed successfully, not running repo sync");
            return true;
        }
        if (this.localManifest != null) {
            if (!lmdir.exists()) {
                lmdir.mkdirs();
            }
            FilePath lm = lmdir.child("local.xml");
            String expandedLocalManifest = env.expand(this.localManifest);
            if (expandedLocalManifest.startsWith("<?xml")) {
                lm.write(expandedLocalManifest, null);
            } else {
                URL url = new URL(expandedLocalManifest);
                lm.copyFrom(url);
            }
        }
        if (!ALLOW_LOCAL_CHECKOUT && !workspace.isRemote()) {
            this.abortIfManifestReferencesLocalUrl(launcher, workspace, logger, env);
        }
        if ((returnCode = this.doSync(launcher, workspace, logger, env)) != 0) {
            debug.log(Level.WARNING, "Sync failed. Resetting repository");
            commands.clear();
            commands.add(this.getDescriptor().getExecutable());
            commands.add("forall");
            commands.add("-c");
            commands.add("git reset --hard");
            launcher.launch().stdout(logger).pwd(workspace).cmds(commands).envs((Map)env).join();
            returnCode = this.doSync(launcher, workspace, logger, env);
            if (returnCode != 0) {
                return false;
            }
        }
        return true;
    }

    private byte[] getManifestAsBytes(Launcher launcher, FilePath workspace, OutputStream logger, EnvVars env) throws IOException, InterruptedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getDescriptor().getExecutable());
        commands.add("manifest");
        launcher.launch().stderr(logger).stdout((OutputStream)byteArrayOutputStream).pwd(workspace).cmds(commands).envs((Map)env).join();
        return byteArrayOutputStream.toByteArray();
    }

    private void abortIfManifestReferencesLocalUrl(Launcher launcher, FilePath workspace, OutputStream logger, EnvVars env) throws IOException, InterruptedException {
        byte[] manifestText = this.getManifestAsBytes(launcher, workspace, logger, env);
        ManifestValidator.validate(manifestText, this.manifestRepositoryUrl);
    }

    public void buildEnvironment(@Nonnull Run<?, ?> build, @Nonnull Map<String, String> env) {
        String expandedManifestFile;
        String expandedManifestBranch;
        Job job = build.getParent();
        EnvVars jobEnv = this.getEnvVars(null, job);
        String expandedManifestUrl = jobEnv.expand(this.manifestRepositoryUrl);
        SCMRevisionState state = this.getState(build, expandedManifestUrl, expandedManifestBranch = jobEnv.expand(this.manifestBranch), expandedManifestFile = jobEnv.expand(this.manifestFile));
        if (state != SCMRevisionState.NONE) {
            env.put("REPO_MANIFEST_URL", ((RevisionState)state).getUrl());
            env.put("REPO_MANIFEST_BRANCH", ((RevisionState)state).getBranch());
            env.put("REPO_MANIFEST_FILE", ((RevisionState)state).getFile());
            String manifest = ((RevisionState)state).getManifest();
            if (manifest.length() > 131072) {
                manifest = "_";
            }
            env.put("REPO_MANIFEST_XML", manifest);
        }
    }

    private String getStaticManifest(Launcher launcher, FilePath workspace, OutputStream logger, EnvVars env) throws IOException, InterruptedException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ArrayList<String> commands = new ArrayList<String>(6);
        commands.add(this.getDescriptor().getExecutable());
        commands.add("manifest");
        commands.add("-o");
        commands.add("-");
        commands.add("-r");
        launcher.launch().stderr(logger).stdout((OutputStream)output).pwd(workspace).cmds(commands).envs((Map)env).join();
        String manifestText = new String(output.toByteArray(), Charset.defaultCharset());
        debug.log(Level.FINEST, manifestText);
        return manifestText;
    }

    private String getManifestRevision(Launcher launcher, FilePath workspace, OutputStream logger, EnvVars env) throws IOException, InterruptedException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ArrayList<String> commands = new ArrayList<String>(6);
        commands.add("git");
        commands.add("rev-parse");
        commands.add("HEAD");
        launcher.launch().stderr(logger).stdout((OutputStream)output).pwd(new FilePath(workspace, ".repo/manifests")).cmds(commands).envs((Map)env).join();
        String manifestText = new String(output.toByteArray(), Charset.defaultCharset()).trim();
        debug.log(Level.FINEST, manifestText);
        return manifestText;
    }

    private boolean isRelevantState(RevisionState state, String url, String branch, String file) {
        return StringUtils.equals((String)state.getBranch(), (String)branch) && StringUtils.equals((String)state.getUrl(), (String)url) && StringUtils.equals((String)state.getFile(), (String)file);
    }

    @Nonnull
    private SCMRevisionState getState(Run<?, ?> build, String expandedManifestUrl, String expandedManifestBranch, String expandedManifestFile) {
        if (build == null) {
            return SCMRevisionState.NONE;
        }
        List stateList = build.getActions(RevisionState.class);
        for (RevisionState state : stateList) {
            if (state == null || !this.isRelevantState(state, expandedManifestUrl, expandedManifestBranch, expandedManifestFile)) continue;
            return state;
        }
        return SCMRevisionState.NONE;
    }

    @Nonnull
    private SCMRevisionState getLastState(Run<?, ?> lastBuild, String expandedManifestUrl, String expandedManifestBranch, String expandedManifestFile) {
        if (lastBuild == null) {
            return SCMRevisionState.NONE;
        }
        SCMRevisionState lastState = this.getState(lastBuild, expandedManifestUrl, expandedManifestBranch, expandedManifestFile);
        if (lastState == SCMRevisionState.NONE) {
            lastState = this.getLastState(lastBuild.getPreviousBuild(), expandedManifestUrl, expandedManifestBranch, expandedManifestFile);
        }
        return lastState;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ChangeLog();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Nonnull
    public String getKey() {
        return "repo" + ' ' + this.getManifestRepositoryUrl() + ' ' + this.getManifestFile() + ' ' + this.getManifestBranch();
    }

    @Extension
    public static class DescriptorImpl
    extends SCMDescriptor<RepoScm> {
        private String repoExecutable;

        public DescriptorImpl() {
            super(null);
            this.load();
        }

        public String getDisplayName() {
            return "Gerrit Repo";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            this.repoExecutable = Util.fixEmptyAndTrim((String)json.getString("executable"));
            this.save();
            return super.configure(req, json);
        }

        public FormValidation doExecutableCheck(@QueryParameter String value) {
            return FormValidation.validateExecutable((String)value);
        }

        public String getExecutable() {
            if (this.repoExecutable == null) {
                return "repo";
            }
            return this.repoExecutable;
        }

        public boolean isApplicable(Job project) {
            return true;
        }
    }
}

