/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.repo;

import hudson.AbortException;
import hudson.plugins.repo.RepoScm;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import jenkins.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ManifestValidator {
    private ManifestValidator() {
    }

    public static void validate(byte[] manifestText, String manifestRepositoryUrl) throws IOException {
        if (manifestText.length > 0) {
            try {
                Document doc = XMLUtils.parse((InputStream)new ByteArrayInputStream(manifestText));
                NodeList remote = doc.getElementsByTagName("remote");
                for (int i = 0; i < remote.getLength(); ++i) {
                    NamedNodeMap attributes = remote.item(i).getAttributes();
                    for (int j = 0; j < attributes.getLength(); ++j) {
                        if (!"fetch".equals(attributes.item(j).getNodeName()) || !attributes.item(j).getNodeValue().toLowerCase(Locale.ENGLISH).startsWith("file://")) continue;
                        throw new AbortException("Checkout of Repo url '" + manifestRepositoryUrl + "' aborted because manifest references a local directory, which may be insecure. You can allow local checkouts anyway by setting the system property '" + RepoScm.ALLOW_LOCAL_CHECKOUT_PROPERTY + "' to true.");
                    }
                }
            }
            catch (SAXException e) {
                throw new IOException("Could not validate manifest");
            }
        }
    }
}

