/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.repo;

import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;

public class ChangeLogEntry
extends ChangeLogSet.Entry {
    private final String path;
    private final String serverPath;
    private final String revision;
    private final String authorName;
    private final String authorEmail;
    private final String authorDate;
    private final String committerName;
    private final String committerEmail;
    private final String committerDate;
    private final String commitText;
    private final List<ModifiedFile> modifiedFiles;

    public ChangeLogEntry(String path, String serverPath, String revision, String authorName, String authorEmail, String authorDate, String committerName, String committerEmail, String committerDate, String commitText, List<ModifiedFile> modifiedFiles) {
        this.path = path;
        this.serverPath = serverPath;
        this.revision = revision;
        this.authorName = authorName;
        this.authorEmail = authorEmail;
        this.authorDate = authorDate;
        this.committerName = committerName;
        this.committerEmail = committerEmail;
        this.committerDate = committerDate;
        this.commitText = commitText;
        this.modifiedFiles = modifiedFiles;
    }

    public String toString() {
        return "path: " + this.path + "\nserverPath: " + this.serverPath + "\nrevision: " + this.revision + "\nauthorName: " + this.authorName + "\nauthorEmail: " + this.authorEmail + "\nauthorDate: " + this.authorDate + "\ncommitterName: " + this.committerName + "\ncommitterEmail: " + this.committerEmail + "\ncommitterDate: " + this.committerDate + "\ncommitText: " + this.commitText + "\nmodifiedFiles: " + String.valueOf(this.modifiedFiles);
    }

    public String getPath() {
        return this.path;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public String getAuthorDate() {
        return this.authorDate;
    }

    public String getCommitterName() {
        return this.committerName;
    }

    public String getCommitterEmail() {
        return this.committerEmail;
    }

    public String getCommitterDate() {
        return this.committerDate;
    }

    public String getCommitText() {
        return this.commitText;
    }

    public List<ModifiedFile> getModifiedFiles() {
        return this.modifiedFiles;
    }

    public List<ModifiedFile> getAffectedFiles() {
        return this.modifiedFiles;
    }

    public String getMsg() {
        return this.getCommitText();
    }

    public User getAuthor() {
        if (this.authorName == null) {
            return User.getUnknown();
        }
        return User.get((String)this.authorEmail);
    }

    public void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    public Collection<String> getAffectedPaths() {
        if (this.modifiedFiles == null) {
            return null;
        }
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return ChangeLogEntry.this.modifiedFiles.get(index).getPath();
            }

            @Override
            public int size() {
                return ChangeLogEntry.this.modifiedFiles.size();
            }
        };
    }

    static class ModifiedFile
    implements ChangeLogSet.AffectedFile {
        private final String path;
        private final EditType editType;

        ModifiedFile(String path, EditType editType) {
            this.path = path;
            this.editType = editType;
        }

        public String getPath() {
            return this.path;
        }

        public EditType getEditType() {
            return this.editType;
        }
    }
}

