/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.qmetry.CreateZip;
import com.qmetry.FindFile;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.json.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@IgnoreJRERequirement
public class UploadToCloudV4 {
    public Map<String, String> uploadToTheCloud(String apikey, String file, boolean attachFile, Boolean matchTestSteps, String format, String testCycleToReuse, String environment, String build, String testCycleLabels, String testCycleComponents, String testCyclePriority, String testCycleStatus, String testCycleSprintId, String testCycleFixVersionId, String testCycleSummary, String testCycleCustomFields, String testCycleDescription, String testCycleAssignee, String testCycleReporter, String testCycleStartDate, String testCycleEndDate, String testCycleFolderId, String testCaseDescription, String testCasePrecondition, String testCaseAssignee, String testCaseReporter, String testCaseEstimatedTime, String testCaseLabels, String testCaseComponents, String testCasePriority, String testCaseStatus, String testCaseSprintId, String testCaseFixVersionId, String testCaseCustomFields, String testCaseFolderId, int buildnumber, Run<?, ?> run, TaskListener listener, FilePath workspace, String automationHierarchy, String appendTestName, String testCaseExecutionComment, String testCaseExecutionActualTime, String testCaseExecutionAssignee, String testCaseExecutionCustomFields, String testCaseExecutionPlannedDate, String region) throws MalformedURLException, IOException, UnsupportedEncodingException, ProtocolException, ParseException, FileNotFoundException, InterruptedException {
        JSONArray mJSONArray;
        JSONArray mJSONArray2;
        PrintStream logger = listener.getLogger();
        File resultFile = FindFile.findFile(file, run, listener, format, workspace);
        if (resultFile == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        InputStream is = null;
        String uploadcloudurlv4 = "";
        is = UploadToCloudV4.class.getClassLoader().getResourceAsStream("config.properties");
        Properties p = new Properties();
        p.load(is);
        uploadcloudurlv4 = region != null && !region.isEmpty() && Objects.equals(region, "Australia") ? p.getProperty("uploadcloudurlv4.aus") : p.getProperty("uploadcloudurlv4.us");
        logger.println("QMetry for JIRA : Using cloud URL : " + uploadcloudurlv4);
        String encoding = "UTF-8";
        URL url = new URL(uploadcloudurlv4);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        connection.setRequestProperty("apiKey", apikey.trim());
        connection.setDoInput(true);
        connection.setDoOutput(true);
        String filepath = "";
        boolean iszip = false;
        if (resultFile.isDirectory()) {
            iszip = true;
            listener.getLogger().println("QMetry for JIRA : Given Path is Directory.");
            listener.getLogger().println("QMetry for JIRA : Creating Zip...");
            filepath = CreateZip.createZip(resultFile.getAbsolutePath(), format, attachFile);
            listener.getLogger().println("QMetry for JIRA : Zip file path : " + filepath);
        } else {
            filepath = resultFile.getAbsolutePath();
            String fileExtension = "";
            if (filepath.contains(".") && filepath.lastIndexOf(".") != 0) {
                fileExtension = filepath.substring(filepath.lastIndexOf(".") + 1);
            }
            if (fileExtension.equals("zip")) {
                iszip = true;
            }
        }
        HashMap<String, Object> requestDataMap = new HashMap<String, Object>();
        String format_short = "";
        if (String.valueOf(format).equals("testng/xml")) {
            format_short = "testng";
        } else if (String.valueOf(format).equals("junit/xml")) {
            format_short = "junit";
        } else if (String.valueOf(format).equals("qas/json")) {
            format_short = "qaf";
        } else if (String.valueOf(format).equals("cucumber/json")) {
            format_short = "cucumber";
        } else if (String.valueOf(format).equals("hpuft/xml")) {
            format_short = "hpuft";
        } else if (String.valueOf(format).equals("specflow/json")) {
            format_short = "specflow";
        }
        if (format.equals("junit/xml") || format.equals("testng/xml")) {
            if (automationHierarchy != null && !automationHierarchy.isEmpty() && !automationHierarchy.equals("default")) {
                requestDataMap.put("automationHierarchy", Integer.parseInt(automationHierarchy));
            }
            if (!(appendTestName == null || appendTestName.isEmpty() || Objects.equals(automationHierarchy, "1") || appendTestName.equals("default"))) {
                requestDataMap.put("appendTestName", Boolean.parseBoolean(appendTestName));
            }
        }
        requestDataMap.put("format", String.valueOf(format_short));
        requestDataMap.put("isZip", String.valueOf(iszip));
        if (attachFile) {
            requestDataMap.put("attachFile", String.valueOf(attachFile));
        }
        requestDataMap.put("matchTestSteps", matchTestSteps);
        if (testCycleToReuse != null && !testCycleToReuse.isEmpty()) {
            requestDataMap.put("testCycleToReuse", testCycleToReuse.trim());
        }
        if (environment != null && !environment.isEmpty()) {
            requestDataMap.put("environment", environment.trim());
        }
        if (build != null && !build.isEmpty()) {
            requestDataMap.put("build", build.trim());
        }
        HashMap<String, Object> testcycleDataMap = new HashMap<String, Object>();
        boolean isTestcycle = false;
        if (testCycleLabels != null && !testCycleLabels.isEmpty()) {
            isTestcycle = true;
            mJSONArray2 = this.commaSepratedStringtoJson(testCycleLabels);
            testcycleDataMap.put("labels", mJSONArray2);
        }
        if (testCycleComponents != null && !testCycleComponents.isEmpty()) {
            isTestcycle = true;
            mJSONArray2 = this.commaSepratedStringtoJson(testCycleComponents);
            testcycleDataMap.put("components", mJSONArray2);
        }
        if (testCyclePriority != null && !testCyclePriority.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("priority", testCyclePriority.trim());
        }
        if (testCycleStatus != null && !testCycleStatus.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("status", testCycleStatus.trim());
        }
        if (testCycleSprintId != null && !testCycleSprintId.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("sprintId", testCycleSprintId.trim());
        }
        if (testCycleFixVersionId != null && !testCycleFixVersionId.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("fixVersionId", testCycleFixVersionId.trim());
        }
        if (testCycleFolderId != null && !testCycleFolderId.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("folderId", testCycleFolderId.trim());
        }
        if (testCycleSummary != null && !testCycleSummary.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("summary", testCycleSummary.trim() + "_" + buildnumber);
        }
        if (testCycleDescription != null && !testCycleDescription.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("description", testCycleDescription.trim());
        }
        if (testCycleStartDate != null && !testCycleStartDate.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("plannedStartDate", testCycleStartDate.trim());
        }
        if (testCycleEndDate != null && !testCycleEndDate.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("plannedEndDate", testCycleEndDate.trim());
        }
        if (testCycleAssignee != null && !testCycleAssignee.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("assignee", testCycleAssignee.trim());
        }
        if (testCycleReporter != null && !testCycleReporter.isEmpty()) {
            isTestcycle = true;
            testcycleDataMap.put("reporter", testCycleReporter.trim());
        }
        if (testCycleCustomFields != null && !testCycleCustomFields.isEmpty()) {
            isTestcycle = true;
            JSONParser parser = new JSONParser();
            org.json.simple.JSONArray testcycleCustomFieldsJson = (org.json.simple.JSONArray)parser.parse(testCycleCustomFields);
            testcycleDataMap.put("customFields", testcycleCustomFieldsJson);
        }
        HashMap<String, Object> testcaseDataMap = new HashMap<String, Object>();
        boolean isTestcase = false;
        if (testCaseLabels != null && !testCaseLabels.isEmpty()) {
            isTestcase = true;
            mJSONArray = this.commaSepratedStringtoJson(testCaseLabels);
            testcaseDataMap.put("labels", mJSONArray);
        }
        if (testCaseComponents != null && !testCaseComponents.isEmpty()) {
            isTestcase = true;
            mJSONArray = this.commaSepratedStringtoJson(testCaseComponents);
            testcaseDataMap.put("components", mJSONArray);
        }
        if (testCasePriority != null && !testCasePriority.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("priority", testCasePriority.trim());
        }
        if (testCaseStatus != null && !testCaseStatus.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("status", testCaseStatus.trim());
        }
        if (testCaseSprintId != null && !testCaseSprintId.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("sprintId", testCaseSprintId.trim());
        }
        if (testCaseFixVersionId != null && !testCaseFixVersionId.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("fixVersionId", testCaseFixVersionId.trim());
        }
        if (testCaseFolderId != null && !testCaseFolderId.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("folderId", testCaseFolderId.trim());
        }
        if (testCaseDescription != null && !testCaseDescription.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("description", testCaseDescription.trim());
        }
        if (testCasePrecondition != null && !testCasePrecondition.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("precondition", testCasePrecondition.trim());
        }
        if (testCaseAssignee != null && !testCaseAssignee.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("assignee", testCaseAssignee.trim());
        }
        if (testCaseReporter != null && !testCaseReporter.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("reporter", testCaseReporter.trim());
        }
        if (testCaseEstimatedTime != null && !testCaseEstimatedTime.isEmpty()) {
            isTestcase = true;
            testcaseDataMap.put("estimatedTime", testCaseEstimatedTime.trim());
        }
        if (testCaseCustomFields != null && !testCaseCustomFields.isEmpty()) {
            isTestcase = true;
            JSONParser parser = new JSONParser();
            org.json.simple.JSONArray testcaseCustomFieldsJson = (org.json.simple.JSONArray)parser.parse(testCaseCustomFields);
            testcaseDataMap.put("customFields", testcaseCustomFieldsJson);
        }
        HashMap<String, String> testCaseExecutionDataMap = new HashMap<String, String>();
        boolean isTestCaseExecution = false;
        if (testCaseExecutionComment != null && !testCaseExecutionComment.isEmpty()) {
            isTestCaseExecution = true;
            testCaseExecutionDataMap.put("comment", testCaseExecutionComment.trim());
        }
        if (testCaseExecutionActualTime != null && !testCaseExecutionActualTime.isEmpty()) {
            isTestCaseExecution = true;
            testCaseExecutionDataMap.put("actualTime", testCaseExecutionActualTime.trim());
        }
        if (testCaseExecutionAssignee != null && !testCaseExecutionAssignee.isEmpty()) {
            isTestCaseExecution = true;
            testCaseExecutionDataMap.put("assignee", testCaseExecutionAssignee.trim());
        }
        if (testCaseExecutionCustomFields != null && !testCaseExecutionCustomFields.isEmpty()) {
            isTestCaseExecution = true;
            JSONParser parser = new JSONParser();
            org.json.simple.JSONArray testCaseExecutionCustomFieldsJson = (org.json.simple.JSONArray)parser.parse(testCaseExecutionCustomFields);
            testCaseExecutionDataMap.put("customFields", (String)testCaseExecutionCustomFieldsJson);
        }
        if (testCaseExecutionPlannedDate != null && !testCaseExecutionPlannedDate.isEmpty()) {
            isTestCaseExecution = true;
            testCaseExecutionDataMap.put("executionPlannedDate", testCaseExecutionPlannedDate.trim());
        }
        HashMap<String, HashMap<String, Object>> testCaseCycleTcExecutionDataMap = new HashMap<String, HashMap<String, Object>>();
        if (isTestcycle) {
            testCaseCycleTcExecutionDataMap.put("testCycle", testcycleDataMap);
            logger.println("QMetry for JIRA : TestCycle  : " + testcycleDataMap);
        }
        if (isTestcase) {
            testCaseCycleTcExecutionDataMap.put("testCase", testcaseDataMap);
            logger.println("QMetry for JIRA : TestCase : " + testcaseDataMap);
        }
        if (isTestCaseExecution) {
            testCaseCycleTcExecutionDataMap.put("testCaseExecution", testCaseExecutionDataMap);
            logger.println("QMetry for JIRA : TestCaseExecution : " + testCaseExecutionDataMap);
        }
        requestDataMap.put("fields", testCaseCycleTcExecutionDataMap);
        JSONObject jsonbody = new JSONObject(requestDataMap);
        listener.getLogger().println("QMetry for JIRA : JsonBody : " + jsonbody);
        OutputStream os = connection.getOutputStream();
        os.write(jsonbody.toString().getBytes("UTF-8"));
        int statusCode = connection.getResponseCode();
        InputStream fis = null;
        fis = statusCode >= 200 && statusCode < 400 ? connection.getInputStream() : connection.getErrorStream();
        StringWriter response = new StringWriter();
        IOUtils.copy((InputStream)fis, (Writer)response, (String)encoding);
        JSONParser parser = new JSONParser();
        JSONObject obj = (JSONObject)parser.parse(response.toString());
        if (obj != null) {
            String resUrl = (String)obj.get((Object)"url");
            if (resUrl != null && !resUrl.isEmpty()) {
                String res = this.uploadToS3(response.toString(), filepath);
                map.put("success", "true");
                map.put("message", res);
            } else {
                map.put("success", "false");
                map.put("errorMessage", response.toString());
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadToS3(String response, String fileurl) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(response);
        JSONObject jsonObject = (JSONObject)obj;
        String urlForUpload = (String)jsonObject.get((Object)"url");
        URL url = new URL(urlForUpload);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "multipart/form-data");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        String encoding = "UTF-8";
        String responseValue = "";
        int count = 0;
        while (count < 3) {
            try (FileInputStream file = new FileInputStream(fileurl);){
                OutputStream os = connection.getOutputStream();
                IOUtils.copy((InputStream)file, (OutputStream)os);
                break;
            }
        }
        InputStream fis = connection.getInputStream();
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)fis, (Writer)writer, (String)encoding);
        responseValue = connection.getResponseCode() == 200 ? "Publishing results has been successful. \n Response: " + connection.getResponseMessage() + "\n" : "false";
        return responseValue;
    }

    public JSONArray commaSepratedStringtoJson(String commaSeparatedString) {
        String[] arrayStr = commaSeparatedString.split(",");
        JSONArray mJSONArray = new JSONArray();
        for (String s : arrayStr) {
            mJSONArray.put((Object)s.trim());
        }
        return mJSONArray;
    }
}

