/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.qmetry.CreateZip;
import com.qmetry.FindFile;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@IgnoreJRERequirement
public class UploadToCloud {
    public Map<String, String> uploadToTheCloud(String apikey, String file, boolean attachFile, String testrunname, String labels, String sprint, String versions, String components, String selection, String platform, String comment, String testrunkey, String testassethierarchy, String testCaseUpdateLevel, String jirafields, int buildnumber, Run<?, ?> run, TaskListener listener, FilePath workspace) throws MalformedURLException, IOException, UnsupportedEncodingException, ProtocolException, ParseException, FileNotFoundException, InterruptedException {
        File resultFile = FindFile.findFile(file, run, listener, selection, workspace);
        if (resultFile == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        InputStream is = null;
        String uploadcloudurl = "";
        is = UploadToCloud.class.getClassLoader().getResourceAsStream("config.properties");
        Properties p = new Properties();
        p.load(is);
        uploadcloudurl = p.getProperty("uploadcloudurl");
        String encoding = "UTF-8";
        URL url = new URL(uploadcloudurl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        if (testrunname != null && !testrunname.isEmpty()) {
            testrunname = testrunname.trim() + " #" + buildnumber;
        }
        String filepath = "";
        boolean iszip = false;
        if (resultFile.isDirectory()) {
            iszip = true;
            listener.getLogger().println("QMetry for JIRA : Given Path is Directory.");
            listener.getLogger().println("QMetry for JIRA : Creating Zip...");
            filepath = CreateZip.createZip(resultFile.getAbsolutePath(), selection, attachFile);
            listener.getLogger().println("QMetry for JIRA : Zip file path : " + filepath);
        } else {
            filepath = resultFile.getAbsolutePath();
            String fileExtension = "";
            if (filepath.contains(".") && filepath.lastIndexOf(".") != 0) {
                fileExtension = filepath.substring(filepath.lastIndexOf(".") + 1);
            }
            if (fileExtension.equals("zip")) {
                iszip = true;
            }
        }
        HashMap<String, String> requestDataMap = new HashMap<String, String>();
        requestDataMap.put("format", selection.trim());
        requestDataMap.put("testRunName", testrunname);
        requestDataMap.put("apiKey", apikey.trim());
        requestDataMap.put("isZip", String.valueOf(iszip));
        if (attachFile) {
            requestDataMap.put("attachFile", String.valueOf(attachFile));
        }
        if (platform != null && !platform.isEmpty()) {
            requestDataMap.put("platform", platform.trim());
        }
        if (labels != null && !labels.isEmpty()) {
            requestDataMap.put("labels", labels.trim());
        }
        if (versions != null && !versions.isEmpty()) {
            requestDataMap.put("versions", versions.trim());
        }
        if (components != null && !components.isEmpty()) {
            requestDataMap.put("components", components.trim());
        }
        if (sprint != null && !sprint.isEmpty()) {
            requestDataMap.put("sprint", sprint.trim());
        }
        if (comment != null && !comment.isEmpty()) {
            requestDataMap.put("comment", comment.trim());
        }
        if (testrunkey != null && !testrunkey.isEmpty()) {
            requestDataMap.put("testRunKey", testrunkey.trim());
        }
        if (testassethierarchy != null && !testassethierarchy.isEmpty()) {
            requestDataMap.put("testAssetHierarchy", testassethierarchy.trim());
            if (testassethierarchy.equals("TestCase-TestStep") && testCaseUpdateLevel != null && !testCaseUpdateLevel.isEmpty()) {
                requestDataMap.put("testCaseUpdateLevel", testCaseUpdateLevel);
            }
        }
        if (jirafields != null && !jirafields.isEmpty()) {
            JSONParser parser = new JSONParser();
            JSONArray jsonarray = (JSONArray)parser.parse(jirafields.trim());
            requestDataMap.put("JIRAFields", (String)jsonarray);
        }
        JSONObject jsonbody = new JSONObject(requestDataMap);
        OutputStream os = connection.getOutputStream();
        os.write(jsonbody.toString().getBytes("UTF-8"));
        InputStream fis = connection.getInputStream();
        StringWriter response = new StringWriter();
        IOUtils.copy((InputStream)fis, (Writer)response, (String)encoding);
        JSONParser parser = new JSONParser();
        JSONObject obj = (JSONObject)parser.parse(response.toString());
        if (obj != null) {
            Boolean success = (Boolean)obj.get((Object)"isSuccess");
            if (success.booleanValue()) {
                String res = this.uploadToS3(response.toString(), filepath);
                map.put("success", "true");
                map.put("message", res);
            } else {
                String errorMessage = (String)obj.get((Object)"errorMessage");
                map.put("success", "false");
                map.put("errorMessage", errorMessage);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadToS3(String response, String fileurl) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(response);
        JSONObject jsonObject = (JSONObject)obj;
        String urlForUpload = (String)jsonObject.get((Object)"url");
        URL url = new URL(urlForUpload);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "multipart/form-data");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        String encoding = "UTF-8";
        String responseValue = "";
        int count = 0;
        while (count < 3) {
            try (FileInputStream file = new FileInputStream(fileurl);){
                OutputStream os = connection.getOutputStream();
                IOUtils.copy((InputStream)file, (OutputStream)os);
                break;
            }
        }
        InputStream fis = connection.getInputStream();
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)fis, (Writer)writer, (String)encoding);
        responseValue = connection.getResponseCode() == 200 ? "Publishing results has been successful. \n Response: " + connection.getResponseMessage() + "\n" : "false";
        return responseValue;
    }
}

