/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.slaves.SlaveComputer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class FindFile {
    private static boolean onSlave = false;
    private static File resultFile;
    private static File qtm4jFile;

    public static boolean getOnSlave() {
        return onSlave;
    }

    public static File getQtm4jFile() {
        return qtm4jFile;
    }

    public static File findFile(String filePath, Run<?, ?> run, TaskListener listener, String format, FilePath workspace) throws IOException, InterruptedException, FileNotFoundException {
        Computer comp1;
        Node node;
        Computer comp;
        onSlave = false;
        resultFile = null;
        qtm4jFile = null;
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        if (workspace != null && (comp = workspace.toComputer()) != null && (node = comp.getNode()) != null && (comp1 = node.toComputer()) != null) {
            if (comp1 instanceof SlaveComputer) {
                File finalResultFile;
                AbstractProject project;
                onSlave = true;
                listener.getLogger().println("QMetry for JIRA : build taking place on slave machine");
                FilePath slaveMachineWorkspace = workspace;
                FilePath f = null;
                f = new FilePath(slaveMachineWorkspace, filePath);
                if (!f.exists()) {
                    throw new FileNotFoundException("cannot find file : " + f);
                }
                if (f.isDirectory()) {
                    String absPath = f.toString();
                    if (!filePath.endsWith("/")) {
                        filePath = filePath.concat("/");
                    }
                }
                if (!slaveMachineWorkspace.exists()) {
                    listener.getLogger().println("QMetry for JIRA : [ERROR]Failed to access slave machine workspace directory");
                    return null;
                }
                FilePath masterMachineWorkspace = null;
                if (run.getParent() instanceof AbstractProject) {
                    project = (AbstractProject)run.getParent();
                    masterMachineWorkspace = project.getCustomWorkspace() != null && project.getCustomWorkspace().length() > 0 ? new FilePath(new File(project.getCustomWorkspace())) : Jenkins.getInstance().getWorkspaceFor((TopLevelItem)project);
                } else if (run.getParent() instanceof WorkflowJob) {
                    project = (WorkflowJob)run.getParent();
                    masterMachineWorkspace = Jenkins.getInstance().getWorkspaceFor((TopLevelItem)project);
                }
                if (masterMachineWorkspace == null) {
                    listener.getLogger().println("QMetry for JIRA : [ERROR]Failed to access master machine workspace directory");
                    return null;
                }
                masterMachineWorkspace = new FilePath(masterMachineWorkspace, "QTM4J");
                slaveMachineWorkspace.copyRecursiveTo(filePath, masterMachineWorkspace);
                qtm4jFile = finalResultFile = new File(masterMachineWorkspace.toURI());
                resultFile = new File(finalResultFile, filePath);
                return resultFile;
            }
            if (comp1 instanceof Hudson.MasterComputer) {
                onSlave = false;
                File masterWorkspace = new File(workspace.toString());
                FilePath resultFilePath = null;
                resultFilePath = new FilePath(new File(masterWorkspace, filePath));
                if (!resultFilePath.exists()) {
                    throw new FileNotFoundException("cannot find file : " + resultFilePath);
                }
                resultFile = new File(resultFilePath.toString());
                return resultFile;
            }
        }
        return null;
    }

    public static FilePath lastFileModified(FilePath base, String path) throws IOException, InterruptedException, FileNotFoundException {
        FilePath slaveDir = new FilePath(base, path);
        if (!slaveDir.exists()) {
            throw new FileNotFoundException("cannot find file : " + slaveDir);
        }
        List files = slaveDir.listDirectories();
        long lastMod = Long.MIN_VALUE;
        FilePath choice = null;
        if (files != null) {
            for (FilePath file : files) {
                if (!file.isDirectory() || file.getName().equals("surefire") || file.lastModified() <= lastMod) continue;
                choice = file;
                lastMod = file.lastModified();
            }
        }
        return choice;
    }
}

