/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class CreateZip {
    public static final FileFilter XML_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
        }
    };
    public static final FileFilter JSON_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".json");
        }
    };
    public static final FileFilter PNG_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".png");
        }
    };

    public static String createZip(String sourceDir, String formats, boolean attachFile) throws IOException, FileNotFoundException {
        String zipDir = sourceDir + "/testresult.zip";
        CreateZip.zipDirectory(sourceDir, zipDir, formats, attachFile);
        return zipDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDirectory(String sourceDir, String zipfile, String formats, boolean attachFile) throws IOException {
        String extention = "";
        if (formats.equals("junit/xml") || formats.equals("testng/xml") || formats.equals("hpuft/xml")) {
            extention = "xml";
        } else if (formats.equals("qas/json") || formats.equals("cucumber/json") || formats.equals("specflow/json")) {
            extention = "json";
        }
        File dir = new File(sourceDir);
        File zipFile = new File(zipfile);
        FileOutputStream fout = new FileOutputStream(zipFile, false);
        ZipOutputStream zout = new ZipOutputStream(fout);
        CreateZip.zipSubDirectory("", dir, zout, extention);
        if (attachFile && formats.equals("qas/json")) {
            File imageDir = new File(sourceDir + "/img");
            String imageExtention = "png";
            CreateZip.zipSubDirectory("img/", imageDir, zout, imageExtention);
        }
        zout.close();
        try (ZipFile zf = new ZipFile(zipfile);){
            int size = zf.size();
            if (size == 0) {
                throw new FileNotFoundException("cannot find files of proper format in directory : " + sourceDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipSubDirectory(String basePath, File dir, ZipOutputStream zout, String extention) throws IOException {
        byte[] buffer = new byte[1024];
        File[] files = null;
        if (extention.equals("xml")) {
            files = dir.listFiles(XML_FILE_FILTER);
        } else if (extention.equals("json")) {
            files = dir.listFiles(JSON_FILE_FILTER);
        } else if (extention.equals("png")) {
            files = dir.listFiles(PNG_FILE_FILTER);
        }
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    String path = basePath + file.getName() + "/";
                    CreateZip.zipSubDirectory(path, file, zout, extention);
                    continue;
                }
                zout.putNextEntry(new ZipEntry(basePath + file.getName()));
                FileInputStream fin = null;
                try {
                    int length;
                    fin = new FileInputStream(file);
                    while ((length = fin.read(buffer)) >= 0) {
                        zout.write(buffer, 0, length);
                    }
                }
                finally {
                    if (fin != null) {
                        fin.close();
                    }
                    zout.closeEntry();
                }
            }
        }
    }
}

