/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_cifs.descriptor;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPValidators;
import jenkins.plugins.publish_over_cifs.CifsHostConfiguration;
import jenkins.plugins.publish_over_cifs.CifsNodeProperties;
import jenkins.plugins.publish_over_cifs.CifsPublisherPlugin;
import jenkins.plugins.publish_over_cifs.Messages;
import jenkins.plugins.publish_over_cifs.options.CifsDefaults;
import jenkins.plugins.publish_over_cifs.options.CifsPluginDefaults;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

public class CifsPublisherPluginDescriptor
extends BuildStepDescriptor<Publisher> {
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private CifsPublisherPlugin.DescriptorMessages msg;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private Class hostConfigClass;
    private final CopyOnWriteList<CifsHostConfiguration> hostConfigurations = new CopyOnWriteList();
    private CifsDefaults defaults;

    public CifsPublisherPluginDescriptor() {
        super(CifsPublisherPlugin.class);
        this.load();
        if (this.defaults == null) {
            this.defaults = new CifsPluginDefaults();
        }
    }

    public CifsDefaults getDefaults() {
        return this.defaults;
    }

    @NonNull
    public String getDisplayName() {
        return Messages.descriptor_displayName();
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return !"hudson.plugins.promoted_builds.PromotionProcess".equals(aClass.getCanonicalName());
    }

    public List<CifsHostConfiguration> getHostConfigurations() {
        return this.hostConfigurations.getView();
    }

    public CifsHostConfiguration getConfiguration(String name) {
        for (CifsHostConfiguration configuration : this.hostConfigurations) {
            if (!configuration.getName().equals(name)) continue;
            return configuration;
        }
        return null;
    }

    public void addHostConfiguration(CifsHostConfiguration configuration) {
        this.hostConfigurations.add((Object)configuration);
    }

    public void removeHostConfiguration(String name) {
        CifsHostConfiguration configuration = this.getConfiguration(name);
        if (configuration != null) {
            this.hostConfigurations.remove((Object)configuration);
        }
    }

    public boolean configure(StaplerRequest2 request, JSONObject formData) {
        this.hostConfigurations.replaceBy((Collection)request.bindJSONToList(CifsHostConfiguration.class, formData.get("instance")));
        if (this.isEnableOverrideDefaults()) {
            this.defaults = (CifsDefaults)request.bindJSON(CifsDefaults.class, formData.getJSONObject("defaults"));
        }
        this.save();
        return true;
    }

    public FormValidation doCheckName(@QueryParameter String value) {
        return BPValidators.validateName((String)value);
    }

    public FormValidation doCheckHostname(@QueryParameter String value) {
        return FormValidation.validateRequired((String)value);
    }

    public FormValidation doCheckUsername(@QueryParameter String value) {
        return FormValidation.validateRequired((String)value);
    }

    public FormValidation doCheckPort(@QueryParameter String value) {
        return FormValidation.validatePositiveInteger((String)value);
    }

    public FormValidation doCheckTimeout(@QueryParameter String value) {
        return FormValidation.validateNonNegativeInteger((String)value);
    }

    public FormValidation doCheckBufferSize(@QueryParameter String value) {
        return FormValidation.validatePositiveInteger((String)value);
    }

    public FormValidation doCheckSourceFiles(@QueryParameter String value) {
        return FormValidation.validateRequired((String)value);
    }

    public FormValidation doCheckRemoteRootDir(@QueryParameter String value) {
        return FormValidation.validateRequired((String)value);
    }

    public FormValidation doCheckRetries(@QueryParameter String value) {
        return FormValidation.validateNonNegativeInteger((String)value);
    }

    public FormValidation doCheckRetryDelay(@QueryParameter String value) {
        return FormValidation.validatePositiveInteger((String)value);
    }

    public String getDefaultMasterNodeName() {
        return "master";
    }

    public boolean canSetMasterNodeName() {
        return false;
    }

    public boolean isEnableOverrideDefaults() {
        return true;
    }

    public CifsPublisherPluginDescriptor getPublisherDescriptor() {
        return this;
    }

    public CifsDefaults.CifsDefaultsDescriptor getPluginDefaultsDescriptor() {
        return (CifsDefaults.CifsDefaultsDescriptor)Jenkins.get().getDescriptor(CifsDefaults.class);
    }

    public jenkins.plugins.publish_over.view_defaults.manage_jenkins.Messages getCommonManageMessages() {
        return new jenkins.plugins.publish_over.view_defaults.manage_jenkins.Messages();
    }

    @POST
    public FormValidation doTestConnection(StaplerRequest2 request, StaplerResponse2 response) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        CifsHostConfiguration hostConfig = (CifsHostConfiguration)((Object)request.bindParameters(CifsHostConfiguration.class, ""));
        request.bindParameters((Object)hostConfig);
        BPBuildInfo buildInfo = this.createDummyBuildInfo(request);
        try {
            hostConfig.createClient(buildInfo).disconnect();
            return FormValidation.ok((String)Messages.descriptor_testConnection_ok());
        }
        catch (Exception e) {
            return FormValidation.errorWithMarkup((String)("<p>" + Messages.descriptor_testConnection_error() + "</p><p><pre>" + Util.escape((String)(e.getClass().getCanonicalName() + ": " + e.getLocalizedMessage())) + "</pre></p>"));
        }
    }

    protected BPBuildInfo createDummyBuildInfo(StaplerRequest2 request) {
        BPBuildInfo buildInfo = new BPBuildInfo(TaskListener.NULL, "", Jenkins.get().getRootPath(), null, null);
        CifsNodeProperties defaults = (CifsNodeProperties)((Object)request.bindParameters(CifsNodeProperties.class, "poc-np."));
        if (defaults != null && Util.fixEmptyAndTrim((String)defaults.getWinsServer()) != null) {
            buildInfo.put("cifs.winsServer", (Serializable)((Object)defaults.getWinsServer().trim()));
        }
        return buildInfo;
    }

    public Object readResolve() {
        this.msg = null;
        this.hostConfigClass = null;
        if (this.defaults == null) {
            this.defaults = new CifsPluginDefaults();
        }
        return this;
    }

    public jenkins.plugins.publish_over.view_defaults.HostConfiguration.Messages getHostConfigurationFieldNames() {
        return new jenkins.plugins.publish_over.view_defaults.HostConfiguration.Messages();
    }

    public jenkins.plugins.publish_over.view_defaults.BapPublisher.Messages getPublisherFieldNames() {
        return new jenkins.plugins.publish_over.view_defaults.BapPublisher.Messages();
    }

    public jenkins.plugins.publish_over.view_defaults.BPInstanceConfig.Messages getPluginFieldNames() {
        return new jenkins.plugins.publish_over.view_defaults.BPInstanceConfig.Messages();
    }

    public jenkins.plugins.publish_over.view_defaults.BPTransfer.Messages getTransferFieldNames() {
        return new jenkins.plugins.publish_over.view_defaults.BPTransfer.Messages();
    }

    public jenkins.plugins.publish_over.view_defaults.ParamPublish.Messages getParamPublishFieldNames() {
        return new jenkins.plugins.publish_over.view_defaults.ParamPublish.Messages();
    }

    public jenkins.plugins.publish_over.view_defaults.PublisherLabel.Messages getPublisherLabelFieldNames() {
        return new jenkins.plugins.publish_over.view_defaults.PublisherLabel.Messages();
    }

    public jenkins.plugins.publish_over.view_defaults.Retry.Messages getRetryFieldNames() {
        return new jenkins.plugins.publish_over.view_defaults.Retry.Messages();
    }
}

