/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus;

import com.cloudbees.simplediskusage.DiskItem;
import com.cloudbees.simplediskusage.JobDiskItem;
import com.cloudbees.simplediskusage.QuickDiskUsagePlugin;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.prometheus.client.Collector;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.prometheus.collectors.CollectorFactory;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.MetricCollector;
import org.jenkinsci.plugins.prometheus.config.PrometheusConfiguration;
import org.jenkinsci.plugins.prometheus.config.disabledmetrics.MetricStatusChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskUsageCollector
extends Collector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskUsageCollector.class);

    @NonNull
    public List<Collector.MetricFamilySamples> collect() {
        if (!PrometheusConfiguration.get().getCollectDiskUsage()) {
            return Collections.emptyList();
        }
        try {
            return DiskUsageCollector.collectDiskUsage();
        }
        catch (IOException | RuntimeException e) {
            LOGGER.warn("Failed to get disk usage data due to an unexpected error.", (Throwable)e);
            return Collections.emptyList();
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("Cannot collect disk usage data because plugin CloudBees Disk Usage Simple is not installed: {}", (Object)e.toString());
            LOGGER.info("You can remove this warning if you disable Collect Disk Usage in Prometheus Configuration.");
            return Collections.emptyList();
        }
    }

    @NonNull
    private static List<Collector.MetricFamilySamples> collectDiskUsage() throws IOException {
        QuickDiskUsagePlugin diskUsagePlugin = (QuickDiskUsagePlugin)Jenkins.get().getPlugin(QuickDiskUsagePlugin.class);
        if (diskUsagePlugin == null) {
            return Collections.emptyList();
        }
        CollectorFactory factory = new CollectorFactory();
        HashSet usedFileStores = new HashSet();
        ArrayList<MetricCollector<DiskItem, ? extends Collector>> diskItemCollectors = new ArrayList<MetricCollector<DiskItem, ? extends Collector>>();
        diskItemCollectors.add(factory.createDiskItemCollector(CollectorType.DISK_USAGE_BYTES_GAUGE, new String[]{"file_store", "directory"}));
        diskItemCollectors.add(factory.createDiskItemCollector(CollectorType.DISK_USAGE_FILE_COUNT_GAUGE, new String[]{"file_store", "directory"}));
        diskUsagePlugin.getDirectoriesUsages().forEach(i -> {
            Optional<FileStore> fileStore = DiskUsageCollector.getFileStore(i.getPath());
            fileStore.ifPresent(usedFileStores::add);
            diskItemCollectors.forEach(c -> c.calculateMetric(i, new String[]{DiskUsageCollector.toLabelValue(fileStore), i.getDisplayName()}));
        });
        ArrayList<MetricCollector<JobDiskItem, ? extends Collector>> jobDiskItemCollectors = new ArrayList<MetricCollector<JobDiskItem, ? extends Collector>>();
        jobDiskItemCollectors.add(factory.createJobDiskItemCollector(CollectorType.JOB_USAGE_BYTES_GAUGE, new String[]{"file_store", "jobName", "url"}));
        diskUsagePlugin.getJobsUsages().forEach(i -> {
            if (!MetricStatusChecker.isJobEnabled(i.getFullName())) {
                return;
            }
            Optional<FileStore> fileStore = DiskUsageCollector.getFileStore(i.getPath());
            fileStore.ifPresent(usedFileStores::add);
            jobDiskItemCollectors.forEach(c -> c.calculateMetric(i, new String[]{DiskUsageCollector.toLabelValue(fileStore), i.getFullName(), i.getUrl()}));
        });
        ArrayList<MetricCollector<FileStore, ? extends Collector>> fileStoreCollectors = new ArrayList<MetricCollector<FileStore, ? extends Collector>>();
        fileStoreCollectors.add(factory.createFileStoreCollector(CollectorType.FILE_STORE_CAPACITY_GAUGE, new String[]{"file_store"}));
        fileStoreCollectors.add(factory.createFileStoreCollector(CollectorType.FILE_STORE_AVAILABLE_GAUGE, new String[]{"file_store"}));
        usedFileStores.forEach(store -> {
            String labelValue = DiskUsageCollector.toLabelValue(Optional.of(store));
            fileStoreCollectors.forEach(c -> c.calculateMetric(store, new String[]{labelValue}));
        });
        ArrayList<Collector.MetricFamilySamples> samples = new ArrayList<Collector.MetricFamilySamples>();
        samples.addAll(Stream.of(diskItemCollectors).flatMap(Collection::stream).map(MetricCollector::collect).flatMap(Collection::stream).collect(Collectors.toList()));
        samples.addAll(Stream.of(jobDiskItemCollectors).flatMap(Collection::stream).map(MetricCollector::collect).flatMap(Collection::stream).collect(Collectors.toList()));
        samples.addAll(Stream.of(fileStoreCollectors).flatMap(Collection::stream).map(MetricCollector::collect).flatMap(Collection::stream).collect(Collectors.toList()));
        return samples;
    }

    private static String toLabelValue(Optional<FileStore> fileStore) {
        return fileStore.map(Object::toString).orElse("<unknown>");
    }

    private static Optional<FileStore> getFileStore(File file) {
        try {
            return Optional.of(Files.getFileStore(file.toPath().toRealPath(new LinkOption[0])));
        }
        catch (IOException | RuntimeException e) {
            LOGGER.debug("Failed to get file store for {}", (Object)file, (Object)e);
            return Optional.empty();
        }
    }
}

