/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pluginusage.analyzer;

import hudson.PluginWrapper;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pluginusage.analyzer.AbstractProjectAnalyzer;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.CoreStep;
import org.jenkinsci.plugins.workflow.steps.CoreWrapperStep;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

class PipelineLastBuildAnalyzer
extends AbstractProjectAnalyzer {
    private final boolean hasPlugin = Jenkins.get().getPlugin("pipeline-model-definition") != null;

    @Override
    protected Set<PluginWrapper> getPluginsFromBuilders(Item item) {
        HashSet<PluginWrapper> plugins = new HashSet<PluginWrapper>();
        if (!this.hasPlugin) {
            return plugins;
        }
        if (item instanceof WorkflowJob) {
            WorkflowJob workflowJob = (WorkflowJob)item;
            HashSet<WorkflowRun> jobs = new HashSet<WorkflowRun>();
            jobs.add(workflowJob.getLastBuild());
            jobs.add((WorkflowRun)workflowJob.getLastSuccessfulBuild());
            jobs.add((WorkflowRun)workflowJob.getLastCompletedBuild());
            jobs.add((WorkflowRun)workflowJob.getLastStableBuild());
            jobs.forEach(build -> this.processRun((Set<PluginWrapper>)plugins, (WorkflowRun)build));
        }
        return plugins;
    }

    private void processRun(Set<PluginWrapper> plugins, WorkflowRun lastBuild) {
        if (lastBuild == null) {
            return;
        }
        FlowExecution execution = lastBuild.getExecution();
        if (execution == null) {
            return;
        }
        List currentHeads = execution.getCurrentHeads();
        DepthFirstScanner depthFirstScanner = new DepthFirstScanner();
        depthFirstScanner.visitAll((Collection)currentHeads, f -> {
            StepStartNode startNode;
            StepDescriptor stepDescriptor;
            if (f instanceof StepStartNode && (stepDescriptor = (startNode = (StepStartNode)f).getDescriptor()) != null) {
                plugins.add(this.getPluginFromClass(stepDescriptor.clazz));
            }
            if (f instanceof StepAtomNode) {
                StepAtomNode stepAtomNode = (StepAtomNode)f;
                stepDescriptor = stepAtomNode.getDescriptor();
                if (stepDescriptor != null) {
                    plugins.add(this.getPluginFromClass(stepDescriptor.clazz));
                }
                if (stepDescriptor.isMetaStep()) {
                    if (stepDescriptor instanceof CoreStep.DescriptorImpl) {
                        this.coreStepProcess(plugins, f);
                    }
                    if (stepDescriptor instanceof CoreWrapperStep.DescriptorImpl) {
                        this.coreStepProcess(plugins, f);
                    }
                }
            }
            return true;
        });
    }

    private void coreStepProcess(Set<PluginWrapper> plugins, FlowNode f) {
        Descriptor descriptor;
        UninstantiatedDescribable describable;
        Map arguments = ArgumentsAction.getFilteredArguments((FlowNode)f);
        if (arguments.get("delegate") instanceof UninstantiatedDescribable && (describable = (UninstantiatedDescribable)arguments.get("delegate")) != null && (descriptor = SymbolLookup.get().findDescriptor(Describable.class, describable.getSymbol())) != null) {
            plugins.add(this.getPluginFromClass(descriptor.clazz));
        }
    }
}

