/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pluginusage;

import hudson.BulkChange;
import hudson.PluginWrapper;
import hudson.XmlFile;
import hudson.model.Item;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pluginusage.JobsPerPlugin;
import org.springframework.security.access.AccessDeniedException;

public class PersistedModel
implements Saveable {
    private static final Logger LOGGER = Logger.getLogger(PersistedModel.class.getName());
    private String timestamp;
    private Map<String, Set<String>> jobsPerPluginMap;

    public synchronized void save() {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        try {
            this.getConfigFile().write((Object)this);
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.getConfigFile());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + String.valueOf(this.getConfigFile()), e);
        }
    }

    public synchronized void load() {
        XmlFile file = this.getConfigFile();
        if (!file.exists()) {
            return;
        }
        try {
            file.unmarshal((Object)this);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load " + String.valueOf(file), e);
        }
    }

    protected XmlFile getConfigFile() {
        return new XmlFile(new File(Jenkins.get().getRootDir(), "plugin-usage.xml"));
    }

    public Map<PluginWrapper, JobsPerPlugin> getJobsPerPlugin() {
        if (this.jobsPerPluginMap == null) {
            return Map.of();
        }
        return this.jobsPerPluginMap.entrySet().stream().filter(e -> Jenkins.get().getPluginManager().getPlugin((String)e.getKey()) != null).collect(Collectors.toMap(e -> Jenkins.get().getPluginManager().getPlugin((String)e.getKey()), e -> {
            PluginWrapper plugin = Jenkins.get().getPluginManager().getPlugin((String)e.getKey());
            JobsPerPlugin jobsPerPlugin = new JobsPerPlugin(plugin);
            ((Set)e.getValue()).stream().map(PersistedModel::getItemByFullName).filter(Objects::nonNull).forEach(jobsPerPlugin::addProject);
            return jobsPerPlugin;
        }));
    }

    private static Item getItemByFullName(String fullName) {
        try {
            return Jenkins.get().getItemByFullName(fullName);
        }
        catch (AccessDeniedException e) {
            return null;
        }
    }

    public void setJobsPerPlugin(Map<PluginWrapper, JobsPerPlugin> jobsPerPlugin) {
        this.jobsPerPluginMap = jobsPerPlugin.entrySet().stream().collect(Collectors.toMap(e -> ((PluginWrapper)e.getKey()).getShortName(), e -> ((JobsPerPlugin)e.getValue()).getProjects().stream().map(Item::getFullName).collect(Collectors.toSet())));
    }

    public Instant getTimestamp() {
        if (this.timestamp != null) {
            return Instant.parse(this.timestamp);
        }
        return null;
    }

    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp.toString();
    }
}

