/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pluginusage;

import hudson.PluginWrapper;
import hudson.model.Item;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class JobsPerPlugin {
    private PluginWrapper plugin;
    private Map<String, Item> jobMap = new HashMap<String, Item>();

    public JobsPerPlugin(PluginWrapper plugin) {
        this.plugin = plugin;
    }

    public void addProject(Item project) {
        this.jobMap.put(project.getFullDisplayName(), project);
    }

    @Exported
    public List<Item> getProjects() {
        ArrayList<Item> projects = new ArrayList<Item>(this.jobMap.values());
        projects.sort(Comparator.comparing(Item::getName));
        return projects;
    }

    public String getPluginName() {
        return this.plugin.getDisplayName();
    }

    public String getPluginVersion() {
        return this.plugin.getVersion();
    }

    public int getNumberOfJobs() {
        return this.jobMap.size();
    }

    @Exported
    public PluginWrapper getPlugin() {
        return this.plugin;
    }

    public boolean hasDependants() {
        return this.plugin.hasMandatoryDependents();
    }
}

