/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.eventspy.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.AbstractMavenEventHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.reporter.MavenEventReporter;

public abstract class AbstractExecutionHandler
extends AbstractMavenEventHandler<ExecutionEvent> {
    protected AbstractExecutionHandler(@NonNull MavenEventReporter reporter) {
        super(reporter);
    }

    @Override
    public boolean handle(@NonNull Object event) {
        if (!(event instanceof ExecutionEvent)) {
            return false;
        }
        ExecutionEvent executionEvent = (ExecutionEvent)event;
        ExecutionEvent.Type supportedType = this.getSupportedType();
        if (supportedType != null && !supportedType.equals((Object)executionEvent.getType())) {
            return false;
        }
        String supportedGoal = this.getSupportedPluginGoal();
        if (supportedGoal == null) {
            return this._handle(executionEvent);
        }
        String[] gag = supportedGoal.split(":");
        if (gag.length == 3) {
            MojoExecution execution = executionEvent.getMojoExecution();
            if (execution.getGroupId().equals(gag[0]) && execution.getArtifactId().equals(gag[1]) && execution.getGoal().equals(gag[2])) {
                this._handle(executionEvent);
                return true;
            }
            return false;
        }
        this.reporter.print(this.toString() + " - unsupported supportedPluginGoal:" + supportedGoal);
        return false;
    }

    @Override
    public boolean _handle(@NonNull ExecutionEvent executionEvent) {
        List<String> configurationParameters = this.getConfigurationParametersToReport(executionEvent);
        Xpp3Dom root = new Xpp3Dom("ExecutionEvent");
        root.setAttribute("class", executionEvent.getClass().getName());
        root.setAttribute("type", executionEvent.getType().name());
        root.addChild(this.newElement("project", executionEvent.getProject()));
        MojoExecution execution = executionEvent.getMojoExecution();
        if (execution == null) {
            root.addChild(new Xpp3Dom("no-execution-found"));
        } else {
            Xpp3Dom plugin = new Xpp3Dom("plugin");
            root.addChild(plugin);
            plugin.setAttribute("groupId", execution.getGroupId());
            plugin.setAttribute("artifactId", execution.getArtifactId());
            plugin.setAttribute("goal", execution.getGoal());
            plugin.setAttribute("version", execution.getVersion());
            if (execution.getExecutionId() != null) {
                plugin.setAttribute("executionId", execution.getExecutionId());
            }
            if (execution.getLifecyclePhase() != null) {
                plugin.setAttribute("lifecyclePhase", execution.getLifecyclePhase());
            }
            for (String configurationParameter : configurationParameters) {
                Xpp3Dom element = this.fullClone(configurationParameter, execution.getConfiguration().getChild(configurationParameter));
                if (element == null) continue;
                plugin.addChild(element);
            }
        }
        this.addDetails(executionEvent, root);
        if (executionEvent.getException() != null) {
            root.addChild(this.newElement("exception", executionEvent.getException()));
        }
        this.reporter.print(root);
        return true;
    }

    protected void addDetails(@NonNull ExecutionEvent executionEvent, @NonNull Xpp3Dom root) {
    }

    @NonNull
    protected abstract List<String> getConfigurationParametersToReport(ExecutionEvent var1);

    @Nullable
    protected abstract ExecutionEvent.Type getSupportedType();

    @Nullable
    protected String getSupportedPluginGoal() {
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.getSupportedType() + "," + this.getSupportedPluginGoal() + "]";
    }

    @Nullable
    protected String getMojoConfigurationValue(@NonNull MojoExecution execution, @NonNull String elementName) {
        Xpp3Dom element = execution.getConfiguration().getChild(elementName);
        return element == null ? null : (element.getValue() == null ? element.getAttribute("default-value") : element.getValue());
    }

    @Nullable
    protected Xpp3Dom fullClone(@NonNull String elementName, @Nullable Xpp3Dom element) {
        if (element == null) {
            return null;
        }
        Xpp3Dom result = new Xpp3Dom(elementName);
        Xpp3Dom[] childs = element.getChildren();
        if (childs != null && childs.length > 0) {
            for (Xpp3Dom child : childs) {
                result.addChild(this.fullClone(child.getName(), child));
            }
        } else {
            result.setValue(element.getValue() == null ? element.getAttribute("default-value") : element.getValue());
        }
        return result;
    }
}

