/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.eventspy.reporter;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.jenkinsci.plugins.pipeline.maven.eventspy.reporter.MavenEventReporter;

public class OutputStreamEventReporter
implements MavenEventReporter {
    final PrintWriter out;
    final XMLWriter xmlWriter;

    public OutputStreamEventReporter(OutputStream out) {
        this(new OutputStreamWriter(out, Charset.forName("UTF-8")));
    }

    public OutputStreamEventReporter(Writer out) {
        this.out = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out, true);
        this.xmlWriter = new PrettyPrintXMLWriter(out);
        this.xmlWriter.startElement("mavenExecution");
    }

    @Override
    public synchronized void print(Object message) {
        String comment = new Timestamp(System.currentTimeMillis()) + " - " + message;
        XmlWriterUtil.writeComment((XMLWriter)this.xmlWriter, (String)comment);
        XmlWriterUtil.writeLineBreak((XMLWriter)this.xmlWriter);
        this.out.flush();
    }

    @Override
    public synchronized void print(Xpp3Dom element) {
        Xpp3DomWriter.write((XMLWriter)this.xmlWriter, (Xpp3Dom)element);
        XmlWriterUtil.writeLineBreak((XMLWriter)this.xmlWriter);
        this.out.flush();
    }

    @Override
    public synchronized void close() {
        this.xmlWriter.endElement();
        this.out.flush();
    }
}

