/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.eventspy.reporter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.jenkinsci.plugins.pipeline.maven.eventspy.RuntimeIOException;
import org.jenkinsci.plugins.pipeline.maven.eventspy.reporter.MavenEventReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMavenEventReporter
implements MavenEventReporter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    File outFile;
    PrintWriter out;
    XMLWriter xmlWriter;
    boolean isOpen;

    public FileMavenEventReporter() throws IOException {
        File reportsFolder;
        String reportsFolderPath = System.getProperty("org.jenkinsci.plugins.pipeline.maven.reportsFolder");
        if (reportsFolderPath == null) {
            reportsFolder = new File(".");
        } else {
            boolean created;
            reportsFolder = new File(reportsFolderPath);
            if (!reportsFolder.exists() && !(created = reportsFolder.mkdirs())) {
                reportsFolder = new File(".");
                this.logger.warn("[jenkins-event-spy] Failure to create folder '" + reportsFolder.getAbsolutePath() + "', generate report in '" + reportsFolder.getAbsolutePath() + "'");
            }
        }
        String now = new SimpleDateFormat("yyyyMMdd-HHmmss-S").format(new Date());
        this.outFile = File.createTempFile("maven-spy-" + now, ".log.tmp", reportsFolder);
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outFile), "UTF-8"));
        this.xmlWriter = new PrettyPrintXMLWriter(this.out);
        this.xmlWriter.startElement("mavenExecution");
        this.xmlWriter.addAttribute("_time", new Timestamp(System.currentTimeMillis()).toString());
        try {
            this.logger.info("[jenkins-event-spy] Generate " + this.outFile.getCanonicalPath() + " ...");
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        this.isOpen = true;
    }

    @Override
    public synchronized void print(Object message) {
        XmlWriterUtil.writeComment((XMLWriter)this.xmlWriter, (String)(new Timestamp(System.currentTimeMillis()) + " - " + message));
        XmlWriterUtil.writeLineBreak((XMLWriter)this.xmlWriter);
    }

    @Override
    public synchronized void print(Xpp3Dom element) {
        element.setAttribute("_time", new Timestamp(System.currentTimeMillis()).toString());
        Xpp3DomWriter.write((XMLWriter)this.xmlWriter, (Xpp3Dom)element);
        XmlWriterUtil.writeLineBreak((XMLWriter)this.xmlWriter);
    }

    @Override
    public synchronized void close() {
        if (this.isOpen) {
            this.xmlWriter.endElement();
            this.out.close();
            this.isOpen = false;
            String filePath = this.outFile.getAbsolutePath();
            filePath = filePath.substring(0, filePath.length() - ".tmp".length());
            File finalFile = new File(filePath);
            boolean result = this.outFile.renameTo(finalFile);
            if (!result) {
                this.logger.warn("[jenkins-event-spy] Failure to rename " + this.outFile + " into " + finalFile);
            } else {
                this.outFile = finalFile;
            }
            try {
                this.logger.info("[jenkins-event-spy] Generated " + this.outFile.getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }

    public synchronized File getFinalFile() {
        return this.outFile;
    }
}

