/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.eventspy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.eventspy.EventSpy;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.ArtifactDeployedEventHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.CatchAllExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.DefaultSettingsBuildingRequestHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.DependencyResolutionRequestHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.DependencyResolutionResultHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.DeployDeployExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.DeployDeployFileExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.FailsafeTestExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.InvokerRunExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.InvokerStartExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.JarJarExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.MavenEventHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.MavenExecutionRequestHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.MavenExecutionResultHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.ProjectFailedExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.ProjectStartedExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.ProjectSucceededExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.SessionEndedHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.SurefireTestExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.reporter.DevNullMavenEventReporter;
import org.jenkinsci.plugins.pipeline.maven.eventspy.reporter.FileMavenEventReporter;
import org.jenkinsci.plugins.pipeline.maven.eventspy.reporter.MavenEventReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class JenkinsMavenEventSpy
extends AbstractEventSpy {
    public static final String DISABLE_MAVEN_EVENT_SPY_PROPERTY_NAME = JenkinsMavenEventSpy.class.getName() + ".disabled";
    public static final String DISABLE_MAVEN_EVENT_SPY_ENVIRONMENT_VARIABLE_NAME = "JENKINS_MAVEN_AGENT_DISABLED";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private MavenEventReporter reporter;
    protected final boolean disabled;
    private Set<Class> blackList = new HashSet<Class>();
    private Set<String> ignoredList = new HashSet<String>(Collections.singletonList("org.apache.maven.settings.building.DefaultSettingsBuildingResult"));
    private List<MavenEventHandler> handlers = new ArrayList<MavenEventHandler>();

    public JenkinsMavenEventSpy() throws IOException {
        this.disabled = this.isEventSpyDisabled();
        if (this.disabled) {
            this.logger.info("[jenkins-event-spy] Jenkins Maven Event Spy is disabled");
        }
    }

    public JenkinsMavenEventSpy(MavenEventReporter reporter) throws IOException {
        this();
        this.reporter = reporter;
    }

    public void init(EventSpy.Context context) throws Exception {
        if (this.disabled) {
            this.reporter = new DevNullMavenEventReporter();
            return;
        }
        if (this.reporter == null) {
            this.reporter = new FileMavenEventReporter();
        }
        this.handlers.add(new ProjectSucceededExecutionHandler(this.reporter));
        this.handlers.add(new ProjectFailedExecutionHandler(this.reporter));
        this.handlers.add(new ProjectStartedExecutionHandler(this.reporter));
        this.handlers.add(new FailsafeTestExecutionHandler(this.reporter));
        this.handlers.add(new SurefireTestExecutionHandler(this.reporter));
        this.handlers.add(new JarJarExecutionHandler(this.reporter));
        this.handlers.add(new InvokerRunExecutionHandler(this.reporter));
        this.handlers.add(new InvokerStartExecutionHandler(this.reporter));
        this.handlers.add(new DefaultSettingsBuildingRequestHandler(this.reporter));
        this.handlers.add(new MavenExecutionRequestHandler(this.reporter));
        this.handlers.add(new DependencyResolutionRequestHandler(this.reporter));
        this.handlers.add(new DependencyResolutionResultHandler(this.reporter));
        this.handlers.add(new MavenExecutionResultHandler(this.reporter));
        this.handlers.add(new SessionEndedHandler(this.reporter));
        this.handlers.add(new DeployDeployExecutionHandler(this.reporter));
        this.handlers.add(new DeployDeployFileExecutionHandler(this.reporter));
        this.handlers.add(new ArtifactDeployedEventHandler(this.reporter));
        this.handlers.add(new CatchAllExecutionHandler(this.reporter));
        Xpp3Dom element = new Xpp3Dom("context");
        for (Map.Entry entry : context.getData().entrySet()) {
            Xpp3Dom entryElt = new Xpp3Dom((String)entry.getKey());
            element.addChild(entryElt);
            entryElt.setValue(entryElt.getValue());
        }
        this.reporter.print(element);
    }

    public void onEvent(Object event) throws Exception {
        if (this.disabled) {
            return;
        }
        try {
            MavenEventHandler handler;
            boolean handled;
            if (this.blackList.contains(event.getClass())) {
                return;
            }
            if (this.ignoredList.contains(event.getClass().getName())) {
                return;
            }
            Iterator<MavenEventHandler> iterator = this.handlers.iterator();
            while (iterator.hasNext() && !(handled = (handler = iterator.next()).handle(event))) {
            }
        }
        catch (Throwable t) {
            this.blackList.add(event.getClass());
            this.logger.warn("[jenkins-event-spy] Exception processing " + event, t);
            this.reporter.print(((Object)((Object)this)).getClass().getName() + ": Exception processing " + event);
        }
    }

    public void close() {
        if (this.disabled) {
            return;
        }
        this.reporter.print("close: ignored:" + this.ignoredList + ", blackListed: " + this.blackList);
        this.reporter.close();
    }

    protected boolean isEventSpyDisabled() {
        return "true".equalsIgnoreCase(System.getProperty(DISABLE_MAVEN_EVENT_SPY_PROPERTY_NAME)) || "true".equalsIgnoreCase(System.getenv(DISABLE_MAVEN_EVENT_SPY_ENVIRONMENT_VARIABLE_NAME));
    }

    public MavenEventReporter getReporter() {
        return this.reporter;
    }

    public List<MavenEventHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<MavenEventHandler> handlers) {
        this.handlers = handlers;
    }

    public void setHandlers(MavenEventHandler ... handlers) {
        this.handlers = Arrays.asList(handlers);
    }
}

