/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parameterizedscheduler;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.AperiodicWork;
import hudson.triggers.Trigger;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedTimerTrigger;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Extension
public class Cron
extends AperiodicWork {
    private static final Logger LOGGER = Logger.getLogger(Cron.class.getName());
    protected static final long MIN = 60000L;

    public AperiodicWork getNewInstance() {
        return new Cron();
    }

    public long getRecurrencePeriod() {
        return this.getInitialDelay();
    }

    public long getInitialDelay() {
        return 60000L - (long)(Calendar.getInstance().get(13) * 1000);
    }

    protected void doAperiodicRun() {
        Jenkins instance = Jenkins.get();
        for (AbstractProject project : instance.allItems(AbstractProject.class)) {
            this.checkTriggers(project.getName(), project.getTriggers().values(), new GregorianCalendar());
        }
        for (WorkflowJob workflowJob : instance.allItems(WorkflowJob.class)) {
            this.checkTriggers(workflowJob.getName(), workflowJob.getTriggers().values(), new GregorianCalendar());
        }
    }

    private void checkTriggers(String projectName, Collection<Trigger<?>> triggers, Calendar calendar) {
        for (Trigger<?> trigger : triggers) {
            if (!(trigger instanceof ParameterizedTimerTrigger)) continue;
            LOGGER.log(Level.FINE, "cron checking {0}", projectName);
            ParameterizedTimerTrigger ptTrigger = (ParameterizedTimerTrigger)trigger;
            try {
                ptTrigger.checkCronTabsAndRun(calendar);
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, trigger.getClass().getName() + ".run() failed for " + projectName, e);
            }
        }
    }
}

