/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins.retry;

import com.oracle.cloud.baremetal.jenkins.retry.Retry;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class LinearRetry<T>
implements Retry<T> {
    private static final Logger LOGGER = Logger.getLogger(LinearRetry.class.getName());
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final Duration DEFAULT_RETRY_DELAY = Duration.ofSeconds(30L);
    private static final Duration DEFAULT_RETRY_TIMEOUT = Duration.ofSeconds(30L);
    private final Callable<T> task;
    private final int maxRetries;
    private final Duration retryDelay;
    private final Duration retryTimeout;
    private int retries;

    public LinearRetry(Callable<T> task) {
        this(task, 3);
    }

    public LinearRetry(Callable<T> task, int maxRetries) {
        this(task, maxRetries, DEFAULT_RETRY_DELAY, DEFAULT_RETRY_TIMEOUT);
    }

    public LinearRetry(Callable<T> task, int maxRetries, Duration retryDelay, Duration retryTimeout) {
        this.task = task;
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
        this.retryTimeout = retryTimeout;
        this.retries = 0;
    }

    @Override
    public boolean canRetry() {
        return this.retries < this.maxRetries;
    }

    @Override
    public T run() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        LOGGER.fine("Start retring for task: " + this.task.toString());
        while (this.canRetry()) {
            ++this.retries;
            LOGGER.fine("Retry attempt " + this.retries + " of " + this.maxRetries + " for task: " + this.task.toString());
            Future<T> handler = executor.submit(this.task);
            try {
                return handler.get(this.retryTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                handler.cancel(true);
                if (!this.canRetry()) {
                    LOGGER.info("All retry attempts for task: " + this.task.toString() + " failed");
                    throw e;
                }
                Thread.sleep(this.retryDelay.toMillis());
            }
        }
        return null;
    }
}

