/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider;
import com.oracle.bmc.model.BmcException;
import com.oracle.cloud.baremetal.jenkins.Messages;
import com.oracle.cloud.baremetal.jenkins.client.SDKBaremetalCloudClient;
import com.oracle.cloud.baremetal.jenkins.credentials.BaremetalCloudCredentials;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public final class BaremetalCloudCredentialsImpl
extends BaseStandardCredentials
implements BaremetalCloudCredentials {
    private static final Logger LOGGER = Logger.getLogger(BaremetalCloudCredentials.class.getName());
    private final String fingerprint;
    private final String apikey;
    private final String passphrase;
    private final String tenantId;
    private final String userId;
    private final String regionId;
    private final boolean instancePrincipals;

    @DataBoundConstructor
    public BaremetalCloudCredentialsImpl(CredentialsScope scope, String id, String description, String fingerprint, String apikey, String passphrase, String tenantId, String userId, String regionId, boolean instancePrincipals) {
        super(scope, id, description);
        this.fingerprint = fingerprint;
        this.apikey = this.getEncryptedValue(apikey);
        this.passphrase = this.getEncryptedValue(passphrase);
        this.tenantId = tenantId;
        this.userId = userId;
        this.regionId = regionId;
        this.instancePrincipals = instancePrincipals;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public String getApikey() {
        return this.getPlainText(this.apikey);
    }

    @Override
    public String getPassphrase() {
        return this.getPlainText(this.passphrase);
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getRegionId() {
        return this.regionId;
    }

    @Override
    public boolean isInstancePrincipals() {
        return this.instancePrincipals;
    }

    protected String getEncryptedValue(String str) {
        return Secret.fromString((String)str).getEncryptedValue();
    }

    protected String getPlainText(String str) {
        Secret secret;
        if (str != null && (secret = Secret.decrypt((String)str)) != null) {
            return secret.getPlainText();
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Oracle Cloud Infrastructure Credentials";
        }

        public FormValidation doTestConnection(@QueryParameter String fingerprint, @QueryParameter String apikey, @QueryParameter String passphrase, @QueryParameter String tenantId, @QueryParameter String userId, @QueryParameter String regionId, @QueryParameter boolean instancePrincipals) {
            if (!instancePrincipals) {
                SimpleAuthenticationDetailsProvider provider = SimpleAuthenticationDetailsProvider.builder().fingerprint(fingerprint).passPhrase(passphrase).privateKeySupplier(() -> new ByteArrayInputStream(apikey.getBytes(StandardCharsets.UTF_8))).tenantId(tenantId).userId(userId).build();
                SDKBaremetalCloudClient client = new SDKBaremetalCloudClient(provider, regionId, 50);
                try {
                    client.authenticate();
                    return FormValidation.ok((String)Messages.BaremetalCloud_testConnection_success());
                }
                catch (BmcException e) {
                    LOGGER.log(Level.INFO, "Failed to connect to Oracle Cloud Infrastructure. Please verify all the credential information entered.", e);
                    return FormValidation.error((String)Messages.BaremetalCloud_testConnection_unauthorized());
                }
            }
            InstancePrincipalsAuthenticationDetailsProvider provider = InstancePrincipalsAuthenticationDetailsProvider.builder().build();
            SDKBaremetalCloudClient client = new SDKBaremetalCloudClient((BasicAuthenticationDetailsProvider)provider, regionId, 50, tenantId);
            try {
                if (fingerprint != null && !fingerprint.trim().isEmpty()) {
                    LOGGER.log(Level.INFO, "Fingerprint ignored when using Instance Principals");
                }
                if (apikey != null && !apikey.trim().isEmpty()) {
                    LOGGER.log(Level.INFO, "API Key ignored when using Instance Principals");
                }
                if (passphrase != null && !passphrase.trim().isEmpty()) {
                    LOGGER.log(Level.INFO, "Passphrase ignored when using Instance Principals");
                }
                if (userId != null && !userId.trim().isEmpty()) {
                    LOGGER.log(Level.INFO, "User ID ignored when using Instance Principals");
                }
                client.authenticate();
                return FormValidation.ok((String)Messages.BaremetalCloud_testConnection_success());
            }
            catch (BmcException e) {
                LOGGER.log(Level.INFO, "Failed to connect to Oracle Cloud Infrastructure using Instance Principals. Please verify all the credential information entered.", e);
                return FormValidation.error((String)Messages.BaremetalCloud_testConnection_unauthorized());
            }
        }
    }
}

