/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins;

import hudson.util.FormValidation;

public class FormValidationValue<T> {
    private final FormValidation formValidation;
    private final T value;

    public static <T> FormValidationValue<T> ok(T value) {
        return new FormValidationValue<T>(FormValidation.ok(), value);
    }

    public static <T> FormValidationValue<T> error(String s) {
        return FormValidationValue.error(s, null);
    }

    public static <T> FormValidationValue<T> error(String s, T defaultValue) {
        return FormValidationValue.error(FormValidation.error((String)s), defaultValue);
    }

    public static <T> FormValidationValue<T> error(FormValidation formValidation) {
        return FormValidationValue.error(formValidation, null);
    }

    public static <T> FormValidationValue<T> error(FormValidation formValidation, T defaultValue) {
        if (formValidation.kind == FormValidation.Kind.OK) {
            throw new IllegalArgumentException();
        }
        return new FormValidationValue<T>(formValidation, defaultValue);
    }

    public static FormValidationValue<Integer> validatePositiveInteger(String value, int defaultValue) {
        FormValidation fv = FormValidation.validatePositiveInteger((String)value);
        if (fv.kind != FormValidation.Kind.OK) {
            return FormValidationValue.error(fv, Integer.valueOf(defaultValue));
        }
        return FormValidationValue.ok(Integer.parseInt(value));
    }

    public static FormValidationValue<Integer> validateNonNegativeInteger(String value, int defaultValue) {
        FormValidation fv = FormValidation.validateNonNegativeInteger((String)value);
        if (fv.kind != FormValidation.Kind.OK) {
            return FormValidationValue.error(fv, Integer.valueOf(defaultValue));
        }
        return FormValidationValue.ok(Integer.parseInt(value));
    }

    private FormValidationValue(FormValidation formValidation, T value) {
        this.formValidation = formValidation;
        this.value = value;
    }

    public String toString() {
        return this.isOk() ? "OK: " + String.valueOf(this.value) : this.formValidation.toString();
    }

    public FormValidation getFormValidation() {
        return this.formValidation;
    }

    public boolean isOk() {
        return this.formValidation.kind == FormValidation.Kind.OK;
    }

    public T getValue() {
        return this.value;
    }
}

