/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins;

import com.oracle.cloud.baremetal.jenkins.JenkinsUtil;
import com.oracle.cloud.baremetal.jenkins.Messages;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.servlet.ServletException;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class FormFillFailure
extends IOException
implements HttpResponse {
    private static final Method FORM_FILL_FAILURE_ERROR_METHOD = FormFillFailure.getFormFillFailureErrorMethod();
    private static final String ERROR_VALUE_PREFIX = FormFillFailure.class.getName() + ".ERROR:";
    final HttpResponse response;

    private static Method getFormFillFailureErrorMethod() {
        try {
            Class<HttpResponse> c = Class.forName("hudson.util.FormFillFailure").asSubclass(HttpResponse.class);
            return c.getMethod("error", String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return null;
        }
    }

    private static FormFillFailure errorWithValue(String message, Throwable cause, String value) {
        Objects.requireNonNull(value, "value");
        HttpResponse response = null;
        if (FORM_FILL_FAILURE_ERROR_METHOD != null) {
            try {
                response = (HttpResponse)FORM_FILL_FAILURE_ERROR_METHOD.invoke(null, message);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            if (FormFillFailure.isError(value)) {
                throw new IllegalArgumentException();
            }
            ListBoxModel model = new ListBoxModel();
            model.add(Messages.FormFillFailure_error(message), ERROR_VALUE_PREFIX + value);
            response = model;
        }
        return new FormFillFailure(Util.escape((String)message), cause, response);
    }

    public static FormFillFailure errorWithValue(String message, String value) {
        return FormFillFailure.errorWithValue(message, null, value);
    }

    public static FormFillFailure errorWithValue(FormValidation fv, String value) {
        if (fv.kind != FormValidation.Kind.ERROR) {
            throw new IllegalArgumentException("kind " + String.valueOf(fv.kind));
        }
        return FormFillFailure.errorWithValue(JenkinsUtil.unescape(fv.getMessage()), (Throwable)fv, value);
    }

    public static boolean isError(String formControlValue) {
        return formControlValue != null && formControlValue.startsWith(ERROR_VALUE_PREFIX);
    }

    public static String getErrorValue(String formControlValue) {
        return FormFillFailure.isError(formControlValue) ? formControlValue.substring(ERROR_VALUE_PREFIX.length()) : formControlValue;
    }

    public static FormValidation validateRequired(String formControlValue) {
        if (FormFillFailure.isError(formControlValue)) {
            return FormValidation.error((String)Messages.FormValidation_ValidateRequired());
        }
        return JenkinsUtil.validateRequired(formControlValue);
    }

    private FormFillFailure(String message, Throwable cause, HttpResponse response) {
        super(message);
        this.response = response;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.response.getClass().getSimpleName() + ": " + String.valueOf(this.response) + "]";
    }

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        this.response.generateResponse(req, rsp, node);
    }
}

