/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins;

import com.oracle.cloud.baremetal.jenkins.BaremetalCloud;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.OfflineCause;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

public class BaremetalCloudRetentionStrategy
extends CloudRetentionStrategy {
    private static final Logger LOGGER = Logger.getLogger(BaremetalCloud.class.getName());

    public BaremetalCloudRetentionStrategy(int idleMinutes) {
        super(idleMinutes);
    }

    @GuardedBy(value="hudson.model.Queue.lock")
    public long check(AbstractCloudComputer c) {
        if (c.isOffline() && c.getOfflineCause() instanceof OfflineCause.SimpleOfflineCause) {
            LOGGER.fine(c.getDisplayName() + ": Node is set temporarily offline - will not terminate");
            return 1L;
        }
        return super.check(c);
    }
}

