// CHECKSTYLE:OFF

package com.oracle.cloud.baremetal.jenkins;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BaremetalCloud.testConnection.unauthorized}: {@code Invalid
     * credentials}.
     * 
     * @return
     *     {@code Invalid credentials}
     */
    public static String BaremetalCloud_testConnection_unauthorized() {
        return holder.format("BaremetalCloud.testConnection.unauthorized");
    }

    /**
     * Key {@code BaremetalCloud.testConnection.unauthorized}: {@code Invalid
     * credentials}.
     * 
     * @return
     *     {@code Invalid credentials}
     */
    public static Localizable _BaremetalCloud_testConnection_unauthorized() {
        return new Localizable(holder, "BaremetalCloud.testConnection.unauthorized");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.ocpu.nonflex.nonempty}: {@code
     * Please select appropriate shape that supports this option}.
     * 
     * @return
     *     {@code Please select appropriate shape that supports this option}
     */
    public static String BaremetalCloudAgentTemplate_ocpu_nonflex_nonempty() {
        return holder.format("BaremetalCloudAgentTemplate.ocpu.nonflex.nonempty");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.ocpu.nonflex.nonempty}: {@code
     * Please select appropriate shape that supports this option}.
     * 
     * @return
     *     {@code Please select appropriate shape that supports this option}
     */
    public static Localizable _BaremetalCloudAgentTemplate_ocpu_nonflex_nonempty() {
        return new Localizable(holder, "BaremetalCloudAgentTemplate.ocpu.nonflex.nonempty");
    }

    /**
     * Key {@code BaremetalCloud.testConnection.error}: {@code Failed to
     * connect to Oracle Cloud Infrastructure Compute: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to connect to Oracle Cloud Infrastructure Compute: {0}}
     */
    public static String BaremetalCloud_testConnection_error(Object arg0) {
        return holder.format("BaremetalCloud.testConnection.error", arg0);
    }

    /**
     * Key {@code BaremetalCloud.testConnection.error}: {@code Failed to
     * connect to Oracle Cloud Infrastructure Compute: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to connect to Oracle Cloud Infrastructure Compute: {0}}
     */
    public static Localizable _BaremetalCloud_testConnection_error(Object arg0) {
        return new Localizable(holder, "BaremetalCloud.testConnection.error", arg0);
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.assignPublicIP.unable}: {@code
     * The selected subnet is private, can not assign Public IP.}.
     * 
     * @return
     *     {@code The selected subnet is private, can not assign Public IP.}
     */
    public static String BaremetalCloudAgentTemplate_assignPublicIP_unable() {
        return holder.format("BaremetalCloudAgentTemplate.assignPublicIP.unable");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.assignPublicIP.unable}: {@code
     * The selected subnet is private, can not assign Public IP.}.
     * 
     * @return
     *     {@code The selected subnet is private, can not assign Public IP.}
     */
    public static Localizable _BaremetalCloudAgentTemplate_assignPublicIP_unable() {
        return new Localizable(holder, "BaremetalCloudAgentTemplate.assignPublicIP.unable");
    }

    /**
     * Key {@code BaremetalCloud.cloudName.duplicate}: {@code Oracle Cloud
     * Infrastructure Compute named ‘{0}’ already exists}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Oracle Cloud Infrastructure Compute named ‘{0}’ already exists}
     */
    public static String BaremetalCloud_cloudName_duplicate(Object arg0) {
        return holder.format("BaremetalCloud.cloudName.duplicate", arg0);
    }

    /**
     * Key {@code BaremetalCloud.cloudName.duplicate}: {@code Oracle Cloud
     * Infrastructure Compute named ‘{0}’ already exists}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Oracle Cloud Infrastructure Compute named ‘{0}’ already exists}
     */
    public static Localizable _BaremetalCloud_cloudName_duplicate(Object arg0) {
        return new Localizable(holder, "BaremetalCloud.cloudName.duplicate", arg0);
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.privateKey.invalid}: {@code
     * Invalid SSH Private Key}.
     * 
     * @return
     *     {@code Invalid SSH Private Key}
     */
    public static String BaremetalCloudAgentTemplate_privateKey_invalid() {
        return holder.format("BaremetalCloudAgentTemplate.privateKey.invalid");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.privateKey.invalid}: {@code
     * Invalid SSH Private Key}.
     * 
     * @return
     *     {@code Invalid SSH Private Key}
     */
    public static Localizable _BaremetalCloudAgentTemplate_privateKey_invalid() {
        return new Localizable(holder, "BaremetalCloudAgentTemplate.privateKey.invalid");
    }

    /**
     * Key {@code BaremetalCloud.provision.templateDisabled}: {@code Agent
     * template has been disabled}.
     * 
     * @return
     *     {@code Agent template has been disabled}
     */
    public static String BaremetalCloud_provision_templateDisabled() {
        return holder.format("BaremetalCloud.provision.templateDisabled");
    }

    /**
     * Key {@code BaremetalCloud.provision.templateDisabled}: {@code Agent
     * template has been disabled}.
     * 
     * @return
     *     {@code Agent template has been disabled}
     */
    public static Localizable _BaremetalCloud_provision_templateDisabled() {
        return new Localizable(holder, "BaremetalCloud.provision.templateDisabled");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.verifySshKeyPair.mismatch}:
     * {@code The SSH Private Key does not match the public key}.
     * 
     * @return
     *     {@code The SSH Private Key does not match the public key}
     */
    public static String BaremetalCloudAgentTemplate_verifySshKeyPair_mismatch() {
        return holder.format("BaremetalCloudAgentTemplate.verifySshKeyPair.mismatch");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.verifySshKeyPair.mismatch}:
     * {@code The SSH Private Key does not match the public key}.
     * 
     * @return
     *     {@code The SSH Private Key does not match the public key}
     */
    public static Localizable _BaremetalCloudAgentTemplate_verifySshKeyPair_mismatch() {
        return new Localizable(holder, "BaremetalCloudAgentTemplate.verifySshKeyPair.mismatch");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.usePublicIP.unable}: {@code
     * Public IP is not assigned.}.
     * 
     * @return
     *     {@code Public IP is not assigned.}
     */
    public static String BaremetalCloudAgentTemplate_usePublicIP_unable() {
        return holder.format("BaremetalCloudAgentTemplate.usePublicIP.unable");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.usePublicIP.unable}: {@code
     * Public IP is not assigned.}.
     * 
     * @return
     *     {@code Public IP is not assigned.}
     */
    public static Localizable _BaremetalCloudAgentTemplate_usePublicIP_unable() {
        return new Localizable(holder, "BaremetalCloudAgentTemplate.usePublicIP.unable");
    }

    /**
     * Key {@code FormFillFailure.error}: {@code ERROR: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code ERROR: {0}}
     */
    public static String FormFillFailure_error(Object arg0) {
        return holder.format("FormFillFailure.error", arg0);
    }

    /**
     * Key {@code FormFillFailure.error}: {@code ERROR: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code ERROR: {0}}
     */
    public static Localizable _FormFillFailure_error(Object arg0) {
        return new Localizable(holder, "FormFillFailure.error", arg0);
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate_prefix_contains_spaces}: {@code
     * Instance Name Prefix can not contain whitespaces}.
     * 
     * @return
     *     {@code Instance Name Prefix can not contain whitespaces}
     */
    public static String BaremetalCloudAgentTemplate_prefix_contains_spaces() {
        return holder.format("BaremetalCloudAgentTemplate_prefix_contains_spaces");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate_prefix_contains_spaces}: {@code
     * Instance Name Prefix can not contain whitespaces}.
     * 
     * @return
     *     {@code Instance Name Prefix can not contain whitespaces}
     */
    public static Localizable _BaremetalCloudAgentTemplate_prefix_contains_spaces() {
        return new Localizable(holder, "BaremetalCloudAgentTemplate_prefix_contains_spaces");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.verifySshKeyPair.success}:
     * {@code Successfully matched the SSH public and private key pair}.
     * 
     * @return
     *     {@code Successfully matched the SSH public and private key pair}
     */
    public static String BaremetalCloudAgentTemplate_verifySshKeyPair_success() {
        return holder.format("BaremetalCloudAgentTemplate.verifySshKeyPair.success");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.verifySshKeyPair.success}:
     * {@code Successfully matched the SSH public and private key pair}.
     * 
     * @return
     *     {@code Successfully matched the SSH public and private key pair}
     */
    public static Localizable _BaremetalCloudAgentTemplate_verifySshKeyPair_success() {
        return new Localizable(holder, "BaremetalCloudAgentTemplate.verifySshKeyPair.success");
    }

    /**
     * Key {@code BaremetalCloud.termination.offlineCause}: {@code This Agent
     * is being terminated}.
     * 
     * @return
     *     {@code This Agent is being terminated}
     */
    public static String BaremetalCloud_termination_offlineCause() {
        return holder.format("BaremetalCloud.termination.offlineCause");
    }

    /**
     * Key {@code BaremetalCloud.termination.offlineCause}: {@code This Agent
     * is being terminated}.
     * 
     * @return
     *     {@code This Agent is being terminated}
     */
    public static Localizable _BaremetalCloud_termination_offlineCause() {
        return new Localizable(holder, "BaremetalCloud.termination.offlineCause");
    }

    /**
     * Key {@code BaremetalCloud.provision.started}: {@code Started
     * provisioning node(s) {0} with {1} executors.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started provisioning node(s) {0} with {1} executors.}
     */
    public static String BaremetalCloud_provision_started(Object arg0, Object arg1) {
        return holder.format("BaremetalCloud.provision.started", arg0, arg1);
    }

    /**
     * Key {@code BaremetalCloud.provision.started}: {@code Started
     * provisioning node(s) {0} with {1} executors.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started provisioning node(s) {0} with {1} executors.}
     */
    public static Localizable _BaremetalCloud_provision_started(Object arg0, Object arg1) {
        return new Localizable(holder, "BaremetalCloud.provision.started", arg0, arg1);
    }

    /**
     * Key {@code BaremetalCloud.provision.templateNotFound}: {@code Unable
     * to find agent template}.
     * 
     * @return
     *     {@code Unable to find agent template}
     */
    public static String BaremetalCloud_provision_templateNotFound() {
        return holder.format("BaremetalCloud.provision.templateNotFound");
    }

    /**
     * Key {@code BaremetalCloud.provision.templateNotFound}: {@code Unable
     * to find agent template}.
     * 
     * @return
     *     {@code Unable to find agent template}
     */
    public static Localizable _BaremetalCloud_provision_templateNotFound() {
        return new Localizable(holder, "BaremetalCloud.provision.templateNotFound");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.ocpu.flex.empty}: {@code Please
     * select appropriate value for selected shape}.
     * 
     * @return
     *     {@code Please select appropriate value for selected shape}
     */
    public static String BaremetalCloudAgentTemplate_ocpu_flex_empty() {
        return holder.format("BaremetalCloudAgentTemplate.ocpu.flex.empty");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.ocpu.flex.empty}: {@code Please
     * select appropriate value for selected shape}.
     * 
     * @return
     *     {@code Please select appropriate value for selected shape}
     */
    public static Localizable _BaremetalCloudAgentTemplate_ocpu_flex_empty() {
        return new Localizable(holder, "BaremetalCloudAgentTemplate.ocpu.flex.empty");
    }

    /**
     * Key {@code FormValidation.ValidateRequired}: {@code Field is
     * required}.
     * 
     * @return
     *     {@code Field is required}
     */
    public static String FormValidation_ValidateRequired() {
        return holder.format("FormValidation.ValidateRequired");
    }

    /**
     * Key {@code FormValidation.ValidateRequired}: {@code Field is
     * required}.
     * 
     * @return
     *     {@code Field is required}
     */
    public static Localizable _FormValidation_ValidateRequired() {
        return new Localizable(holder, "FormValidation.ValidateRequired");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.verifySshKeyPair.unable}:
     * {@code Unable to verify the SSH key pair: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to verify the SSH key pair: {0}}
     */
    public static String BaremetalCloudAgentTemplate_verifySshKeyPair_unable(Object arg0) {
        return holder.format("BaremetalCloudAgentTemplate.verifySshKeyPair.unable", arg0);
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.verifySshKeyPair.unable}:
     * {@code Unable to verify the SSH key pair: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to verify the SSH key pair: {0}}
     */
    public static Localizable _BaremetalCloudAgentTemplate_verifySshKeyPair_unable(Object arg0) {
        return new Localizable(holder, "BaremetalCloudAgentTemplate.verifySshKeyPair.unable", arg0);
    }

    /**
     * Key {@code
     * BaremetalCloudAgentTemplate.verifySshKeyPair.publicKeyEmpty}: {@code
     * The SSH public key is empty}.
     * 
     * @return
     *     {@code The SSH public key is empty}
     */
    public static String BaremetalCloudAgentTemplate_verifySshKeyPair_publicKeyEmpty() {
        return holder.format("BaremetalCloudAgentTemplate.verifySshKeyPair.publicKeyEmpty");
    }

    /**
     * Key {@code
     * BaremetalCloudAgentTemplate.verifySshKeyPair.publicKeyEmpty}: {@code
     * The SSH public key is empty}.
     * 
     * @return
     *     {@code The SSH public key is empty}
     */
    public static Localizable _BaremetalCloudAgentTemplate_verifySshKeyPair_publicKeyEmpty() {
        return new Localizable(holder, "BaremetalCloudAgentTemplate.verifySshKeyPair.publicKeyEmpty");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.privateKey.unable}: {@code
     * Unable to read SSH Private Key: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to read SSH Private Key: {0}}
     */
    public static String BaremetalCloudAgentTemplate_privateKey_unable(Object arg0) {
        return holder.format("BaremetalCloudAgentTemplate.privateKey.unable", arg0);
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.privateKey.unable}: {@code
     * Unable to read SSH Private Key: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to read SSH Private Key: {0}}
     */
    public static Localizable _BaremetalCloudAgentTemplate_privateKey_unable(Object arg0) {
        return new Localizable(holder, "BaremetalCloudAgentTemplate.privateKey.unable", arg0);
    }

    /**
     * Key {@code BaremetalCloud.testConnection.success}: {@code Successfully
     * connected to Oracle Cloud Infrastructure Compute}.
     * 
     * @return
     *     {@code Successfully connected to Oracle Cloud Infrastructure Compute}
     */
    public static String BaremetalCloud_testConnection_success() {
        return holder.format("BaremetalCloud.testConnection.success");
    }

    /**
     * Key {@code BaremetalCloud.testConnection.success}: {@code Successfully
     * connected to Oracle Cloud Infrastructure Compute}.
     * 
     * @return
     *     {@code Successfully connected to Oracle Cloud Infrastructure Compute}
     */
    public static Localizable _BaremetalCloud_testConnection_success() {
        return new Localizable(holder, "BaremetalCloud.testConnection.success");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.doNotDisable.warningmsg}:
     * {@code There can be performance issues, make sure you understand the
     * effects.}.
     * 
     * @return
     *     {@code There can be performance issues, make sure you understand the
     *     effects.}
     */
    public static String BaremetalCloudAgentTemplate_doNotDisable_warningmsg() {
        return holder.format("BaremetalCloudAgentTemplate.doNotDisable.warningmsg");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.doNotDisable.warningmsg}:
     * {@code There can be performance issues, make sure you understand the
     * effects.}.
     * 
     * @return
     *     {@code There can be performance issues, make sure you understand the
     *     effects.}
     */
    public static Localizable _BaremetalCloudAgentTemplate_doNotDisable_warningmsg() {
        return new Localizable(holder, "BaremetalCloudAgentTemplate.doNotDisable.warningmsg");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.labelString.exclusiveEmpty}:
     * {@code You may want to assign labels to this node; it's marked to only
     * run jobs that are exclusively tied to itself or a label.}.
     * 
     * @return
     *     {@code You may want to assign labels to this node; it's marked to only
     *     run jobs that are exclusively tied to itself or a label.}
     */
    public static String BaremetalCloudAgentTemplate_labelString_exclusiveEmpty() {
        return holder.format("BaremetalCloudAgentTemplate.labelString.exclusiveEmpty");
    }

    /**
     * Key {@code BaremetalCloudAgentTemplate.labelString.exclusiveEmpty}:
     * {@code You may want to assign labels to this node; it's marked to only
     * run jobs that are exclusively tied to itself or a label.}.
     * 
     * @return
     *     {@code You may want to assign labels to this node; it's marked to only
     *     run jobs that are exclusively tied to itself or a label.}
     */
    public static Localizable _BaremetalCloudAgentTemplate_labelString_exclusiveEmpty() {
        return new Localizable(holder, "BaremetalCloudAgentTemplate.labelString.exclusiveEmpty");
    }

}
