// CHECKSTYLE:OFF

package jenkins.plugins.openstack.compute;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code OneOffCause}: {@code Single-use slave has already been used
     * and is pending removal.}.
     * 
     * @return
     *     {@code Single-use slave has already been used and is pending removal.}
     */
    public static String OneOffCause() {
        return holder.format("OneOffCause");
    }

    /**
     * Key {@code OneOffCause}: {@code Single-use slave has already been used
     * and is pending removal.}.
     * 
     * @return
     *     {@code Single-use slave has already been used and is pending removal.}
     */
    public static Localizable _OneOffCause() {
        return new Localizable(holder, "OneOffCause");
    }

    /**
     * Key {@code DeletedCause}: {@code Slave is pending removal.}.
     * 
     * @return
     *     {@code Slave is pending removal.}
     */
    public static String DeletedCause() {
        return holder.format("DeletedCause");
    }

    /**
     * Key {@code DeletedCause}: {@code Slave is pending removal.}.
     * 
     * @return
     *     {@code Slave is pending removal.}
     */
    public static Localizable _DeletedCause() {
        return new Localizable(holder, "DeletedCause");
    }

}
