/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openid;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.Util;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.plugins.openid.OpenIdLoginService;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.FederatedLoginServiceUserProperty;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class OpenIdUserProperty
extends FederatedLoginServiceUserProperty {
    @DataBoundConstructor
    public OpenIdUserProperty(Set<String> identifiers) {
        super(OpenIdUserProperty.unencrypt(Util.fixNull(identifiers)));
    }

    private static List<String> unencrypt(Set<String> identifiers) {
        ArrayList<String> r = new ArrayList<String>();
        for (String id : identifiers) {
            r.add(Secret.fromString((String)id).getPlainText());
        }
        return r;
    }

    public List<Secret> getProtectedOpenIDs() {
        ArrayList<Secret> r = new ArrayList<Secret>();
        for (String id : this.getIdentifiers()) {
            r.add(Secret.fromString((String)id));
        }
        return r;
    }

    @Extension
    public static class DescriptorImpl
    extends UserPropertyDescriptor {
        @Inject
        private OpenIdLoginService openIdLoginService;

        public UserProperty newInstance(User user) {
            return new OpenIdUserProperty(Collections.emptySet());
        }

        public boolean isEnabled() {
            return Jenkins.get().getSecurityRealm() instanceof AbstractPasswordBasedSecurityRealm && this.openIdLoginService != null && !this.openIdLoginService.isDisabled();
        }

        public String getDisplayName() {
            return "OpenID";
        }
    }
}

