/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javaposse.jobdsl.dsl.Context;
import net.nemerosa.ontrack.jenkins.ScriptLocation;
import org.apache.commons.lang.StringUtils;

public class OntrackDslContext
implements Context {
    private ScriptLocation scriptLocation = ScriptLocation.text("");
    private List<String> environment = new ArrayList<String>();
    private String injectProperties = "";
    private boolean log = false;

    public void path(String path) {
        this.scriptLocation = ScriptLocation.path(path);
    }

    public void script(String script) {
        this.scriptLocation = ScriptLocation.text(script);
    }

    public void environment(String ... names) {
        this.environment.addAll(Arrays.asList(names));
    }

    public void properties(String properties) {
        this.injectProperties = properties;
    }

    public void log() {
        this.log(true);
    }

    public void log(boolean log) {
        this.log = log;
    }

    public ScriptLocation getScriptLocation() {
        return this.scriptLocation;
    }

    public String getInjectEnvironment() {
        return StringUtils.join(this.environment, (String)",");
    }

    public String getInjectProperties() {
        return this.injectProperties;
    }

    public boolean isLog() {
        return this.log;
    }
}

