/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.dsl;

import hudson.model.BuildListener;
import java.io.PrintStream;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.dsl.OntrackConnection;
import net.nemerosa.ontrack.dsl.OntrackLogger;
import net.nemerosa.ontrack.jenkins.OntrackConfiguration;
import org.apache.commons.lang.StringUtils;

public class OntrackDSLConnector {
    public static Ontrack createOntrackConnector(final PrintStream logger) {
        String user;
        OntrackConfiguration config = OntrackConfiguration.getOntrackConfiguration();
        OntrackConnection connection = OntrackConnection.create((String)config.getOntrackUrl());
        if (logger != null) {
            connection = connection.logger(new OntrackLogger(){

                public void trace(String message) {
                    logger.println(message);
                }
            });
        }
        if (StringUtils.isNotBlank((String)(user = config.getOntrackUser()))) {
            connection = connection.authenticate(user, config.getOntrackPassword());
        }
        if (config.getOntrackMaxTries() > 1) {
            connection = connection.maxTries(config.getOntrackMaxTries()).retryDelaySeconds(config.getOntrackRetryDelaySeconds());
        }
        return connection.build();
    }

    public static Ontrack createOntrackConnector(BuildListener listener) {
        return OntrackDSLConnector.createOntrackConnector(listener != null ? listener.getLogger() : null);
    }
}

