/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.dsl;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.jenkins.OntrackPluginSupport;
import net.nemerosa.ontrack.jenkins.dsl.JenkinsConnector;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLResult;

public class OntrackDSL {
    private final String script;
    private final String injectEnvironment;
    private final String injectProperties;
    private final boolean ontrackLog;

    public OntrackDSL(String script, String injectEnvironment, String injectProperties, boolean ontrackLog) {
        this.script = script;
        this.injectEnvironment = injectEnvironment;
        this.injectProperties = injectProperties;
        this.ontrackLog = ontrackLog;
    }

    public OntrackDSLResult run(AbstractBuild<?, ?> theBuild, BuildListener listener) throws InterruptedException, IOException {
        String[] names;
        Ontrack ontrack = OntrackDSLConnector.createOntrackConnector((BuildListener)(this.ontrackLog ? listener : null));
        JenkinsConnector jenkins = new JenkinsConnector(theBuild, listener);
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String name : names = this.injectEnvironment.split(",")) {
            name = name.trim();
            String value = theBuild.getEnvironment((TaskListener)listener).get(name, "");
            if (value == null) continue;
            values.put(name, value);
        }
        Map<String, String> properties = OntrackPluginSupport.parseProperties(this.injectProperties, theBuild, listener);
        values.putAll(properties);
        listener.getLogger().format("Injecting following values:%n", new Object[0]);
        for (Map.Entry entry : values.entrySet()) {
            listener.getLogger().format(" - %s = %s%n", entry.getKey(), entry.getValue());
        }
        values.put("ontrack", ontrack);
        values.put("jenkins", jenkins);
        values.put("out", listener.getLogger());
        Binding binding = new Binding(values);
        GroovyShell shell = new GroovyShell(binding);
        listener.getLogger().format("Ontrack DSL script running...%n", new Object[0]);
        Object shellResult = shell.evaluate(this.script);
        if (this.ontrackLog) {
            listener.getLogger().format("Ontrack DSL script returned result: %s%n", shellResult);
        } else {
            listener.getLogger().format("Ontrack DSL script returned result.%n", new Object[0]);
        }
        return new OntrackDSLResult(shellResult, jenkins);
    }

    public static Result toJenkinsResult(Object shellResult) {
        if (shellResult instanceof String && !shellResult.equals("")) {
            return Result.FAILURE;
        }
        if (shellResult instanceof Boolean) {
            return (Boolean)shellResult != false ? Result.SUCCESS : Result.FAILURE;
        }
        return Result.SUCCESS;
    }
}

