/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.dsl;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import java.util.LinkedHashMap;
import java.util.Map;

public class JenkinsConnector {
    private final Map<String, String> env = new LinkedHashMap<String, String>();
    private final AbstractBuild build;
    private final BuildListener listener;

    public JenkinsConnector(AbstractBuild build, BuildListener listener) {
        this.build = build;
        this.listener = listener;
    }

    public void env(String name, String value) {
        this.env.put(name, value);
    }

    public Result getResult() {
        return this.build.getResult();
    }

    public AbstractBuild getBuild() {
        return this.build;
    }

    public BuildListener getListener() {
        return this.listener;
    }

    public boolean isSuccess() {
        Result result = this.getResult();
        return result != null && result.isBetterOrEqualTo(Result.SUCCESS);
    }

    public boolean isUnstable() {
        Result result = this.getResult();
        return result != null && result.isBetterOrEqualTo(Result.UNSTABLE) && result.isWorseThan(Result.SUCCESS);
    }

    public boolean isFailure() {
        Result result = this.getResult();
        return result != null && result.isWorseOrEqualTo(Result.FAILURE);
    }

    public Map<String, String> env() {
        return this.env;
    }
}

