/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import antlr.ANTLRException;
import com.google.common.collect.ImmutableMap;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.nemerosa.ontrack.dsl.Branch;
import net.nemerosa.ontrack.dsl.Build;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class OntrackTrigger
extends Trigger<AbstractProject> {
    private static final Logger LOGGER = Logger.getLogger(OntrackTrigger.class.getName());
    private static final Level LOG_LEVEL = Level.FINE;
    private final String project;
    private final String branch;
    private final String promotion;
    private final String parameterName;

    @DataBoundConstructor
    public OntrackTrigger(String spec, String project, String branch, String promotion, String parameterName) throws ANTLRException {
        super(spec);
        this.project = project;
        this.branch = branch;
        this.promotion = promotion;
        this.parameterName = parameterName;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getPromotion() {
        return this.promotion;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void run() {
        boolean firing;
        AbstractBuild lastBuild;
        LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] Check %s promotion trigger", ((AbstractProject)this.job).getFullName(), this.promotion));
        Ontrack ontrack = OntrackDSLConnector.createOntrackConnector(System.out);
        Branch ontrackBranch = ontrack.branch(this.project, this.branch);
        List ontrackBuilds = StringUtils.isBlank((String)this.promotion) ? ontrackBranch.standardFilter((Map)ImmutableMap.of((Object)"count", (Object)1)) : ("*".equals(this.promotion) ? ontrackBranch.getLastPromotedBuilds() : ontrackBranch.standardFilter((Map)ImmutableMap.of((Object)"count", (Object)1, (Object)"withPromotionLevel", (Object)this.promotion)));
        if (ontrackBuilds.isEmpty()) {
            LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] No build eligible", ((AbstractProject)this.job).getFullName()));
            return;
        }
        String lastVersion = ((Build)ontrackBuilds.get(0)).getName();
        LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] Last available build: %s", ((AbstractProject)this.job).getFullName(), lastVersion));
        String parameterNameValue = this.parameterName;
        if (StringUtils.isBlank((String)parameterNameValue)) {
            parameterNameValue = "VERSION";
        }
        if ((lastBuild = ((AbstractProject)this.job).getLastBuild()) != null) {
            Result result = lastBuild.getResult();
            if (result == null || result.isWorseThan(Result.SUCCESS) && result.isCompleteBuild()) {
                LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] Last build was failed or unsuccessful", ((AbstractProject)this.job).getFullName()));
                firing = true;
            } else {
                LogTaskListener taskListener = new LogTaskListener(LOGGER, Level.FINER);
                try {
                    String lastBuildName = lastBuild.getEnvironment((TaskListener)taskListener).get(parameterNameValue, null);
                    LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] Version for last build: %s", ((AbstractProject)this.job).getFullName(), lastBuildName));
                    if (StringUtils.equals((String)lastBuildName, (String)lastVersion)) {
                        LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] No new version available", ((AbstractProject)this.job).getFullName()));
                        firing = false;
                    }
                    LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] New version available", ((AbstractProject)this.job).getFullName()));
                    firing = true;
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(String.format("[ontrack][trigger][%s] Could not compute the trigger condition because %s environment variable could not be accessed", ((AbstractProject)this.job).getFullName(), parameterNameValue), e);
                }
            }
        } else {
            LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] No previous build, firing", ((AbstractProject)this.job).getFullName()));
            firing = true;
        }
        if (!firing) {
            LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] For one of the reasons mentioned above, not firing", ((AbstractProject)this.job).getFullName()));
        } else {
            LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] Firing with %s = %s", ((AbstractProject)this.job).getFullName(), parameterNameValue, lastVersion));
            ((AbstractProject)this.job).scheduleBuild2(0, (Cause)new OntrackTriggerCause(), new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue(parameterNameValue, lastVersion)})});
        }
    }

    public static class OntrackTriggerCause
    extends Cause {
        public String getShortDescription() {
            return "Triggered by Ontrack.";
        }

        public boolean equals(Object o) {
            return o instanceof OntrackTriggerCause;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof AbstractProject;
        }

        public String getDisplayName() {
            return "Ontrack: trigger";
        }
    }
}

