/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class OntrackPluginSupport {
    public static final String REGEX_ENV_VARIABLE = "\\$\\{([a-zA-Z0-9_]+)\\}";

    public static String readScript(AbstractBuild build, boolean usingText, String scriptText, String scriptPath) throws IOException {
        if (usingText) {
            return scriptText;
        }
        FilePath workspace = build.getWorkspace();
        if (workspace != null) {
            FilePath path = workspace.child(scriptPath);
            return path.readToString();
        }
        throw new IOException("Cannot get a workspace to get the script path at " + scriptPath);
    }

    public static String expand(String template, AbstractBuild<?, ?> theBuild, BuildListener listener) {
        if (StringUtils.isBlank((String)template)) {
            return template;
        }
        Pattern pattern = Pattern.compile(REGEX_ENV_VARIABLE);
        Matcher matcher = pattern.matcher(template);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String name = matcher.group(1);
            String value = OntrackPluginSupport.getParameter(name, theBuild, listener);
            if (value == null) {
                throw new IllegalStateException("Cannot find any replacement value for environment variable " + name);
            }
            matcher = matcher.appendReplacement(result, value);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String getParameter(String name, AbstractBuild<?, ?> theBuild, BuildListener listener) {
        String value = (String)theBuild.getBuildVariableResolver().resolve(name);
        if (value != null) {
            return value;
        }
        try {
            return (String)theBuild.getEnvironment((TaskListener)listener).get((Object)name);
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot get value for " + name, ex);
        }
    }

    public static Map<String, String> parseProperties(String text, AbstractBuild<?, ?> theBuild, BuildListener listener) {
        String[] lines;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (String line : lines = StringUtils.split((String)text, (String)"\n\r")) {
            int pos;
            if (StringUtils.isBlank((String)line) || (line = line.trim()).startsWith("#") || (pos = line.indexOf("=")) <= 0) continue;
            String name = line.substring(0, pos).trim();
            String value = line.substring(pos + 1).trim();
            String expandedValue = OntrackPluginSupport.expand(value, theBuild, listener);
            properties.put(name, expandedValue);
        }
        return properties;
    }
}

