/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import net.nemerosa.ontrack.dsl.http.OTHttpClientException;
import net.nemerosa.ontrack.dsl.http.OTMessageClientException;
import net.nemerosa.ontrack.jenkins.OntrackPluginSupport;
import net.nemerosa.ontrack.jenkins.ScriptLocation;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSL;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLResult;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.kohsuke.stapler.DataBoundConstructor;

public class OntrackDSLRunCondition
extends RunCondition {
    private final boolean usingText;
    private final String scriptPath;
    private final String scriptText;
    private final String injectEnvironment;
    private final String injectProperties;
    private final boolean ontrackLog;

    @DataBoundConstructor
    public OntrackDSLRunCondition(ScriptLocation ontrackScriptLocation, String injectEnvironment, String injectProperties, boolean ontrackLog) {
        this.usingText = ontrackScriptLocation == null || ontrackScriptLocation.isUsingText();
        this.scriptPath = ontrackScriptLocation == null ? null : ontrackScriptLocation.getScriptPath();
        this.scriptText = ontrackScriptLocation == null ? null : ontrackScriptLocation.getScriptText();
        this.injectEnvironment = injectEnvironment;
        this.injectProperties = injectProperties;
        this.ontrackLog = ontrackLog;
    }

    public boolean isUsingText() {
        return this.usingText;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public String getInjectEnvironment() {
        return this.injectEnvironment;
    }

    public String getInjectProperties() {
        return this.injectProperties;
    }

    public boolean isOntrackLog() {
        return this.ontrackLog;
    }

    public boolean runPrebuild(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        return true;
    }

    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        return this.evaluate(build, listener);
    }

    protected boolean evaluate(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        String script = OntrackPluginSupport.readScript(build, this.usingText, this.scriptText, this.scriptPath);
        OntrackDSL dsl = new OntrackDSL(script, this.injectEnvironment, this.injectProperties, this.ontrackLog);
        try {
            OntrackDSLResult dslResult = dsl.run(build, listener);
            Result result = OntrackDSL.toJenkinsResult(dslResult.getShellResult());
            return result.equals(Result.SUCCESS);
        }
        catch (OTMessageClientException ex) {
            listener.getLogger().format("[ontrack] ERROR %s%n", ex.getMessage());
            return false;
        }
        catch (OTHttpClientException ex) {
            listener.getLogger().format("[ontrack] ERROR %s%n", ex.getMessage());
            if (this.ontrackLog) {
                ex.printStackTrace(listener.getLogger());
            }
            return false;
        }
    }

    @Extension
    public static class OntrackDSLRunConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return "Ontrack: DSL condition";
        }
    }
}

