/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import net.nemerosa.ontrack.dsl.http.OTHttpClientException;
import net.nemerosa.ontrack.dsl.http.OTMessageClientException;
import net.nemerosa.ontrack.jenkins.OntrackPluginSupport;
import net.nemerosa.ontrack.jenkins.ScriptLocation;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSL;
import org.kohsuke.stapler.DataBoundConstructor;

public class OntrackDSLNotifier
extends Notifier {
    private final boolean usingText;
    private final String scriptPath;
    private final String scriptText;
    private final String injectEnvironment;
    private final String injectProperties;
    private final boolean ontrackLog;

    @DataBoundConstructor
    public OntrackDSLNotifier(ScriptLocation ontrackScriptLocation, String injectEnvironment, String injectProperties, boolean ontrackLog) {
        this.usingText = ontrackScriptLocation == null || ontrackScriptLocation.isUsingText();
        this.scriptPath = ontrackScriptLocation == null ? null : ontrackScriptLocation.getScriptPath();
        this.scriptText = ontrackScriptLocation == null ? null : ontrackScriptLocation.getScriptText();
        this.injectEnvironment = injectEnvironment;
        this.injectProperties = injectProperties;
        this.ontrackLog = ontrackLog;
    }

    public boolean isUsingText() {
        return this.usingText;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public String getInjectEnvironment() {
        return this.injectEnvironment;
    }

    public String getInjectProperties() {
        return this.injectProperties;
    }

    public boolean isOntrackLog() {
        return this.ontrackLog;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> theBuild, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String script = OntrackPluginSupport.readScript(theBuild, this.usingText, this.scriptText, this.scriptPath);
        OntrackDSL dsl = new OntrackDSL(script, this.injectEnvironment, this.injectProperties, this.ontrackLog);
        try {
            dsl.run(theBuild, listener);
        }
        catch (OTMessageClientException ex) {
            listener.getLogger().format("[ontrack] ERROR %s%n", ex.getMessage());
            theBuild.setResult(Result.FAILURE);
        }
        catch (OTHttpClientException ex) {
            listener.getLogger().format("[ontrack] ERROR %s%n", ex.getMessage());
            if (this.ontrackLog) {
                ex.printStackTrace(listener.getLogger());
            }
            theBuild.setResult(Result.FAILURE);
        }
        return true;
    }

    @Extension
    public static final class OntrackDSLNotifierDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public OntrackDSLNotifierDescriptorImpl() {
            super(OntrackDSLNotifier.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Ontrack: DSL action";
        }
    }
}

