/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributor;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributorDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class OntrackDSLEnvInjectJobPropertyContributor
extends EnvInjectJobPropertyContributor {
    private String scriptText;
    private boolean ontrackLog;

    public OntrackDSLEnvInjectJobPropertyContributor() {
    }

    @DataBoundConstructor
    public OntrackDSLEnvInjectJobPropertyContributor(String scriptText, boolean ontrackLog) {
        this.scriptText = scriptText;
        this.ontrackLog = ontrackLog;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public boolean isOntrackLog() {
        return this.ontrackLog;
    }

    public void init() {
    }

    public Map<String, String> getEnvVars(AbstractBuild build, TaskListener listener) throws EnvInjectException {
        if (StringUtils.isBlank((String)this.scriptText)) {
            return Collections.emptyMap();
        }
        Ontrack ontrack = OntrackDSLConnector.createOntrackConnector(this.ontrackLog ? listener.getLogger() : null);
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("ontrack", ontrack);
        values.put("jenkins", Jenkins.getInstance());
        values.put("build", build);
        values.put("out", listener.getLogger());
        try {
            values.put("env", build.getEnvironment(listener));
        }
        catch (IOException e) {
            throw new EnvInjectException("Cannot inject environment in DSL", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new EnvInjectException("Cannot inject environment in DSL", (Throwable)e);
        }
        Binding binding = new Binding(values);
        GroovyShell shell = new GroovyShell(binding);
        listener.getLogger().format("Ontrack DSL script running...%n", new Object[0]);
        Object result = shell.evaluate(this.scriptText);
        if (this.ontrackLog) {
            listener.getLogger().format("Ontrack DSL script returned result: %s%n", result);
        } else {
            listener.getLogger().format("Ontrack DSL script returned result.%n", new Object[0]);
        }
        if (result instanceof Map) {
            HashMap<String, String> env = new HashMap<String, String>();
            for (Map.Entry entry : ((Map)result).entrySet()) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                listener.getLogger().format("Ontrack DSL environment: %s -> %s.%n", name, value);
                env.put(name, String.valueOf(value));
            }
            return env;
        }
        listener.getLogger().format("The Ontrack DSL didn't return an environment map.", new Object[0]);
        return Collections.emptyMap();
    }

    @Extension
    public static class OntrackDSLEnvInjectJobPropertyContributorDescriptor
    extends EnvInjectJobPropertyContributorDescriptor {
        public String getDisplayName() {
            return "Ontrack: injecting environment variables from DSL";
        }
    }
}

