/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.Extension;
import hudson.model.Descriptor;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class OntrackConfiguration
extends GlobalConfiguration {
    private String ontrackConfigurationName;
    private String ontrackUrl;
    private String ontrackUser;
    private String ontrackPassword;
    private int ontrackMaxTries = 1;
    private int ontrackRetryDelaySeconds = 10000;

    public static OntrackConfiguration getOntrackConfiguration() {
        Jenkins instance = Jenkins.getInstance();
        return instance != null ? (OntrackConfiguration)instance.getDescriptor(OntrackConfiguration.class) : null;
    }

    public OntrackConfiguration() {
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.ontrackConfigurationName = json.getString("ontrackConfigurationName");
        this.ontrackUrl = json.getString("ontrackUrl");
        this.ontrackUser = json.getString("ontrackUser");
        this.ontrackPassword = json.getString("ontrackPassword");
        this.ontrackMaxTries = json.getInt("ontrackMaxTries");
        this.ontrackRetryDelaySeconds = json.getInt("ontrackRetryDelaySeconds");
        this.save();
        return super.configure(req, json);
    }

    public String getOntrackConfigurationName() {
        return this.ontrackConfigurationName;
    }

    public String getOntrackUrl() {
        return this.ontrackUrl;
    }

    public String getOntrackUser() {
        return this.ontrackUser;
    }

    public String getOntrackPassword() {
        return this.ontrackPassword;
    }

    public void setOntrackConfigurationName(String ontrackConfigurationName) {
        this.ontrackConfigurationName = ontrackConfigurationName;
    }

    public void setOntrackUrl(String ontrackUrl) {
        this.ontrackUrl = ontrackUrl;
    }

    public void setOntrackUser(String ontrackUser) {
        this.ontrackUser = ontrackUser;
    }

    public void setOntrackPassword(String ontrackPassword) {
        this.ontrackPassword = ontrackPassword;
    }

    public int getOntrackMaxTries() {
        return this.ontrackMaxTries;
    }

    public void setOntrackMaxTries(int ontrackMaxTries) {
        this.ontrackMaxTries = ontrackMaxTries;
    }

    public int getOntrackRetryDelaySeconds() {
        return this.ontrackRetryDelaySeconds;
    }

    public void setOntrackRetryDelaySeconds(int ontrackRetryDelaySeconds) {
        this.ontrackRetryDelaySeconds = ontrackRetryDelaySeconds;
    }
}

