/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.model.ParameterDefinition;
import net.nemerosa.ontrack.jenkins.dsl.DSLRunner;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLRunner;
import org.apache.commons.beanutils.BeanUtils;

public abstract class AbstractOntrackParameterDefinition
extends ParameterDefinition {
    private final String dsl;
    private final String valueProperty;
    private final transient DSLRunner dslRunner;

    public AbstractOntrackParameterDefinition(String name, String description, String dsl, String valueProperty) {
        this(name, description, dsl, valueProperty, OntrackDSLRunner.INSTANCE);
    }

    public AbstractOntrackParameterDefinition(String name, String description, String dsl, String valueProperty, DSLRunner dslRunner) {
        super(name, description);
        this.dsl = dsl;
        this.valueProperty = valueProperty;
        this.dslRunner = dslRunner;
    }

    public String getDsl() {
        return this.dsl;
    }

    public String getValueProperty() {
        return this.valueProperty;
    }

    protected Object runDSL() {
        DSLRunner runner = this.dslRunner != null ? this.dslRunner : OntrackDSLRunner.INSTANCE;
        return runner.run(this.dsl);
    }

    protected String getProperty(Object any, String property) {
        try {
            return BeanUtils.getProperty((Object)any, (String)property);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not get property %s on object %s", property, any));
        }
    }
}

