/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic.monitor;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AdministrativeMonitor;
import hudson.security.SecurityRealm;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.oic.Messages;
import org.jenkinsci.plugins.oic.OicSecurityRealm;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Restricted(value={NoExternalUse.class})
public class OicIdStrategyMonitor
extends AdministrativeMonitor {
    Boolean missingIdStrategy;

    @VisibleForTesting
    protected static OicIdStrategyMonitor get() {
        return (OicIdStrategyMonitor)((Object)ExtensionList.lookupSingleton(OicIdStrategyMonitor.class));
    }

    public String getDisplayName() {
        return Messages.OicSecurityRealm_monitor_DisplayName();
    }

    public boolean isActivated() {
        if (!Boolean.FALSE.equals(this.missingIdStrategy)) {
            SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
            this.missingIdStrategy = securityRealm instanceof OicSecurityRealm ? Boolean.valueOf(((OicSecurityRealm)securityRealm).isMissingIdStrategy()) : Boolean.FALSE;
        }
        return this.missingIdStrategy;
    }

    @RequirePOST
    public HttpResponse doForward() throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return HttpResponses.redirectViaContextPath((String)"configureSecurity");
    }
}

