/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.ChainedServletFilter2;
import hudson.security.SecurityRealm;
import hudson.tasks.Mailer;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPath;
import io.burt.jmespath.RuntimeConfiguration;
import io.burt.jmespath.jcf.JcfRuntime;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import jenkins.model.IdStrategy;
import jenkins.model.IdStrategyDescriptor;
import jenkins.model.Jenkins;
import jenkins.security.ApiTokenProperty;
import jenkins.security.FIPS140;
import jenkins.security.SecurityListener;
import jenkins.util.SystemProperties;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.oic.CustomOidcConfiguration;
import org.jenkinsci.plugins.oic.FailedCheckOfTokenException;
import org.jenkinsci.plugins.oic.LoginQueryParameter;
import org.jenkinsci.plugins.oic.LogoutQueryParameter;
import org.jenkinsci.plugins.oic.Messages;
import org.jenkinsci.plugins.oic.OicAvatarProperty;
import org.jenkinsci.plugins.oic.OicCredentials;
import org.jenkinsci.plugins.oic.OicServerConfiguration;
import org.jenkinsci.plugins.oic.OicServerManualConfiguration;
import org.jenkinsci.plugins.oic.OicServerWellKnownConfiguration;
import org.jenkinsci.plugins.oic.OicUserDetails;
import org.jenkinsci.plugins.oic.OidcProperty;
import org.jenkinsci.plugins.oic.OidcPropertyDescriptor;
import org.jenkinsci.plugins.oic.OidcPropertyExecution;
import org.jenkinsci.plugins.oic.ProxyAwareResourceRetriever;
import org.jenkinsci.plugins.oic.properties.AllowedTokenExpirationClockSkew;
import org.jenkinsci.plugins.oic.properties.DisableNonce;
import org.jenkinsci.plugins.oic.properties.DisableTokenVerification;
import org.jenkinsci.plugins.oic.properties.EscapeHatch;
import org.jenkinsci.plugins.oic.properties.LoginQueryParameters;
import org.jenkinsci.plugins.oic.properties.LogoutQueryParameters;
import org.jenkinsci.plugins.oic.properties.Pkce;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.FrameworkParameters;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.jee.context.JEEContextFactory;
import org.pac4j.jee.context.JEEFrameworkParameters;
import org.pac4j.jee.context.session.JEESessionStoreFactory;
import org.pac4j.jee.http.adapter.JEEHttpActionAdapter;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.authenticator.OidcAuthenticator;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.redirect.OidcRedirectionActionBuilder;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCrypt;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

public class OicSecurityRealm
extends SecurityRealm {
    private static final Logger LOGGER = Logger.getLogger(OicSecurityRealm.class.getName());
    private IdStrategy userIdStrategy;
    private IdStrategy groupIdStrategy;
    private static final String ID_TOKEN_REQUEST_ATTRIBUTE = "oic-id-token";
    private static final String NO_SECRET = "none";
    private static final String SESSION_POST_LOGIN_REDIRECT_URL_KEY = "oic-redirect-on-login-url";
    private final String clientId;
    private final Secret clientSecret;
    @Deprecated
    private transient String wellKnownOpenIDConfigurationUrl;
    @Deprecated
    private transient String tokenServerUrl;
    @Deprecated
    private transient String jwksServerUrl;
    @Deprecated
    private transient TokenAuthMethod tokenAuthMethod;
    @Deprecated
    private transient String authorizationServerUrl;
    @Deprecated
    private transient String userInfoServerUrl;
    private String userNameField = "sub";
    private transient Expression<Object> userNameFieldExpr = null;
    private String tokenFieldToCheckKey = null;
    private transient Expression<Object> tokenFieldToCheckExpr = null;
    private String tokenFieldToCheckValue = null;
    private String fullNameFieldName = null;
    private transient Expression<Object> fullNameFieldExpr = null;
    private String emailFieldName = null;
    private transient Expression<Object> emailFieldExpr = null;
    private String groupsFieldName = null;
    private transient Expression<Object> groupsFieldExpr = null;
    private transient Expression<Object> avatarFieldExpr = null;
    private transient String simpleGroupsFieldName = null;
    private transient String nestedGroupFieldName = null;
    @Deprecated
    private transient String scopes = null;
    private final boolean disableSslVerification;
    private boolean logoutFromOpenidProvider = true;
    @Deprecated
    private transient String endSessionEndpoint = null;
    private String postLogoutRedirectUrl;
    @Deprecated
    private transient boolean escapeHatchEnabled = false;
    @Deprecated
    private transient String escapeHatchUsername = null;
    @Deprecated
    private transient Secret escapeHatchSecret = null;
    @Deprecated
    private transient String escapeHatchGroup = null;
    @Deprecated
    private transient String automanualconfigure = null;
    @Deprecated
    private transient boolean useRefreshTokens = false;
    private OicServerConfiguration serverConfiguration;
    @Deprecated
    private String overrideScopes = null;
    private boolean rootURLFromRequest = false;
    private boolean sendScopesInTokenRequest = false;
    @Deprecated
    private transient boolean pkceEnabled = false;
    @Deprecated
    private transient boolean disableTokenVerification = false;
    @Deprecated
    private transient boolean nonceDisabled = false;
    private boolean tokenExpirationCheckDisabled = false;
    private boolean allowTokenAccessWithoutOicSession = false;
    @Deprecated
    private transient Long allowedTokenExpirationClockSkewSeconds = 60L;
    private static boolean checkNonceInRefreshFlow = SystemProperties.getBoolean((String)(OicSecurityRealm.class.getName() + ".checkNonceInRefreshFlow"), (boolean)false);
    @Deprecated
    private transient String endSessionUrl;
    private DescribableList<OidcProperty, OidcPropertyDescriptor> properties = new DescribableList(Saveable.NOOP);
    private static final Random RANDOM = new Random();
    private static final Clock CLOCK = Clock.systemUTC();
    private static final JmesPath<Object> JMESPATH = new JcfRuntime(new RuntimeConfiguration.Builder().withSilentTypeErrors(true).build());
    private transient ProxyAwareResourceRetriever proxyAwareResourceRetriever;
    @Deprecated
    private transient List<LoginQueryParameter> loginQueryParameters;
    @Deprecated
    private transient List<LogoutQueryParameter> logoutQueryParameters;

    @DataBoundConstructor
    public OicSecurityRealm(String clientId, Secret clientSecret, OicServerConfiguration serverConfiguration, Boolean disableSslVerification, IdStrategy userIdStrategy, IdStrategy groupIdStrategy) throws IOException, Descriptor.FormException {
        this.disableSslVerification = (Boolean)Util.fixNull((Object)disableSslVerification, (Object)Boolean.FALSE);
        if (FIPS140.useCompliantAlgorithms() && this.disableSslVerification) {
            throw new Descriptor.FormException(Messages.OicSecurityRealm_DisableSslVerificationFipsMode(), "disableSslVerification");
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.serverConfiguration = serverConfiguration;
        this.userIdStrategy = userIdStrategy;
        this.groupIdStrategy = groupIdStrategy;
        this.avatarFieldExpr = OicSecurityRealm.compileJMESPath("picture", "avatar field");
    }

    protected Object readResolve() throws IOException, Descriptor.FormException {
        if (this.properties == null) {
            this.properties = new DescribableList(Saveable.NOOP);
        }
        if (FIPS140.useCompliantAlgorithms()) {
            if (this.isDisableSslVerification()) {
                throw new IllegalStateException(Messages.OicSecurityRealm_DisableSslVerificationFipsMode());
            }
            if (this.isDisableTokenVerification() || this.properties.get(DisableTokenVerification.class) != null) {
                throw new IllegalStateException(Messages.OicSecurityRealm_DisableTokenVerificationFipsMode());
            }
            if (this.isEscapeHatchEnabled() || this.properties.get(EscapeHatch.class) != null) {
                throw new IllegalStateException(Messages.OicSecurityRealm_EscapeHatchFipsMode());
            }
        }
        if (this.nonceDisabled) {
            this.properties.replace((Describable)new DisableNonce());
        }
        if (this.pkceEnabled) {
            this.properties.replace((Describable)new Pkce());
        }
        if (this.disableTokenVerification) {
            this.properties.replace((Describable)new DisableTokenVerification());
        }
        if (this.allowedTokenExpirationClockSkewSeconds != null && this.allowedTokenExpirationClockSkewSeconds != 60L) {
            this.properties.replace((Describable)new AllowedTokenExpirationClockSkew(this.allowedTokenExpirationClockSkewSeconds.intValue()));
        }
        if (this.loginQueryParameters != null) {
            this.properties.replace((Describable)new LoginQueryParameters(this.loginQueryParameters));
        }
        if (this.logoutQueryParameters != null) {
            this.properties.replace((Describable)new LogoutQueryParameters(this.logoutQueryParameters));
        }
        if (this.escapeHatchEnabled) {
            this.properties.replace((Describable)new EscapeHatch(this.escapeHatchUsername, this.escapeHatchGroup, this.escapeHatchSecret));
        }
        if (!Strings.isNullOrEmpty((String)this.endSessionUrl)) {
            this.endSessionEndpoint = this.endSessionUrl + "/";
        }
        if (Strings.isNullOrEmpty((String)this.groupsFieldName) && !Strings.isNullOrEmpty((String)this.simpleGroupsFieldName)) {
            Object originalGroupFieldName = this.simpleGroupsFieldName;
            if (!Strings.isNullOrEmpty((String)this.nestedGroupFieldName)) {
                originalGroupFieldName = (String)originalGroupFieldName + "[]." + this.nestedGroupFieldName;
            }
            this.setGroupsFieldName((String)originalGroupFieldName);
        } else {
            this.setGroupsFieldName(this.groupsFieldName);
        }
        this.avatarFieldExpr = OicSecurityRealm.compileJMESPath("picture", "avatar field");
        this.setUserNameField(this.userNameField);
        this.setEmailFieldName(this.emailFieldName);
        this.setFullNameFieldName(this.fullNameFieldName);
        this.setTokenFieldToCheckKey(this.tokenFieldToCheckKey);
        try {
            if (this.automanualconfigure != null) {
                if ("auto".equals(this.automanualconfigure)) {
                    conf = new OicServerWellKnownConfiguration(this.wellKnownOpenIDConfigurationUrl);
                    ((OicServerWellKnownConfiguration)conf).setScopesOverride(this.overrideScopes);
                    this.serverConfiguration = conf;
                } else {
                    conf = new OicServerManualConfiguration("migrated", this.tokenServerUrl, this.authorizationServerUrl);
                    if (this.tokenAuthMethod != null) {
                        ((OicServerManualConfiguration)conf).setTokenAuthMethod(this.tokenAuthMethod);
                    }
                    ((OicServerManualConfiguration)conf).setEndSessionUrl(this.endSessionEndpoint);
                    ((OicServerManualConfiguration)conf).setJwksServerUrl(this.jwksServerUrl);
                    ((OicServerManualConfiguration)conf).setScopes(this.scopes != null ? this.scopes : "openid email");
                    ((OicServerManualConfiguration)conf).setUseRefreshTokens(this.useRefreshTokens);
                    ((OicServerManualConfiguration)conf).setUserInfoServerUrl(this.userInfoServerUrl);
                    this.serverConfiguration = conf;
                }
            }
        }
        catch (Descriptor.FormException e) {
            InvalidObjectException ose = new InvalidObjectException(e.getFormField() + ": " + e.getMessage());
            ose.initCause(e);
            throw ose;
        }
        this.createProxyAwareResourceRetriver();
        return this;
    }

    @Deprecated
    public void setLoginQueryParameters(List<LoginQueryParameter> values) {
        this.loginQueryParameters = values;
    }

    @Deprecated
    public List<LoginQueryParameter> getLoginQueryParameters() {
        return this.loginQueryParameters;
    }

    @Deprecated
    public void setLogoutQueryParameters(List<LogoutQueryParameter> values) {
        this.logoutQueryParameters = values;
    }

    @Deprecated
    public List<LogoutQueryParameter> getLogoutQueryParameters() {
        return this.logoutQueryParameters;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Secret getClientSecret() {
        return this.clientSecret == null ? Secret.fromString((String)NO_SECRET) : this.clientSecret;
    }

    @Restricted(value={NoExternalUse.class})
    public OicServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public String getUserNameField() {
        return this.userNameField;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isMissingIdStrategy() {
        return this.userIdStrategy == null || this.groupIdStrategy == null;
    }

    public IdStrategy getUserIdStrategy() {
        if (this.userIdStrategy != null) {
            return this.userIdStrategy;
        }
        return IdStrategy.CASE_INSENSITIVE;
    }

    public String getTokenFieldToCheckKey() {
        return this.tokenFieldToCheckKey;
    }

    public String getTokenFieldToCheckValue() {
        return this.tokenFieldToCheckValue;
    }

    public String getFullNameFieldName() {
        return this.fullNameFieldName;
    }

    public String getEmailFieldName() {
        return this.emailFieldName;
    }

    public String getGroupsFieldName() {
        return this.groupsFieldName;
    }

    public IdStrategy getGroupIdStrategy() {
        if (this.groupIdStrategy != null) {
            return this.groupIdStrategy;
        }
        return IdStrategy.CASE_INSENSITIVE;
    }

    public boolean isDisableSslVerification() {
        return this.disableSslVerification;
    }

    public boolean isLogoutFromOpenidProvider() {
        return this.logoutFromOpenidProvider;
    }

    public String getPostLogoutRedirectUrl() {
        return this.postLogoutRedirectUrl;
    }

    @Deprecated
    public boolean isEscapeHatchEnabled() {
        return this.escapeHatchEnabled;
    }

    @Deprecated
    public String getEscapeHatchUsername() {
        return this.escapeHatchUsername;
    }

    @Deprecated
    public Secret getEscapeHatchSecret() {
        return this.escapeHatchSecret;
    }

    @Deprecated
    public String getEscapeHatchGroup() {
        return this.escapeHatchGroup;
    }

    public boolean isRootURLFromRequest() {
        return this.rootURLFromRequest;
    }

    public boolean isSendScopesInTokenRequest() {
        return this.sendScopesInTokenRequest;
    }

    public boolean isPkceEnabled() {
        return this.pkceEnabled;
    }

    public boolean isDisableTokenVerification() {
        return this.disableTokenVerification;
    }

    public boolean isNonceDisabled() {
        return this.nonceDisabled;
    }

    public boolean isTokenExpirationCheckDisabled() {
        return this.tokenExpirationCheckDisabled;
    }

    public boolean isAllowTokenAccessWithoutOicSession() {
        return this.allowTokenAccessWithoutOicSession;
    }

    @Deprecated
    public Long getAllowedTokenExpirationClockSkewSeconds() {
        return this.allowedTokenExpirationClockSkewSeconds;
    }

    public DescribableList<OidcProperty, OidcPropertyDescriptor> getProperties() {
        return this.properties;
    }

    @DataBoundSetter
    public void setProperties(List<OidcProperty> properties) throws IOException {
        this.properties.replaceBy(properties);
    }

    @PostConstruct
    @Restricted(value={NoExternalUse.class})
    public void createProxyAwareResourceRetriver() {
        this.proxyAwareResourceRetriever = ProxyAwareResourceRetriever.createProxyAwareResourceRetriver(this.isDisableSslVerification());
    }

    ProxyAwareResourceRetriever getResourceRetriever() {
        return this.proxyAwareResourceRetriever;
    }

    private OidcConfiguration buildOidcConfiguration() {
        CustomOidcConfiguration conf = new CustomOidcConfiguration(this.isDisableSslVerification());
        conf.setClientId(this.clientId);
        conf.setSecret(this.clientSecret.getPlainText());
        OIDCProviderMetadata oidcProviderMetadata = this.serverConfiguration.toProviderMetadata();
        if (oidcProviderMetadata.getScopes() != null) {
            conf.setScope(oidcProviderMetadata.getScopes().toString());
        }
        conf.setResourceRetriever((ResourceRetriever)this.getResourceRetriever());
        return conf;
    }

    @Restricted(value={NoExternalUse.class})
    protected OidcClient buildOidcClient() {
        List<OidcPropertyExecution> executions = this.properties.stream().map(p -> p.newExecution(this.serverConfiguration)).toList();
        OidcConfiguration oidcConfiguration = this.buildOidcConfiguration();
        OidcPropertyDescriptor.all().stream().filter(d -> !this.properties.contains((Descriptor)d)).forEach(d -> d.getFallbackConfiguration(this.serverConfiguration, oidcConfiguration));
        executions.forEach(execution -> execution.customizeConfiguration(oidcConfiguration));
        OidcClient client = new OidcClient(oidcConfiguration);
        client.setCallbackUrl(this.buildOAuthRedirectUrl());
        client.setAuthenticator((Authenticator)new OidcAuthenticator(oidcConfiguration, client));
        client.setCallbackUrlResolver((CallbackUrlResolver)new NoParameterCallbackUrlResolver());
        executions.forEach(execution -> execution.customizeClient(client));
        return client;
    }

    @DataBoundSetter
    public void setUserNameField(String userNameField) {
        this.userNameField = (String)Util.fixNull((Object)Util.fixEmptyAndTrim((String)userNameField), (Object)"sub");
        this.userNameFieldExpr = OicSecurityRealm.compileJMESPath(this.userNameField, "user name field");
    }

    @DataBoundSetter
    public void setTokenFieldToCheckKey(String tokenFieldToCheckKey) {
        this.tokenFieldToCheckKey = Util.fixEmptyAndTrim((String)tokenFieldToCheckKey);
        this.tokenFieldToCheckExpr = OicSecurityRealm.compileJMESPath(this.tokenFieldToCheckKey, "token field to check");
    }

    @DataBoundSetter
    public void setTokenFieldToCheckValue(String tokenFieldToCheckValue) {
        this.tokenFieldToCheckValue = Util.fixEmptyAndTrim((String)tokenFieldToCheckValue);
    }

    @DataBoundSetter
    public void setFullNameFieldName(String fullNameFieldName) {
        this.fullNameFieldName = Util.fixEmptyAndTrim((String)fullNameFieldName);
        this.fullNameFieldExpr = OicSecurityRealm.compileJMESPath(this.fullNameFieldName, "full name field");
    }

    @DataBoundSetter
    public void setEmailFieldName(String emailFieldName) {
        this.emailFieldName = Util.fixEmptyAndTrim((String)emailFieldName);
        this.emailFieldExpr = OicSecurityRealm.compileJMESPath(this.emailFieldName, "email field");
    }

    protected static Expression<Object> compileJMESPath(String str, String logComment) {
        if (str == null) {
            return null;
        }
        try {
            Expression expr = JMESPATH.compile(str);
            if (expr == null && logComment != null) {
                LOGGER.warning(logComment + " with config '" + str + "' is an invalid JMESPath expression ");
            }
            return expr;
        }
        catch (RuntimeException e) {
            if (logComment != null) {
                LOGGER.warning(logComment + " config failed " + String.valueOf(e));
            }
            return null;
        }
    }

    @DataBoundSetter
    public void setGroupsFieldName(String groupsFieldName) {
        this.groupsFieldName = Util.fixEmptyAndTrim((String)groupsFieldName);
        this.groupsFieldExpr = OicSecurityRealm.compileJMESPath(this.groupsFieldName, "groups field");
    }

    @DataBoundSetter
    public void setLogoutFromOpenidProvider(boolean logoutFromOpenidProvider) {
        this.logoutFromOpenidProvider = logoutFromOpenidProvider;
    }

    @DataBoundSetter
    public void setPostLogoutRedirectUrl(String postLogoutRedirectUrl) {
        this.postLogoutRedirectUrl = Util.fixEmptyAndTrim((String)postLogoutRedirectUrl);
    }

    @Deprecated
    public void setEscapeHatchEnabled(boolean escapeHatchEnabled) throws Descriptor.FormException {
        if (FIPS140.useCompliantAlgorithms() && escapeHatchEnabled) {
            throw new Descriptor.FormException("Escape Hatch cannot be enabled in FIPS environment", "escapeHatchEnabled");
        }
        this.escapeHatchEnabled = escapeHatchEnabled;
    }

    @Deprecated
    public void setEscapeHatchUsername(String escapeHatchUsername) {
        this.escapeHatchUsername = Util.fixEmptyAndTrim((String)escapeHatchUsername);
    }

    @DataBoundSetter
    public void setEscapeHatchSecret(Secret escapeHatchSecret) {
        if (escapeHatchSecret != null) {
            String escapeHatchString = Secret.toString((Secret)escapeHatchSecret);
            Pattern BCryptPattern = Pattern.compile("\\A\\$[^$]+\\$\\d+\\$[./0-9A-Za-z]{53}");
            if (!BCryptPattern.matcher(escapeHatchString).matches()) {
                this.escapeHatchSecret = Secret.fromString((String)BCrypt.hashpw((String)escapeHatchString, (String)BCrypt.gensalt()));
                return;
            }
        }
        this.escapeHatchSecret = escapeHatchSecret;
    }

    @Deprecated
    protected boolean checkEscapeHatch(String username, String password) {
        boolean isUsernameMatch = username.equals(this.escapeHatchUsername);
        boolean isPasswordMatch = BCrypt.checkpw((String)password, (String)Secret.toString((Secret)this.escapeHatchSecret));
        return isUsernameMatch & isPasswordMatch;
    }

    @Deprecated
    public void setEscapeHatchGroup(String escapeHatchGroup) {
        this.escapeHatchGroup = Util.fixEmptyAndTrim((String)escapeHatchGroup);
    }

    @DataBoundSetter
    public void setRootURLFromRequest(boolean rootURLFromRequest) {
        this.rootURLFromRequest = rootURLFromRequest;
    }

    @DataBoundSetter
    public void setSendScopesInTokenRequest(boolean sendScopesInTokenRequest) {
        this.sendScopesInTokenRequest = sendScopesInTokenRequest;
    }

    @Deprecated
    public void setPkceEnabled(boolean pkceEnabled) {
        this.pkceEnabled = pkceEnabled;
    }

    @DataBoundSetter
    @Deprecated
    public void setDisableTokenVerification(boolean disableTokenVerification) throws Descriptor.FormException {
        if (FIPS140.useCompliantAlgorithms() && disableTokenVerification) {
            throw new Descriptor.FormException(Messages.OicSecurityRealm_DisableTokenVerificationFipsMode(), "disableTokenVerification");
        }
        this.disableTokenVerification = disableTokenVerification;
    }

    @Deprecated
    public void setNonceDisabled(boolean nonceDisabled) {
        this.nonceDisabled = nonceDisabled;
    }

    @DataBoundSetter
    public void setTokenExpirationCheckDisabled(boolean tokenExpirationCheckDisabled) {
        this.tokenExpirationCheckDisabled = tokenExpirationCheckDisabled;
    }

    @DataBoundSetter
    public void setAllowTokenAccessWithoutOicSession(boolean allowTokenAccessWithoutOicSession) {
        this.allowTokenAccessWithoutOicSession = allowTokenAccessWithoutOicSession;
    }

    @Deprecated
    public void setAllowedTokenExpirationClockSkewSeconds(Long allowedTokenExpirationClockSkewSeconds) {
        this.allowedTokenExpirationClockSkewSeconds = allowedTokenExpirationClockSkewSeconds;
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    public String getAuthenticationGatewayUrl() {
        return "securityRealm/escapeHatch";
    }

    public Filter createFilter(FilterConfig filterConfig) {
        return new ChainedServletFilter2(new Filter[]{super.createFilter(filterConfig), new Filter(){

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                if (OicSecurityRealm.this.handleTokenExpiration((HttpServletRequest)request, (HttpServletResponse)response)) {
                    chain.doFilter(request, response);
                }
            }
        }});
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof AnonymousAuthenticationToken) {
                    return authentication;
                }
                for (OidcProperty property : OicSecurityRealm.this.properties) {
                    Optional<Authentication> authenticate = property.authenticate(authentication);
                    if (!authenticate.isPresent()) continue;
                    return authenticate.get();
                }
                throw new BadCredentialsException("Unexpected authentication type: " + String.valueOf(authentication));
            }
        });
    }

    protected String getValidRedirectUrl(String url) {
        String rootUrl = this.getRootUrl();
        if (url != null && !url.isEmpty()) {
            try {
                String redirectUrl = new URL(new URL(rootUrl), url).toString();
                if (redirectUrl.startsWith(rootUrl)) {
                    String logoutUrl = new URL(new URL(rootUrl), "OicLogout").toString();
                    if (redirectUrl.startsWith(logoutUrl)) {
                        return rootUrl;
                    }
                    return redirectUrl;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return rootUrl;
    }

    @Restricted(value={DoNotUse.class})
    public void doCommenceLogin(@QueryParameter String from, @Header(value="Referer") String referer) throws URISyntaxException {
        OidcClient client = this.buildOidcClient();
        String redirectOnFinish = this.getValidRedirectUrl(from != null ? from : referer);
        OidcRedirectionActionBuilder builder = new OidcRedirectionActionBuilder(client);
        JEEFrameworkParameters parameters = new JEEFrameworkParameters((HttpServletRequest)Stapler.getCurrentRequest2(), (HttpServletResponse)Stapler.getCurrentResponse2());
        WebContext webContext = JEEContextFactory.INSTANCE.newContext((FrameworkParameters)parameters);
        SessionStore sessionStore = JEESessionStoreFactory.INSTANCE.newSessionStore((FrameworkParameters)parameters);
        CallContext ctx = new CallContext(webContext, sessionStore);
        RedirectionAction redirectionAction = (RedirectionAction)builder.getRedirectionAction(ctx).orElseThrow();
        sessionStore.set(webContext, SESSION_POST_LOGIN_REDIRECT_URL_KEY, (Object)redirectOnFinish);
        JEEHttpActionAdapter.INSTANCE.adapt((HttpAction)redirectionAction, webContext);
    }

    private boolean failedCheckOfTokenField(JWT idToken) throws ParseException {
        if (this.tokenFieldToCheckKey == null || this.tokenFieldToCheckValue == null) {
            return false;
        }
        if (idToken == null) {
            return true;
        }
        String value = this.getStringField(idToken.getJWTClaimsSet().getClaims(), this.tokenFieldToCheckExpr);
        if (value == null) {
            return true;
        }
        return !this.tokenFieldToCheckValue.equals(value);
    }

    private void loginAndSetUserData(String userName, JWT idToken, Map<String, Object> userInfo, OicCredentials credentials) throws IOException, ParseException {
        OicAvatarProperty oicAvatarProperty;
        String avatarUrl;
        String fullName;
        List<GrantedAuthority> grantedAuthorities = this.determineAuthorities(idToken, userInfo);
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder grantedAuthoritiesAsString = new StringBuilder(userName);
            grantedAuthoritiesAsString.append(" (");
            for (GrantedAuthority grantedAuthority : grantedAuthorities) {
                grantedAuthoritiesAsString.append(" ").append(grantedAuthority.getAuthority());
            }
            grantedAuthoritiesAsString.append(" )");
            LOGGER.finest("GrantedAuthorities:" + String.valueOf(grantedAuthoritiesAsString));
        }
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)userName, (Object)"", grantedAuthorities);
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        User user = User.get2((Authentication)token);
        if (user == null) {
            throw new IOException("Cannot set OIDC property on anonymous user");
        }
        String email = this.determineStringField(this.emailFieldExpr, idToken, userInfo);
        if (email != null) {
            user.addProperty((UserProperty)new Mailer.UserProperty(email));
        }
        if ((fullName = this.determineStringField(this.fullNameFieldExpr, idToken, userInfo)) != null) {
            user.setFullName(fullName);
        }
        if ((avatarUrl = this.determineStringField(this.avatarFieldExpr, idToken, userInfo)) != null) {
            LOGGER.finest(() -> "Avatar url is: " + avatarUrl);
            OicAvatarProperty.AvatarImage avatarImage = new OicAvatarProperty.AvatarImage(avatarUrl);
            oicAvatarProperty = new OicAvatarProperty(avatarImage);
        } else {
            LOGGER.finest(() -> "No avatar URL found for user " + user.getId() + ". Ensure to remove existing avatar");
            oicAvatarProperty = new OicAvatarProperty(null);
        }
        user.addProperty((UserProperty)oicAvatarProperty);
        user.addProperty((UserProperty)credentials);
        OicUserDetails userDetails = new OicUserDetails(userName, grantedAuthorities);
        SecurityListener.fireAuthenticated2((UserDetails)userDetails);
        SecurityListener.fireLoggedIn((String)userName);
    }

    private String determineStringField(Expression<Object> fieldExpr, JWT idToken, Map<String, Object> userInfo) throws ParseException {
        if (fieldExpr != null) {
            String fieldValue;
            Object field;
            if (userInfo != null && (field = fieldExpr.search(userInfo)) != null) {
                String fieldValue2;
                if (field instanceof String && (fieldValue2 = Util.fixEmptyAndTrim((String)((String)field))) != null) {
                    return fieldValue2;
                }
                if (field instanceof URI) {
                    return ((URI)field).toASCIIString();
                }
            }
            if (idToken != null && (fieldValue = Util.fixEmptyAndTrim((String)this.getStringField(idToken.getJWTClaimsSet().getClaims(), fieldExpr))) != null) {
                return fieldValue;
            }
        }
        return null;
    }

    protected String getStringField(Object object, Expression<Object> fieldExpr) {
        Object value;
        if (object != null && fieldExpr != null && (value = fieldExpr.search(object)) != null && !(value instanceof Map) && !(value instanceof List)) {
            return String.valueOf(value);
        }
        return null;
    }

    private List<GrantedAuthority> determineAuthorities(JWT idToken, Map<String, Object> userInfo) throws ParseException {
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        grantedAuthorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY2);
        if (this.groupsFieldExpr == null) {
            if (this.groupsFieldName == null) {
                LOGGER.fine("Not adding groups because groupsFieldName is not set.");
            } else {
                LOGGER.fine("Not adding groups because groupsFieldName is invalid. groupsFieldName=" + this.groupsFieldName);
            }
            return grantedAuthorities;
        }
        Object groupsObject = null;
        if (userInfo != null) {
            groupsObject = this.groupsFieldExpr.search(userInfo);
        }
        if (groupsObject == null && idToken != null) {
            groupsObject = this.groupsFieldExpr.search((Object)idToken.getJWTClaimsSet().getClaims());
        }
        if (groupsObject == null) {
            LOGGER.warning("idToken and userInfo did not contain group field name: " + this.groupsFieldName);
            return grantedAuthorities;
        }
        List<String> groupNames = this.ensureString(groupsObject);
        if (groupNames.isEmpty()) {
            LOGGER.warning("Could not identify groups in " + this.groupsFieldName + "=" + String.valueOf(groupsObject));
            return grantedAuthorities;
        }
        LOGGER.fine("Number of groups in groupNames: " + groupNames.size());
        for (String groupName : groupNames) {
            LOGGER.fine("Adding group from UserInfo: " + groupName);
            grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(groupName));
        }
        return grantedAuthorities;
    }

    private List<String> ensureString(Object field) {
        if (field == null) {
            LOGGER.warning("userInfo did not contain a valid group field content, got null");
            return Collections.emptyList();
        }
        if (field instanceof String) {
            String sField = (String)field;
            String[] rawFields = sField.split("[\\s\\[\\],]");
            ArrayList<String> result = new ArrayList<String>();
            for (String rawField : rawFields) {
                if (rawField == null || rawField.isEmpty()) continue;
                result.add(rawField);
            }
            return result;
        }
        if (field instanceof List) {
            ArrayList<String> result = new ArrayList<String>();
            List groups = (List)field;
            for (Object group : groups) {
                if (group instanceof String) {
                    result.add(group.toString());
                    continue;
                }
                if (!(group instanceof Map)) continue;
                Map groupMap = (Map)group;
                if (this.nestedGroupFieldName == null || !groupMap.containsKey(this.nestedGroupFieldName)) continue;
                result.add((String)groupMap.get(this.nestedGroupFieldName));
            }
            return result;
        }
        try {
            return (List)field;
        }
        catch (ClassCastException e) {
            LOGGER.warning("userInfo did not contain a valid group field content, got: " + field.getClass().getSimpleName());
            return Collections.emptyList();
        }
    }

    @Restricted(value={DoNotUse.class})
    public void doLogout(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = User.get2((Authentication)authentication);
        Assert.notNull((Object)user, (String)"User must not be null");
        OicCredentials credentials = (OicCredentials)user.getProperty(OicCredentials.class);
        if (credentials != null) {
            if (this.logoutFromOpenidProvider && this.serverConfiguration.toProviderMetadata().getEndSessionEndpointURI() != null) {
                user.addProperty((UserProperty)new OicCredentials(null, null, null, CLOCK.millis()));
            }
            req.setAttribute(ID_TOKEN_REQUEST_ATTRIBUTE, (Object)credentials.getIdToken());
        }
        super.doLogout(req, rsp);
    }

    public String getPostLogOutUrl2(StaplerRequest2 req, Authentication auth) {
        Object idToken = req.getAttribute(ID_TOKEN_REQUEST_ATTRIBUTE);
        Object state = this.getStateAttribute();
        String openidLogoutEndpoint = this.maybeOpenIdLogoutEndpoint(Objects.toString(idToken, ""), Objects.toString(state), this.postLogoutRedirectUrl);
        if (openidLogoutEndpoint != null) {
            return openidLogoutEndpoint;
        }
        return this.getFinalLogoutUrl(req, auth);
    }

    @VisibleForTesting
    Object getStateAttribute() {
        OidcClient client = this.buildOidcClient();
        JEEFrameworkParameters parameters = new JEEFrameworkParameters((HttpServletRequest)Stapler.getCurrentRequest2(), (HttpServletResponse)Stapler.getCurrentResponse2());
        WebContext webContext = JEEContextFactory.INSTANCE.newContext((FrameworkParameters)parameters);
        SessionStore sessionStore = JEESessionStoreFactory.INSTANCE.newSessionStore((FrameworkParameters)parameters);
        CallContext ctx = new CallContext(webContext, sessionStore);
        return client.getConfiguration().getValueRetriever().retrieve(ctx, client.getStateSessionAttributeName(), client).orElse(null);
    }

    @CheckForNull
    String maybeOpenIdLogoutEndpoint(String idToken, String state, String postLogoutRedirectUrl) {
        URI url = this.serverConfiguration.toProviderMetadata().getEndSessionEndpointURI();
        if (this.logoutFromOpenidProvider && url != null) {
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUri((URI)url);
            if (!Strings.isNullOrEmpty((String)idToken)) {
                uriComponentsBuilder.queryParam("id_token_hint", new Object[]{idToken});
            }
            if (!Strings.isNullOrEmpty((String)state) && !"null".equals(state)) {
                uriComponentsBuilder.queryParam("state", new Object[]{state});
            }
            if (postLogoutRedirectUrl != null) {
                uriComponentsBuilder.queryParam("post_logout_redirect_uri", new Object[]{URLEncoder.encode(postLogoutRedirectUrl, StandardCharsets.UTF_8)});
            }
            this.properties.stream().flatMap(p -> p.contributeLogoutQueryParameters().stream()).forEach(lqp -> {
                String urlEncodedValue = lqp.getURLEncodedValue();
                uriComponentsBuilder.queryParam(lqp.getURLEncodedKey(), new Object[]{urlEncodedValue.isEmpty() ? null : urlEncodedValue});
            });
            return uriComponentsBuilder.build().toUriString();
        }
        return null;
    }

    private String getFinalLogoutUrl(StaplerRequest2 req, Authentication auth) {
        if (Jenkins.get().hasPermission(Jenkins.READ)) {
            return super.getPostLogOutUrl2(req, auth);
        }
        return req.getContextPath() + "/OicLogout";
    }

    private String getRootUrl() {
        if (this.rootURLFromRequest) {
            return Jenkins.get().getRootUrlFromRequest();
        }
        return Jenkins.get().getRootUrl();
    }

    private String ensureRootUrl() {
        String rootUrl = this.getRootUrl();
        if (rootUrl == null) {
            throw new NullPointerException("Jenkins root url must not be null");
        }
        return rootUrl;
    }

    private String buildOAuthRedirectUrl() throws NullPointerException {
        return this.ensureRootUrl() + "securityRealm/finishLogin";
    }

    public void doFinishLogin(StaplerRequest2 request, StaplerResponse2 response) throws IOException, ParseException {
        OidcClient client = this.buildOidcClient();
        JEEFrameworkParameters parameters = new JEEFrameworkParameters((HttpServletRequest)request, (HttpServletResponse)response);
        WebContext webContext = JEEContextFactory.INSTANCE.newContext((FrameworkParameters)parameters);
        SessionStore sessionStore = JEESessionStoreFactory.INSTANCE.newSessionStore((FrameworkParameters)parameters);
        try {
            if (!sessionStore.renewSession(webContext)) {
                throw new TechnicalException("Could not create a new session");
            }
            CallContext ctx = new CallContext(webContext, sessionStore);
            Credentials credentials = (Credentials)client.getCredentials(ctx).orElseThrow(() -> new Failure("Could not extract credentials from request"));
            credentials = (Credentials)client.validateCredentials(ctx, credentials).orElseThrow(() -> new Failure("Could not validate credentials from request"));
            ProfileCreator profileCreator = client.getProfileCreator();
            OidcProfile profile = (OidcProfile)profileCreator.create(ctx, credentials).orElseThrow(() -> new Failure("Could not build user profile"));
            AccessToken accessToken = profile.getAccessToken();
            JWT idToken = profile.getIdToken();
            RefreshToken refreshToken = profile.getRefreshToken();
            String username = this.determineStringField(this.userNameFieldExpr, idToken, profile.getAttributes());
            if (this.failedCheckOfTokenField(idToken)) {
                throw new FailedCheckOfTokenException(client.getConfiguration().findLogoutUrl());
            }
            OicCredentials oicCredentials = new OicCredentials(accessToken == null ? null : accessToken.getValue(), idToken.getParsedString(), refreshToken != null ? refreshToken.getValue() : null, accessToken == null ? 0L : accessToken.getLifetime(), CLOCK.millis(), this.getAllowedTokenExpirationClockSkewSeconds());
            this.loginAndSetUserData(username, idToken, profile.getAttributes(), oicCredentials);
            String redirectUrl = sessionStore.get(webContext, SESSION_POST_LOGIN_REDIRECT_URL_KEY).orElse(Jenkins.get().getRootUrl());
            if (redirectUrl != null) {
                response.sendRedirect(302, redirectUrl);
            } else {
                response.sendError(500, "redirectUrl was null for the current flow");
            }
        }
        catch (HttpAction e) {
            JEEHttpActionAdapter.INSTANCE.adapt(e, webContext);
        }
    }

    public boolean handleTokenExpiration(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (this.isLogoutRequest(httpRequest)) {
            return true;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = User.get2((Authentication)authentication);
        if (user == null) {
            return true;
        }
        OicCredentials credentials = (OicCredentials)user.getProperty(OicCredentials.class);
        if (credentials == null) {
            return true;
        }
        if (this.isValidApiTokenRequest(httpRequest, user)) {
            return true;
        }
        if (this.isExpired(credentials)) {
            if (this.canRefreshToken(credentials)) {
                LOGGER.log(Level.FINEST, "Attempting to refresh credential for user: {0}", user.getId());
                boolean retVal = this.refreshExpiredToken(user.getId(), credentials, httpRequest, httpResponse);
                LOGGER.log(Level.FINEST, "Refresh credential for user returned {0}", retVal);
                return retVal;
            }
            if (!this.isTokenExpirationCheckDisabled()) {
                this.redirectToLoginUrl(httpRequest, httpResponse);
                return false;
            }
        }
        return true;
    }

    boolean isLogoutRequest(HttpServletRequest request) {
        return request.getRequestURI().endsWith("/logout");
    }

    boolean isValidApiTokenRequest(HttpServletRequest httpRequest, User user) {
        String authHeader;
        if (this.isAllowTokenAccessWithoutOicSession() && (authHeader = httpRequest.getHeader("Authorization")) != null && authHeader.startsWith("Basic ")) {
            String token = new String(Base64.getDecoder().decode(authHeader.substring(6)), StandardCharsets.UTF_8).split(":")[1];
            ApiTokenProperty apiTokenProperty = (ApiTokenProperty)user.getProperty(ApiTokenProperty.class);
            return apiTokenProperty != null && apiTokenProperty.matchesPassword(token);
        }
        return false;
    }

    boolean canRefreshToken(OicCredentials credentials) {
        return this.serverConfiguration.toProviderMetadata().getGrantTypes() != null && this.serverConfiguration.toProviderMetadata().getGrantTypes().contains(GrantType.REFRESH_TOKEN) && !Strings.isNullOrEmpty((String)credentials.getRefreshToken());
    }

    private void redirectToLoginUrl(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req != null && (req.getSession(false) != null || Strings.isNullOrEmpty((String)req.getHeader("Authorization")))) {
            req.getSession().invalidate();
        }
        if (res != null) {
            res.sendRedirect(Jenkins.get().getSecurityRealm().getLoginUrl());
        }
    }

    public boolean isExpired(OicCredentials credentials) {
        if (credentials.getExpiresAtMillis() == null) {
            return false;
        }
        return CLOCK.millis() >= credentials.getExpiresAtMillis();
    }

    private boolean refreshExpiredToken(String expectedUsername, OicCredentials credentials, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        OidcConfiguration configuration;
        JEEFrameworkParameters parameters = new JEEFrameworkParameters(httpRequest, httpResponse);
        WebContext webContext = JEEContextFactory.INSTANCE.newContext((FrameworkParameters)parameters);
        SessionStore sessionStore = JEESessionStoreFactory.INSTANCE.newSessionStore((FrameworkParameters)parameters);
        OidcClient client = this.buildOidcClient();
        configuration.setUseNonce((configuration = client.getConfiguration()).isUseNonce() && checkNonceInRefreshFlow);
        try {
            OidcProfile profile = new OidcProfile();
            profile.setAccessToken((AccessToken)new BearerAccessToken(credentials.getAccessToken()));
            profile.setIdTokenString(credentials.getIdToken());
            profile.setRefreshToken(new RefreshToken(credentials.getRefreshToken()));
            CallContext ctx = new CallContext(webContext, sessionStore);
            profile = (OidcProfile)client.renewUserProfile(ctx, (UserProfile)profile).orElseThrow(() -> new IllegalStateException("Could not renew user profile"));
            AccessToken accessToken = profile.getAccessToken();
            JWT idToken = Objects.requireNonNullElse(profile.getIdToken(), JWTParser.parse((String)credentials.getIdToken()));
            RefreshToken refreshToken = Objects.requireNonNullElse(profile.getRefreshToken(), new RefreshToken(credentials.getRefreshToken()));
            String username = this.determineStringField(this.userNameFieldExpr, idToken, profile.getAttributes());
            if (!User.idStrategy().equals(expectedUsername, username)) {
                httpResponse.sendError(401, "User name was not the same after refresh request");
                return false;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                Authentication a = SecurityContextHolder.getContext().getAuthentication();
                User u = User.get2((Authentication)a);
                LOGGER.log(Level.FINE, "Token refresh.  Current Authentication principal: " + a.getName() + " user id:" + (u == null ? "null user" : u.getId()) + " newly retrieved username would have been: " + username);
            }
            username = expectedUsername;
            if (this.failedCheckOfTokenField(idToken)) {
                throw new FailedCheckOfTokenException(configuration.findLogoutUrl());
            }
            OicCredentials refreshedCredentials = new OicCredentials(accessToken.getValue(), idToken.getParsedString(), refreshToken.getValue(), accessToken.getLifetime(), CLOCK.millis(), this.getAllowedTokenExpirationClockSkewSeconds());
            this.loginAndSetUserData(username, idToken, profile.getAttributes(), refreshedCredentials);
            return true;
        }
        catch (TechnicalException e) {
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"error=invalid_grant")) {
                if (this.isTokenExpirationCheckDisabled()) {
                    LOGGER.log(Level.FINE, "Failed to refresh expired token because grant is invalid, proceeding as \"Token Expiration Check Disabled\" is set");
                    return false;
                }
                LOGGER.log(Level.FINE, "Failed to refresh expired token", e);
                this.redirectToLoginUrl(httpRequest, httpResponse);
                return false;
            }
            LOGGER.log(Level.WARNING, "Failed to refresh expired token", e);
            httpResponse.sendError(401, Messages.OicSecurityRealm_TokenRefreshFailure());
            return false;
        }
        catch (ParseException e) {
            LOGGER.log(Level.WARNING, "Failed to refresh expired token", e);
            httpResponse.sendError(401, Messages.OicSecurityRealm_TokenRefreshFailure());
            return false;
        }
        catch (IllegalStateException e) {
            LOGGER.log(Level.WARNING, "Failed to refresh expired token, profile was null", e);
            httpResponse.sendError(401);
            return false;
        }
    }

    public static enum TokenAuthMethod {
        client_secret_basic(ClientAuthenticationMethod.CLIENT_SECRET_BASIC),
        client_secret_post(ClientAuthenticationMethod.CLIENT_SECRET_POST);

        private ClientAuthenticationMethod clientAuthMethod;

        private TokenAuthMethod(ClientAuthenticationMethod clientAuthMethod) {
            this.clientAuthMethod = clientAuthMethod;
        }

        ClientAuthenticationMethod toClientAuthenticationMethod() {
            return this.clientAuthMethod;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return Messages.OicSecurityRealm_DisplayName();
        }

        @RequirePOST
        public FormValidation doCheckClientId(@QueryParameter String clientId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)clientId) == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_ClientIdRequired());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckClientSecret(@QueryParameter String clientSecret) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)clientSecret) == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_ClientSecretRequired());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckPostLogoutRedirectUrl(@QueryParameter String postLogoutRedirectUrl) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)postLogoutRedirectUrl) != null) {
                try {
                    new URL(postLogoutRedirectUrl);
                    return FormValidation.ok();
                }
                catch (MalformedURLException e) {
                    return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_NotAValidURL());
                }
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckUserNameField(@QueryParameter String userNameField) {
            return this.doCheckFieldName(userNameField, FormValidation.ok((String)Messages.OicSecurityRealm_UsingDefaultUsername()));
        }

        @RequirePOST
        public FormValidation doCheckFullNameFieldName(@QueryParameter String fullNameFieldName) {
            return this.doCheckFieldName(fullNameFieldName, FormValidation.ok());
        }

        @RequirePOST
        public FormValidation doCheckEmailFieldName(@QueryParameter String emailFieldName) {
            return this.doCheckFieldName(emailFieldName, FormValidation.ok());
        }

        @RequirePOST
        public FormValidation doCheckGroupsFieldName(@QueryParameter String groupsFieldName) {
            return this.doCheckFieldName(groupsFieldName, FormValidation.ok());
        }

        @RequirePOST
        public FormValidation doCheckTokenFieldToCheckKey(@QueryParameter String tokenFieldToCheckKey) {
            return this.doCheckFieldName(tokenFieldToCheckKey, FormValidation.ok());
        }

        @RequirePOST
        public FormValidation doCheckDisableSslVerification(@QueryParameter Boolean disableSslVerification) {
            if (FIPS140.useCompliantAlgorithms() && disableSslVerification.booleanValue()) {
                return FormValidation.error((String)Messages.OicSecurityRealm_DisableSslVerificationFipsMode());
            }
            return FormValidation.ok();
        }

        private FormValidation doCheckFieldName(String fieldName, FormValidation validIfNull) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)fieldName) == null) {
                return validIfNull;
            }
            if (OicSecurityRealm.compileJMESPath(fieldName, null) == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_InvalidFieldName());
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public Descriptor<OicServerConfiguration> getDefaultServerConfigurationType() {
            return Jenkins.get().getDescriptor(OicServerWellKnownConfiguration.class);
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isFipsEnabled() {
            return FIPS140.useCompliantAlgorithms();
        }

        @Restricted(value={NoExternalUse.class})
        public List<IdStrategyDescriptor> getIdStrategyDescriptors() {
            return ExtensionList.lookup(IdStrategyDescriptor.class);
        }

        @Restricted(value={NoExternalUse.class})
        public IdStrategy defaultUsernameIdStrategy() {
            return new IdStrategy.CaseSensitive();
        }

        @Restricted(value={NoExternalUse.class})
        public IdStrategy defaultGroupIdStrategy() {
            return new IdStrategy.CaseSensitive();
        }

        public List<OidcPropertyDescriptor> getPropertiesDescriptors() {
            return ExtensionList.lookup(OidcPropertyDescriptor.class).stream().filter(OidcPropertyDescriptor::isApplicable).toList();
        }
    }
}

