/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nextexecutions.utils;

import hudson.plugins.nextexecutions.NextBuilds;
import hudson.scheduler.CronTabList;
import hudson.scheduler.RareOrImpossibleDateException;
import hudson.triggers.Trigger;
import java.lang.reflect.Field;
import java.util.Calendar;
import jenkins.model.ParameterizedJobMixIn;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;

public class NextExecutionsUtils {
    private NextExecutionsUtils() {
    }

    @SuppressRestrictedWarnings(value={CronTabList.class})
    public static NextBuilds getNextBuild(ParameterizedJobMixIn.ParameterizedJob project, Class<? extends Trigger> triggerClass) {
        Calendar cal = null;
        if (project.isDisabled()) {
            return null;
        }
        for (Trigger trigger : project.getTriggers().values()) {
            if (!trigger.getClass().equals(triggerClass)) continue;
            try {
                Field triggerTabsField = Trigger.class.getDeclaredField("tabs");
                triggerTabsField.setAccessible(true);
                CronTabList cronTabList = (CronTabList)triggerTabsField.get(trigger);
                try {
                    Calendar next = cronTabList.next();
                    if (cal != null && (next == null || !cal.after(next))) continue;
                    cal = next;
                }
                catch (RareOrImpossibleDateException rareOrImpossibleDateException) {
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {}
        }
        if (cal != null) {
            return new NextBuilds(project, cal);
        }
        return null;
    }
}

