/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.msbuild;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.msbuild.MsBuildInstallation;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.ListBoxModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MsBuildInstaller
extends ToolInstaller {
    private String selectedVersion;
    private String additionalArguments;
    private String vsconfig;

    @DataBoundConstructor
    public MsBuildInstaller(String label) {
        super(label);
    }

    public String getSelectedVersion() {
        return this.selectedVersion;
    }

    @DataBoundSetter
    public void setSelectedVersion(String selectedVersion) {
        this.selectedVersion = selectedVersion;
    }

    public String getAdditionalArguments() {
        return this.additionalArguments;
    }

    @DataBoundSetter
    public void setAdditionalArguments(String additionalArguments) {
        this.additionalArguments = additionalArguments;
    }

    @DataBoundSetter
    public void setVsconfig(String vsconfig) {
        this.vsconfig = vsconfig;
    }

    public String getVsconfig() {
        return this.vsconfig;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        if (!this.checkIfOsIsWindows(log)) {
            throw new UnsupportedOperationException("MSBuild is only available on Windows");
        }
        Object givenArguments = this.getAdditionalArguments();
        FilePath expected = this.preferredLocation(tool, node);
        FilePath vs_BuildToolsExePath = MsBuildInstaller.getVs_BuildToolsExePath(expected);
        FilePath buildToolsInstallPath = MsBuildInstaller.buildToolsInstallPath(node, this.selectedVersion, MsBuildInstaller.extractInstallPath((String)givenArguments));
        FilePath msBuildBinPath = MsBuildInstaller.msBuildBinPath(node, this.selectedVersion, MsBuildInstaller.extractInstallPath((String)givenArguments));
        FilePath msBuildExe = msBuildBinPath.child("MSBuild.exe");
        Boolean usesConfigFile = MsBuildInstaller.useConfigFile(this.getVsconfig(), expected);
        if (!MsBuildInstaller.needsModify(expected) && !MsBuildInstaller.needsUpdate(expected) && msBuildExe.exists()) {
            return msBuildBinPath;
        }
        buildToolsInstallPath.mkdirs();
        String url = ((DescriptorImpl)this.getDescriptor()).getUrlForVersion(this.selectedVersion);
        try {
            URI uri = new URI(url);
            log.getLogger().println("Downloading MSBuild version " + this.selectedVersion + " from " + url);
            MsBuildInstaller.downloadFile(uri, vs_BuildToolsExePath, log);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI: " + url);
        }
        MsBuildInstaller.waitUntilInstallerFinishes(log);
        vs_BuildToolsExePath.chmod(493);
        if (!msBuildExe.exists()) {
            String[] requiredArgs = new String[]{"--quiet", "--wait", "--norestart"};
            givenArguments = MsBuildInstaller.ensureArguments((String)givenArguments, requiredArgs);
            if (usesConfigFile.booleanValue()) {
                givenArguments = (String)givenArguments + " --config " + expected.child(".vsconfig").getRemote();
            }
            log.getLogger().println("Installing MSBuild version " + this.selectedVersion + " from " + url);
            Boolean installResult = MsBuildInstaller.runVs_BuildToolsExe(vs_BuildToolsExePath, (String)givenArguments, buildToolsInstallPath, node, log, expected);
            if (!installResult.booleanValue()) {
                throw new IOException("Installation failed with exit code " + installResult);
            }
            MsBuildInstaller.logLastUpdated(expected);
        } else if (MsBuildInstaller.needsModify(expected) || MsBuildInstaller.needsUpdate(expected)) {
            String updateArguments = "update --quiet --wait --norestart --installPath " + String.valueOf(buildToolsInstallPath);
            String modifyArguments = "modify --quiet --wait --norestart --installPath " + String.valueOf(buildToolsInstallPath);
            log.getLogger().println("Updating MSBuild version " + this.selectedVersion + " from " + url);
            if (usesConfigFile.booleanValue()) {
                updateArguments = updateArguments + " --config " + expected.child(".vsconfig").getRemote();
                modifyArguments = modifyArguments + " --config " + expected.child(".vsconfig").getRemote();
            }
            Boolean updateResult = MsBuildInstaller.runVs_BuildToolsExe(vs_BuildToolsExePath, updateArguments, buildToolsInstallPath, node, log, expected);
            Boolean modifyResult = MsBuildInstaller.runVs_BuildToolsExe(vs_BuildToolsExePath, modifyArguments, buildToolsInstallPath, node, log, expected);
            if (!updateResult.booleanValue() || !modifyResult.booleanValue()) {
                throw new IOException("Update failed with exit code " + updateResult);
            }
            MsBuildInstaller.logNeedsModify(expected, false);
            MsBuildInstaller.logLastUpdated(expected);
        }
        return msBuildBinPath;
    }

    private static boolean isInstallerRunning(String processName) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder("tasklist");
        Process process = processBuilder.start();
        try {
            boolean bl;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                bl = reader.lines().anyMatch(line -> line.contains(processName));
            }
            return bl;
        }
        finally {
            process.destroy();
        }
    }

    private static FilePath buildToolsInstallPath(Node node, String selectedVersion, String givenInstallPath) {
        if (givenInstallPath != null) {
            return new FilePath(node.getChannel(), givenInstallPath);
        }
        return new FilePath(node.getChannel(), "C:\\Program Files (x86)\\Microsoft Visual Studio\\" + selectedVersion + "\\BuildTools\\");
    }

    private static FilePath msBuildBinPath(Node node, String selectedVersion, String givenInstallPath) {
        if (givenInstallPath != null && !givenInstallPath.isEmpty()) {
            return new FilePath(node.getChannel(), givenInstallPath).child("\\MSBuild\\Current\\Bin");
        }
        return MsBuildInstaller.buildToolsInstallPath(node, selectedVersion, givenInstallPath).child("\\MSBuild\\Current\\Bin");
    }

    private static FilePath getVs_BuildToolsExePath(FilePath expected) {
        return expected.child("vs_BuildTools.exe");
    }

    private static String extractInstallPath(String givenArguments) {
        if (givenArguments != null && StringUtils.contains((String)givenArguments, (String)"--installPath")) {
            String[] args = givenArguments.split(" ");
            for (int i = 0; i < args.length - 1; ++i) {
                if (!args[i].equals("--installPath")) continue;
                return args[i + 1];
            }
        }
        return null;
    }

    private boolean checkIfOsIsWindows(TaskListener log) {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (!os.contains("win")) {
            log.getLogger().println("MSBuild is only available on Windows");
            return false;
        }
        return true;
    }

    private static void waitUntilInstallerFinishes(TaskListener log) throws InterruptedException, IOException {
        for (int i = 0; i < 20 && (MsBuildInstaller.isInstallerRunning("setup.exe") || MsBuildInstaller.isInstallerRunning("vs_BuildTools.exe")); ++i) {
            log.getLogger().println("Visual Studio Build Tools waiting for the another Installer to finish...");
            Thread.sleep(30000L);
        }
    }

    private static boolean runVs_BuildToolsExe(FilePath vs_BuildToolsExePath, String givenArguments, FilePath buildbuildToolsInstallPathToolsInstallPath, Node node, TaskListener log, FilePath expected) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"cmd.exe", "/C", "start", "/wait"});
        args.add(vs_BuildToolsExePath.getRemote());
        args.addTokenized(givenArguments);
        Launcher launcher = node.createLauncher(log);
        int result = launcher.launch().cmds(args).stdout(log).pwd(expected).join();
        if (result != 0) {
            throw new IOException("Installation failed with exit code " + result);
        }
        return true;
    }

    private static boolean useConfigFile(String vsconfig, FilePath expected) throws IOException, InterruptedException {
        if (vsconfig != null && !vsconfig.isEmpty()) {
            FilePath vsConfigFile = expected.child(".vsconfig");
            if (vsConfigFile.exists()) {
                String existingContent = vsConfigFile.readToString();
                if (!existingContent.equals(vsconfig)) {
                    vsConfigFile.write(vsconfig, "UTF-8");
                    MsBuildInstaller.logNeedsModify(expected, true);
                } else {
                    MsBuildInstaller.logNeedsModify(expected, false);
                }
            } else {
                vsConfigFile.write(vsconfig, "UTF-8");
                MsBuildInstaller.logNeedsModify(expected, true);
            }
            return true;
        }
        expected.child(".vsconfig").delete();
        MsBuildInstaller.logNeedsModify(expected, true);
        return false;
    }

    private static void logLastUpdated(FilePath expected) throws IOException, InterruptedException {
        JSONObject json;
        FilePath lastUpdated = expected.child("config.json");
        if (lastUpdated.exists()) {
            String content = lastUpdated.readToString();
            json = (JSONObject)JSONSerializer.toJSON((Object)content);
        } else {
            json = new JSONObject();
        }
        json.put("lastUpdated", (Object)(System.currentTimeMillis() / 1000L));
        lastUpdated.write(json.toString(), "UTF-8");
    }

    private static boolean needsUpdate(FilePath expected) {
        try {
            JSONObject json;
            FilePath needsModify = expected.child("config.json");
            if (needsModify.exists() && (json = JSONObject.fromObject((Object)needsModify.readToString())).has("lastUpdated")) {
                Long lastUpdatedTimestamp = json.getLong("lastUpdated");
                long currentTimestamp = System.currentTimeMillis() / 1000L;
                long diffSeconds = currentTimestamp - lastUpdatedTimestamp;
                long diffHours = diffSeconds / 3600L;
                return diffHours > 24L;
            }
        }
        catch (IOException | InterruptedException e) {
            return true;
        }
        return true;
    }

    private static void logNeedsModify(FilePath expected, Boolean updateValue) throws IOException, InterruptedException {
        JSONObject json;
        FilePath needsModify = expected.child("config.json");
        if (needsModify.exists()) {
            String content = needsModify.readToString();
            json = (JSONObject)JSONSerializer.toJSON((Object)content);
        } else {
            json = new JSONObject();
        }
        json.put("needsModify", (Object)updateValue);
        needsModify.write(json.toString(), "UTF-8");
    }

    private static boolean needsModify(FilePath expected) throws IOException, InterruptedException {
        JSONObject json;
        FilePath needsModify = expected.child("config.json");
        if (needsModify.exists() && (json = JSONObject.fromObject((Object)needsModify.readToString())).has("needsModify")) {
            return json.getBoolean("needsModify");
        }
        return false;
    }

    public static void downloadFile(URI uri, FilePath targetPath, TaskListener listener) throws IOException {
        uri.toURL();
    }

    public static String ensureArguments(String givenArguments, String[] argsToAdd) {
        StringBuilder sb = new StringBuilder(givenArguments);
        for (String arg : argsToAdd) {
            if (StringUtils.contains((String)givenArguments, (String)arg)) continue;
            sb.append(" ").append(arg);
        }
        return sb.toString();
    }

    @Extension
    public static final class DescriptorImpl
    extends ToolInstallerDescriptor<MsBuildInstaller> {
        private static final Map<String, String> VERSION_URL_MAP = new HashMap<String, String>();

        public String getUrlForVersion(String version) {
            return VERSION_URL_MAP.get(version);
        }

        public ListBoxModel doFillSelectedVersionItems() {
            ListBoxModel items = new ListBoxModel();
            ArrayList<String> versions = new ArrayList<String>(VERSION_URL_MAP.keySet());
            Collections.sort(versions, Collections.reverseOrder());
            for (String version : versions) {
                items.add("Build Tools " + version, version);
            }
            return items;
        }

        public String getDisplayName() {
            return "Install from Microsoft";
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return MsBuildInstallation.class.isAssignableFrom(toolType);
        }

        static {
            VERSION_URL_MAP.put("2022", "https://aka.ms/vs/17/release/vs_buildtools.exe");
            VERSION_URL_MAP.put("2019", "https://aka.ms/vs/16/release/vs_buildtools.exe");
        }
    }
}

