/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.msbuild;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.msbuild.MSBuildConsoleAnnotator;
import hudson.plugins.msbuild.Messages;
import hudson.plugins.msbuild.MsBuildConsoleParser;
import hudson.plugins.msbuild.MsBuildInstallation;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class MsBuildBuilder
extends Builder {
    private static final Map<String, Integer> CHARSET_CODE_MAP = new HashMap<String, Integer>();
    private final String msBuildName;
    private final String msBuildFile;
    private final String cmdLineArgs;
    private final boolean buildVariablesAsProperties;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="Retain for compatibility")
    private transient boolean continueOnBuilFailure;
    private final boolean continueOnBuildFailure;
    private final boolean unstableIfWarnings;
    private final boolean doNotUseChcpCommand;

    @Deprecated
    public MsBuildBuilder(String msBuildName, String msBuildFile, String cmdLineArgs, boolean buildVariablesAsProperties, boolean continueOnBuildFailure, boolean unstableIfWarnings) {
        this(msBuildName, msBuildFile, cmdLineArgs, buildVariablesAsProperties, continueOnBuildFailure, unstableIfWarnings, false);
    }

    @DataBoundConstructor
    public MsBuildBuilder(String msBuildName, String msBuildFile, String cmdLineArgs, boolean buildVariablesAsProperties, boolean continueOnBuildFailure, boolean unstableIfWarnings, boolean doNotUseChcpCommand) {
        this.msBuildName = msBuildName;
        this.msBuildFile = msBuildFile;
        this.cmdLineArgs = cmdLineArgs;
        this.buildVariablesAsProperties = buildVariablesAsProperties;
        this.continueOnBuildFailure = continueOnBuildFailure;
        this.unstableIfWarnings = unstableIfWarnings;
        this.doNotUseChcpCommand = doNotUseChcpCommand;
    }

    public String getMsBuildFile() {
        return this.msBuildFile;
    }

    public String getMsBuildName() {
        return this.msBuildName;
    }

    public String getCmdLineArgs() {
        return this.cmdLineArgs;
    }

    public boolean getBuildVariablesAsProperties() {
        return this.buildVariablesAsProperties;
    }

    public boolean getContinueOnBuildFailure() {
        return this.continueOnBuildFailure;
    }

    public boolean getUnstableIfWarnings() {
        return this.unstableIfWarnings;
    }

    public boolean getDoNotUseChcpCommand() {
        return this.doNotUseChcpCommand;
    }

    public MsBuildInstallation getMsBuild() {
        DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
        for (MsBuildInstallation i : descriptor.getInstallations()) {
            if (this.msBuildName == null || !i.getName().equals(this.msBuildName)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath msBuildFilePath;
        EnvVars env;
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execName = "msbuild.exe";
        MsBuildInstallation ai = this.getMsBuild();
        if (ai == null) {
            listener.getLogger().println("Path To MSBuild.exe: " + execName);
            args.add(execName);
        } else {
            env = build.getEnvironment((TaskListener)listener);
            Node node = Computer.currentComputer().getNode();
            if (node != null) {
                ai = ai.forNode(node, (TaskListener)listener);
                ai = ai.forEnvironment(env);
                String pathToMsBuild = MsBuildBuilder.getToolFullPath(launcher, ai.getHome(), execName);
                FilePath exec = new FilePath(launcher.getChannel(), pathToMsBuild);
                try {
                    if (!exec.exists()) {
                        listener.fatalError(pathToMsBuild + " doesn't exist");
                        return false;
                    }
                }
                catch (IOException e) {
                    listener.fatalError("Failed checking for existence of " + pathToMsBuild);
                    return false;
                }
                listener.getLogger().println("Path To MSBuild.exe: " + pathToMsBuild);
                args.add(pathToMsBuild);
                if (ai.getDefaultArgs() != null) {
                    args.add(MsBuildBuilder.tokenizeArgs(ai.getDefaultArgs()));
                }
            }
        }
        env = build.getEnvironment((TaskListener)listener);
        String normalizedArgs = this.cmdLineArgs.replaceAll("[\t\r\n]+", " ");
        normalizedArgs = Util.replaceMacro((String)normalizedArgs, (Map)env);
        normalizedArgs = Util.replaceMacro((String)normalizedArgs, (Map)build.getBuildVariables());
        if (normalizedArgs.trim().length() > 0) {
            args.add(MsBuildBuilder.tokenizeArgs(normalizedArgs));
        }
        Map<String, String> propertiesVariables = this.getPropertiesVariables(build);
        if (this.buildVariablesAsProperties && !propertiesVariables.isEmpty()) {
            StringBuffer parameters = new StringBuffer();
            parameters.append("/p:");
            for (Map.Entry<String, String> entry : propertiesVariables.entrySet()) {
                parameters.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
            }
            parameters.delete(parameters.length() - 1, parameters.length());
            args.add(parameters.toString());
        }
        String normalizedFile = null;
        if (this.msBuildFile != null && this.msBuildFile.trim().length() != 0) {
            normalizedFile = this.msBuildFile.replaceAll("[\t\r\n]+", " ");
            normalizedFile = Util.replaceMacro((String)normalizedFile, (Map)env);
            if (!(normalizedFile = Util.replaceMacro((String)normalizedFile, (Map)build.getBuildVariables())).isEmpty()) {
                args.add(normalizedFile);
            }
        }
        FilePath pwd = build.getModuleRoot();
        if (normalizedFile != null && !(msBuildFilePath = pwd.child(normalizedFile)).exists()) {
            pwd = build.getWorkspace();
        }
        if (!launcher.isUnix()) {
            int cpi;
            if (!this.doNotUseChcpCommand && (cpi = MsBuildBuilder.getCodePageIdentifier(build.getCharset())) != 0) {
                args.prepend(new String[]{"chcp", String.valueOf(cpi), "&"});
            }
            args.prepend(new String[]{"cmd.exe", "/C", "\""});
            args.add(new String[]{"\"", "&&", "exit", "%%ERRORLEVEL%%"});
        } else {
            listener.fatalError("Unable to use this plugin on this kind of operation system");
        }
        try {
            listener.getLogger().println(String.format("Executing the command %s from %s", args.toStringWithQuote(), pwd));
            MsBuildConsoleParser mbcp = new MsBuildConsoleParser(listener.getLogger(), build.getCharset());
            MSBuildConsoleAnnotator annotator = new MSBuildConsoleAnnotator(listener.getLogger(), build.getCharset());
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)((Object)mbcp)).stdout((OutputStream)((Object)annotator)).pwd(pwd).join();
            if (this.unstableIfWarnings && mbcp.getNumberOfWarnings() > 0) {
                listener.getLogger().println("> Set build UNSTABLE because there are warnings.");
                build.setResult(Result.UNSTABLE);
            }
            return this.continueOnBuildFailure ? true : r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    private Map<String, String> getPropertiesVariables(AbstractBuild<?, ?> build) {
        Map buildVariables = build.getBuildVariables();
        Set sensitiveBuildVariables = build.getSensitiveBuildVariables();
        if (sensitiveBuildVariables == null || sensitiveBuildVariables.isEmpty()) {
            return buildVariables;
        }
        for (String sensitiveBuildVariable : sensitiveBuildVariables) {
            buildVariables.remove(sensitiveBuildVariable);
        }
        return buildVariables;
    }

    static String getToolFullPath(Launcher launcher, String pathToTool, String execName) throws IOException, InterruptedException {
        Object fullPathToMsBuild = pathToTool != null ? pathToTool : "";
        FilePath exec = new FilePath(launcher.getChannel(), (String)fullPathToMsBuild);
        if (exec.isDirectory()) {
            if (!((String)fullPathToMsBuild).endsWith("\\")) {
                fullPathToMsBuild = (String)fullPathToMsBuild + "\\";
            }
            fullPathToMsBuild = (String)fullPathToMsBuild + execName;
        }
        return fullPathToMsBuild;
    }

    public Descriptor<Builder> getDescriptor() {
        return super.getDescriptor();
    }

    @NonNull
    static String[] tokenizeArgs(String args) {
        if (args == null) {
            return new String[0];
        }
        String[] tokenize = Util.tokenize((String)args);
        if (args.endsWith("\\")) {
            tokenize[tokenize.length - 1] = tokenize[tokenize.length - 1] + "\\";
        }
        return tokenize;
    }

    public static int getCodePageIdentifier(Charset charset) {
        Integer code = CHARSET_CODE_MAP.get(charset.name().toUpperCase(Locale.ENGLISH));
        return code != null ? code : 0;
    }

    static {
        CHARSET_CODE_MAP.put("UTF-8", 65001);
        CHARSET_CODE_MAP.put("IBM437", 437);
        CHARSET_CODE_MAP.put("IBM850", 850);
        CHARSET_CODE_MAP.put("IBM852", 852);
        CHARSET_CODE_MAP.put("SHIFT_JIS", 932);
        CHARSET_CODE_MAP.put("US-ASCII", 20127);
        CHARSET_CODE_MAP.put("EUC-JP", 20932);
        CHARSET_CODE_MAP.put("ISO-8859-1", 28591);
        CHARSET_CODE_MAP.put("ISO-8859-2", 28592);
        CHARSET_CODE_MAP.put("IBM00858", 858);
        CHARSET_CODE_MAP.put("IBM775", 775);
        CHARSET_CODE_MAP.put("IBM855", 855);
        CHARSET_CODE_MAP.put("IBM857", 857);
        CHARSET_CODE_MAP.put("ISO-8859-4", 28594);
        CHARSET_CODE_MAP.put("ISO-8859-5", 28595);
        CHARSET_CODE_MAP.put("ISO-8859-7", 28597);
        CHARSET_CODE_MAP.put("ISO-8859-9", 28599);
        CHARSET_CODE_MAP.put("ISO-8859-13", 28603);
        CHARSET_CODE_MAP.put("ISO-8859-15", 28605);
        CHARSET_CODE_MAP.put("KOI8-R", 20866);
        CHARSET_CODE_MAP.put("KOI8-U", 21866);
        CHARSET_CODE_MAP.put("UTF-16", 1200);
        CHARSET_CODE_MAP.put("UTF-32", 12000);
        CHARSET_CODE_MAP.put("UTF-32BE", 12001);
        CHARSET_CODE_MAP.put("WINDOWS-1250", 1250);
        CHARSET_CODE_MAP.put("WINDOWS-1251", 1251);
        CHARSET_CODE_MAP.put("WINDOWS-1252", 1252);
        CHARSET_CODE_MAP.put("WINDOWS-1253", 1253);
        CHARSET_CODE_MAP.put("WINDOWS-1254", 1254);
        CHARSET_CODE_MAP.put("WINDOWS-1257", 1257);
        CHARSET_CODE_MAP.put("BIG5", 950);
        CHARSET_CODE_MAP.put("EUC-KR", 51949);
        CHARSET_CODE_MAP.put("GB18030", 54936);
        CHARSET_CODE_MAP.put("GB2312", 936);
        CHARSET_CODE_MAP.put("IBM-THAI", 20838);
        CHARSET_CODE_MAP.put("IBM01140", 1140);
        CHARSET_CODE_MAP.put("IBM01141", 1141);
        CHARSET_CODE_MAP.put("IBM01142", 1142);
        CHARSET_CODE_MAP.put("IBM01143", 1143);
        CHARSET_CODE_MAP.put("IBM01144", 1144);
        CHARSET_CODE_MAP.put("IBM01145", 1145);
        CHARSET_CODE_MAP.put("IBM01146", 1146);
        CHARSET_CODE_MAP.put("IBM01147", 1147);
        CHARSET_CODE_MAP.put("IBM01148", 1148);
        CHARSET_CODE_MAP.put("IBM01149", 1149);
        CHARSET_CODE_MAP.put("IBM037", 37);
        CHARSET_CODE_MAP.put("IBM1026", 1026);
        CHARSET_CODE_MAP.put("IBM273", 20273);
        CHARSET_CODE_MAP.put("IBM277", 20277);
        CHARSET_CODE_MAP.put("IBM278", 20278);
        CHARSET_CODE_MAP.put("IBM280", 20280);
        CHARSET_CODE_MAP.put("IBM284", 20284);
        CHARSET_CODE_MAP.put("IBM285", 20285);
        CHARSET_CODE_MAP.put("IBM297", 20297);
        CHARSET_CODE_MAP.put("IBM420", 20420);
        CHARSET_CODE_MAP.put("IBM424", 20424);
        CHARSET_CODE_MAP.put("IBM500", 500);
        CHARSET_CODE_MAP.put("IBM860", 860);
        CHARSET_CODE_MAP.put("IBM861", 861);
        CHARSET_CODE_MAP.put("IBM863", 863);
        CHARSET_CODE_MAP.put("IBM864", 864);
        CHARSET_CODE_MAP.put("IBM865", 865);
        CHARSET_CODE_MAP.put("IBM869", 869);
        CHARSET_CODE_MAP.put("IBM870", 870);
        CHARSET_CODE_MAP.put("IBM871", 20871);
        CHARSET_CODE_MAP.put("ISO-2022-JP", 50220);
        CHARSET_CODE_MAP.put("ISO-2022-KR", 50225);
        CHARSET_CODE_MAP.put("ISO-8859-3", 28593);
        CHARSET_CODE_MAP.put("ISO-8859-6", 28596);
        CHARSET_CODE_MAP.put("ISO-8859-8", 28598);
        CHARSET_CODE_MAP.put("WINDOWS-1255", 1255);
        CHARSET_CODE_MAP.put("WINDOWS-1256", 1256);
        CHARSET_CODE_MAP.put("WINDOWS-1258", 1258);
    }

    @Extension
    @Symbol(value={"msbuild"})
    @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"}, justification="untriaged")
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private volatile MsBuildInstallation[] installations = new MsBuildInstallation[0];

        public DescriptorImpl() {
            super(MsBuildBuilder.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.MsBuildBuilder_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public MsBuildInstallation[] getInstallations() {
            return Arrays.copyOf(this.installations, this.installations.length);
        }

        public void setInstallations(MsBuildInstallation ... antInstallations) {
            this.installations = antInstallations;
            this.save();
        }

        public MsBuildInstallation.DescriptorImpl getToolDescriptor() {
            return (MsBuildInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(MsBuildInstallation.DescriptorImpl.class));
        }
    }
}

