/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.impl;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.jvm.ThreadDeadlockHealthCheck;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.PluginManager;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.node_monitors.DiskSpaceMonitor;
import hudson.node_monitors.DiskSpaceMonitorDescriptor;
import hudson.node_monitors.TemporarySpaceMonitor;
import java.util.List;
import java.util.Map;
import jenkins.metrics.api.HealthCheckProvider;
import jenkins.model.Jenkins;

@Extension
public class JenkinsHealthCheckProviderImpl
extends HealthCheckProvider {
    @Override
    @NonNull
    public Map<String, HealthCheck> getHealthChecks() {
        return JenkinsHealthCheckProviderImpl.checks(JenkinsHealthCheckProviderImpl.check("plugins", new HealthCheck(){

            protected HealthCheck.Result check() throws Exception {
                Jenkins jenkins = Jenkins.getInstance();
                List failedPlugins = jenkins.getPluginManager().getFailedPlugins();
                if (failedPlugins.isEmpty()) {
                    return HealthCheck.Result.healthy((String)"No failed plugins");
                }
                StringBuilder failedNames = new StringBuilder();
                boolean first = true;
                for (PluginManager.FailedPlugin p : failedPlugins) {
                    if (first) {
                        first = false;
                    } else {
                        failedNames.append("; ");
                    }
                    failedNames.append(p.name);
                }
                return HealthCheck.Result.unhealthy((String)"There are %s failed plugins: %s", (Object[])new Object[]{failedPlugins.size(), failedNames});
            }
        }), JenkinsHealthCheckProviderImpl.check("thread-deadlock", (HealthCheck)new ThreadDeadlockHealthCheck()), JenkinsHealthCheckProviderImpl.check("disk-space", new HealthCheck(){

            protected HealthCheck.Result check() throws Exception {
                DiskSpaceMonitor m = (DiskSpaceMonitor)ComputerSet.getMonitors().get(DiskSpaceMonitor.class);
                Jenkins jenkins = Jenkins.getInstance();
                if (m == null) {
                    return HealthCheck.Result.healthy();
                }
                for (Computer c : jenkins.getComputers()) {
                    DiskSpaceMonitorDescriptor.DiskSpace freeSpace = m.getFreeSpace(c);
                    if (freeSpace == null || m.getThresholdBytes() <= freeSpace.size) continue;
                    return HealthCheck.Result.unhealthy((String)"Only %s Gb free on %s", (Object[])new Object[]{freeSpace.getGbLeft(), c.getNode() instanceof Jenkins ? "(controller)" : c.getName()});
                }
                return HealthCheck.Result.healthy();
            }
        }, ComputerSet.getMonitors().get(DiskSpaceMonitor.class) != null), JenkinsHealthCheckProviderImpl.check("temporary-space", new HealthCheck(){

            protected HealthCheck.Result check() throws Exception {
                TemporarySpaceMonitor m = (TemporarySpaceMonitor)ComputerSet.getMonitors().get(TemporarySpaceMonitor.class);
                Jenkins jenkins = Jenkins.getInstance();
                if (m == null) {
                    return HealthCheck.Result.healthy();
                }
                for (Computer c : jenkins.getComputers()) {
                    DiskSpaceMonitorDescriptor.DiskSpace freeSpace = m.getFreeSpace(c);
                    if (freeSpace == null || m.getThresholdBytes() <= freeSpace.size) continue;
                    return HealthCheck.Result.unhealthy((String)"Only %s Gb free on %s", (Object[])new Object[]{freeSpace.getGbLeft(), c.getNode() instanceof Jenkins ? "(controller)" : c.getName()});
                }
                return HealthCheck.Result.healthy();
            }
        }, ComputerSet.getMonitors().get(TemporarySpaceMonitor.class) != null));
    }
}

