/*
 * Decompiled with CFR 0.152.
 */
package fi.meliora.testlab.ext.jenkins;

import com.fasterxml.jackson.databind.ObjectMapper;
import fi.meliora.testlab.ext.jenkins.TestlabNotifier;
import fi.meliora.testlab.ext.rest.model.Changeset;
import fi.meliora.testlab.ext.rest.model.KeyValuePair;
import fi.meliora.testlab.ext.rest.model.TestCaseResult;
import fi.meliora.testlab.ext.rest.model.TestCaseResultStep;
import fi.meliora.testlab.ext.rest.model.TestResult;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Run;
import hudson.remoting.VirtualChannel;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.AggregatedTestResultAction;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLDecoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.tap4j.plugin.TapTestResultAction;
import org.tap4j.plugin.model.TapStreamResult;
import org.tap4j.plugin.model.TapTestResultResult;

public class Sender {
    private static final Logger log = Logger.getLogger(Sender.class.getName());

    /*
     * WARNING - void declaration
     */
    public static void sendResults(FilePath workspace, String companyId, boolean usingonpremise, String onpremiseurl, String apiKey, String projectKey, String ruleset, String milestone, String testRunTitle, String description, String testTargetTitle, String testEnvironmentTitle, String tags, Map<String, String> parameters, TestResult.AddIssueStrategy addIssueStrategy, Boolean reopenExisting, String assignToUser, boolean publishTap, boolean tapTestsAsSteps, boolean tapFileNameInIdentifier, boolean tapTestNumberInIdentifier, String tapMappingPrefix, boolean publishRobot, String robotOutput, Boolean robotCatenateParentKeywords, String automationSource, String resultName, List<String> culprits, List<Changeset> changesets, Run<?, ?> build) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Running Sender - " + companyId + ", " + usingonpremise + ", " + onpremiseurl + ", api key hidden, " + projectKey + ", " + ruleset + ", " + milestone + ", " + testRunTitle + ", " + description + ", " + testTargetTitle + ", " + testEnvironmentTitle + ", " + tags + ", [" + String.valueOf(parameters) + "], " + String.valueOf((Object)addIssueStrategy) + ", " + reopenExisting + ", " + assignToUser + ", " + publishTap + ", " + tapTestsAsSteps + ", " + tapFileNameInIdentifier + ", " + tapTestNumberInIdentifier + ", " + tapMappingPrefix + ", " + publishRobot + ", " + robotOutput + ", " + robotCatenateParentKeywords + ", " + automationSource);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("tap-plugin installed ? : " + (Sender.hasTAPSupport() ? "Yes, we have TAP support." : "No, no TAP support available."));
        }
        boolean hasTAPSupport = Sender.hasTAPSupport();
        ArrayList<Action> ras = new ArrayList<Action>();
        for (Action a : build.getAllActions()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Action: " + String.valueOf(a));
            }
            if (hasTAPSupport && a instanceof TapTestResultAction) {
                ras.add(a);
                continue;
            }
            if (!(a instanceof AbstractTestResultAction)) continue;
            ras.add(a);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Have results: " + String.valueOf(ras));
        }
        String robotXml = null;
        if (publishRobot) {
            try {
                robotXml = (String)workspace.act((FilePath.FileCallable)new RobotOutputCallable(robotOutput));
                log.fine("Found robot output xml: " + robotXml);
            }
            catch (Exception e) {
                log.severe("Could not parse Robot Framework's output.xml: " + e.getMessage());
                throw new RuntimeException(e);
            }
        }
        if (ras.isEmpty() && publishRobot && robotXml == null) {
            log.warning("We have no results to publish. Please make sure your job is configured to publish some test results to make them available to this plugin.");
        } else {
            String user = "Jenkins job: " + build.getParent().getDisplayName();
            fi.meliora.testlab.ext.rest.model.TestResult data = new fi.meliora.testlab.ext.rest.model.TestResult();
            data.setProjectKey(projectKey);
            data.setRuleset(ruleset);
            data.setAutomationSourceTitle(automationSource);
            data.setTestRunTitle(testRunTitle);
            data.setMilestoneIdentifier(milestone);
            data.setMilestoneTitle(milestone);
            data.setAddIssueStrategy(addIssueStrategy);
            data.setReopenExistingIssues(reopenExisting);
            data.setAssignIssuesToUser(assignToUser);
            data.setUser(user);
            data.setDescription(description);
            data.setResultName(resultName);
            data.setCulprits(culprits);
            data.setChangesets(changesets);
            if (parameters != null && !parameters.isEmpty()) {
                ArrayList<KeyValuePair> parameterValues = new ArrayList<KeyValuePair>();
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    KeyValuePair keyValuePair = new KeyValuePair();
                    keyValuePair.setKey(entry.getKey());
                    keyValuePair.setValue(entry.getValue());
                    parameterValues.add(keyValuePair);
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Sending test case parameter " + entry.getKey() + " with value " + keyValuePair.getValue());
                }
                data.setParameters(parameterValues);
            }
            if (!TestlabNotifier.isBlank(testTargetTitle)) {
                data.setTestTargetTitle(testTargetTitle);
            }
            if (!TestlabNotifier.isBlank(testEnvironmentTitle)) {
                data.setTestEnvironmentTitle(testEnvironmentTitle);
            }
            if (!TestlabNotifier.isBlank(tags)) {
                data.setTags(tags);
            }
            boolean hadResults = false;
            ArrayList<TestCaseResult> results = new ArrayList<TestCaseResult>();
            for (Object e : ras) {
                Object resultObject = null;
                if (hasTAPSupport && e instanceof TapTestResultAction) {
                    try {
                        Method m = e.getClass().getMethod("getResult", new Class[0]);
                        resultObject = m.invoke(e, new Object[0]);
                    }
                    catch (Exception e2) {
                        log.fine("Could not resolve TapTestResultAction result: " + e2.getMessage());
                    }
                } else if (e instanceof AbstractTestResultAction) {
                    resultObject = ((AbstractTestResultAction)e).getResult();
                }
                if (resultObject == null) continue;
                if (resultObject instanceof List) {
                    List childReports = (List)resultObject;
                    for (Object childReport : childReports) {
                        if (!(childReport instanceof AggregatedTestResultAction.ChildReport)) continue;
                        Object childResultObject = ((AggregatedTestResultAction.ChildReport)childReport).result;
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Have child results: " + String.valueOf(childResultObject));
                        }
                        Sender.parseResult(build, childResultObject, results, user, publishTap, tapTestsAsSteps, tapFileNameInIdentifier, tapTestNumberInIdentifier, tapMappingPrefix);
                    }
                    continue;
                }
                Sender.parseResult(build, resultObject, results, user, publishTap, tapTestsAsSteps, tapFileNameInIdentifier, tapTestNumberInIdentifier, tapMappingPrefix);
            }
            if (!results.isEmpty()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Sending " + results.size() + " test results to Testlab.");
                }
                data.setResults(results);
                hadResults = true;
            }
            if (publishRobot && robotXml != null) {
                data.setRobotCatenateParentKeywords(robotCatenateParentKeywords);
                data.setXmlFormat("robot");
                data.setXml(robotXml);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Including robot framework test results to be sent to Testlab.");
                }
                hadResults = true;
            }
            if (hadResults) {
                String string = usingonpremise ? onpremiseurl : null;
                Object var38_45 = null;
                if (!"true".equalsIgnoreCase(System.getProperty("TESTLAB_SENDER_SKIP_SEND"))) {
                    try {
                        HttpClient client = HttpClient.newHttpClient();
                        ObjectMapper mapper = new ObjectMapper();
                        String json = mapper.writeValueAsString((Object)data);
                        HttpRequest request = Sender.getHttpRequest(companyId, string, apiKey, json);
                        HttpResponse<String> httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (log.isLoggable(Level.INFO)) {
                    void var38_47;
                    log.info("Posted results successfully to testlab test run: " + (var38_47 != null ? (String)var38_47.body() : "TESTLAB_SENDER_SKIP_SEND"));
                }
            } else if (log.isLoggable(Level.INFO)) {
                log.info("No test results resolved to send to Testlab. Skipping.");
            }
        }
    }

    protected static HttpRequest getHttpRequest(String companyId, String onpremiseUrl, String apiKey, String postData) {
        String baseUrl;
        if (onpremiseUrl != null && !onpremiseUrl.trim().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(onpremiseUrl);
            if (!onpremiseUrl.endsWith("/")) {
                sb.append('/');
            }
            sb.append("api");
            baseUrl = sb.toString();
            companyId = "company";
        } else {
            baseUrl = System.getProperty("TESTLAB_" + companyId.toUpperCase(), "https://" + companyId.toLowerCase() + ".melioratestlab.com/api");
        }
        String username = onpremiseUrl != null ? "company" : companyId;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(baseUrl + "/testresult")).header("Content-Type", "application/json").header("Authorization", "Basic " + Base64.getEncoder().encodeToString((username + ":" + apiKey).getBytes())).PUT(HttpRequest.BodyPublishers.ofString(postData)).build();
        return request;
    }

    protected static void parseResult(Run<?, ?> build, Object resultObject, List<TestCaseResult> results, String user, boolean publishTap, boolean tapTestsAsSteps, boolean tapFileNameInIdentifier, boolean tapTestNumberInIdentifier, String tapMappingPrefix) {
        block27: {
            if (!(resultObject instanceof hudson.tasks.test.TestResult)) break block27;
            hudson.tasks.test.TestResult result = (hudson.tasks.test.TestResult)resultObject;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Result object: " + String.valueOf(result) + ", " + result.getClass().getName());
            }
            if (result instanceof TestResult) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Detected junit compatible result object.");
                }
                TestResult junitResult = (TestResult)result;
                for (SuiteResult sr : junitResult.getSuites()) {
                    for (CaseResult cr : sr.getCases()) {
                        String id = cr.getClassName() + "." + cr.getName();
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Status for " + id + " is " + String.valueOf(cr.getStatus()));
                        }
                        int res = cr.isPassed() ? 1 : (cr.isSkipped() ? 3 : 2);
                        String msg = cr.getErrorDetails();
                        String stacktrace = cr.getErrorStackTrace();
                        results.add(Sender.getTestCaseResult(build, id, res, msg, stacktrace, user, cr.getDuration()));
                    }
                }
            } else if (Sender.hasTAPSupport() && publishTap && result instanceof TapStreamResult) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Detected tap-plugin result object.");
                }
                TapStreamResult tsr = (TapStreamResult)result;
                for (hudson.tasks.test.TestResult tr : tsr.getChildren()) {
                    TapTestResultResult r = (TapTestResultResult)tr;
                    try {
                        Object testCaseResultComment;
                        Object id;
                        String fileName;
                        int slash;
                        log.fine("TAP RESULT: " + String.valueOf(r));
                        String tapTest = r.getTitle();
                        if (!tapTestNumberInIdentifier && tapTest.contains(" - ")) {
                            tapTest = tapTest.substring(tapTest.indexOf(" - ") + 3);
                        }
                        if ((slash = (fileName = URLDecoder.decode(r.getSafeName(), "UTF-8")).lastIndexOf(47)) > -1) {
                            fileName = fileName.substring(slash + 1);
                        }
                        fileName = fileName.substring(0, fileName.lastIndexOf(45));
                        int testResult = "Yes".equals(r.getSkip()) ? 3 : ("OK".equals(r.getStatus()) ? 1 : 2);
                        log.fine(" TAP test result: " + testResult);
                        if (!tapTestsAsSteps) {
                            id = tapFileNameInIdentifier ? fileName.replaceAll("\\.", "_") + "." + tapTest : tapTest;
                            if (!StringUtils.isBlank((String)tapMappingPrefix)) {
                                id = tapMappingPrefix + (String)id;
                            }
                            log.fine(" TAP identifier parsed: " + (String)id);
                            results.add(Sender.getTestCaseResult(build, (String)id, testResult, r.toString(), r.getErrorStackTrace(), user, r.getDuration()));
                            continue;
                        }
                        id = fileName.replaceAll("\\.", "_");
                        if (!StringUtils.isBlank((String)tapMappingPrefix)) {
                            id = tapMappingPrefix + (String)id;
                        }
                        log.fine(" TAP identifier parsed: " + (String)id);
                        TestCaseResult testCaseResult = null;
                        for (TestCaseResult tcr : results) {
                            if (!((String)id).equals(tcr.getMappingId())) continue;
                            testCaseResult = tcr;
                            break;
                        }
                        if (testCaseResult == null) {
                            testCaseResult = Sender.getTestCaseResult(build, (String)id, testResult, "", "", user, r.getDuration());
                            results.add(testCaseResult);
                        }
                        TestCaseResultStep testCaseResultStep = new TestCaseResultStep();
                        testCaseResultStep.setResult(testResult);
                        testCaseResultStep.setDescription(tapTest);
                        testCaseResultStep.setComment(r.toString());
                        List<TestCaseResultStep> steps = testCaseResult.getSteps();
                        if (steps == null) {
                            steps = new ArrayList<TestCaseResultStep>();
                            testCaseResult.setSteps(steps);
                        }
                        steps.add(testCaseResultStep);
                        if (testResult == 2) {
                            testCaseResult.setResult(2);
                        }
                        if (((String)(testCaseResultComment = testCaseResult.getComment())).length() > 0) {
                            testCaseResultComment = (String)testCaseResultComment + "\n";
                        }
                        testCaseResultComment = (String)testCaseResultComment + testCaseResultStep.getComment();
                        testCaseResult.setComment((String)testCaseResultComment);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.warning("Could not parse TAP result row: " + String.valueOf(r));
                    }
                }
            } else {
                String id;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Detected generic result object.");
                }
                for (hudson.tasks.test.TestResult tr : result.getPassedTests()) {
                    id = tr.getParent() != null ? tr.getParent().getName() + "." + tr.getName() : tr.getName();
                    results.add(Sender.getTestCaseResult(build, id, 1, tr.getErrorDetails(), tr.getErrorStackTrace(), user, tr.getDuration()));
                }
                for (hudson.tasks.test.TestResult tr : result.getFailedTests()) {
                    id = tr.getParent() != null ? tr.getParent().getName() + "." + tr.getName() : tr.getName();
                    results.add(Sender.getTestCaseResult(build, id, 2, tr.getErrorDetails(), tr.getErrorStackTrace(), user, tr.getDuration()));
                }
                for (hudson.tasks.test.TestResult tr : result.getSkippedTests()) {
                    id = tr.getParent() != null ? tr.getParent().getName() + "." + tr.getName() : tr.getName();
                    results.add(Sender.getTestCaseResult(build, id, 3, tr.getErrorDetails(), tr.getErrorStackTrace(), user, tr.getDuration()));
                }
            }
        }
    }

    protected static TestCaseResult getTestCaseResult(Run<?, ?> build, String id, int result, String msg, String stacktrace, String user, float duration) {
        TestCaseResult r = new TestCaseResult();
        r.setMappingId(id);
        r.setResult(result);
        long started = build.getTimeInMillis();
        r.setStarted(started);
        r.setRun(started + (long)(duration * 1000.0f));
        r.setRunBy(user);
        if (msg != null || stacktrace != null) {
            StringBuilder comment = new StringBuilder();
            if (!TestlabNotifier.isBlank(msg)) {
                comment.append(msg);
            }
            if (!TestlabNotifier.isBlank(stacktrace)) {
                if (comment.length() > 0) {
                    comment.append("\n\n");
                }
                comment.append(stacktrace);
            }
            r.setComment(comment.toString());
        }
        return r;
    }

    public static boolean hasTAPSupport() {
        try {
            Class.forName("org.tap4j.plugin.model.TapStreamResult");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String detectXmlEncoding(byte[] xml) {
        try {
            if (xml == null) {
                return null;
            }
            XMLStreamReader r = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(xml));
            String encoding = r.getEncoding();
            r.close();
            return encoding;
        }
        catch (XMLStreamException xe) {
            return null;
        }
    }

    static {
        System.getProperties().setProperty("org.codegist.common.log.class", "org.codegist.common.log.Slf4jLogger");
    }

    private static final class RobotOutputCallable
    extends MasterToSlaveFileCallable<String> {
        private String robotOutput;

        public RobotOutputCallable(String robotOutput) {
            this.robotOutput = robotOutput;
        }

        public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            FileSet fs = Util.createFileSet((File)f, (String)this.robotOutput);
            DirectoryScanner ds = fs.getDirectoryScanner();
            String[] files = ds.getIncludedFiles();
            if (files.length > 0) {
                for (String file : files) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Matching robot output file found: " + ds.getBasedir().getAbsolutePath() + File.pathSeparator + file);
                }
                if (files.length > 1) {
                    throw new AbortException("Robot Output path " + this.robotOutput + " matches more than one file. Pattern must be more exact. Aborting.");
                }
                File outputXml = new File(ds.getBasedir(), files[0]);
                byte[] bytes = FileUtils.readFileToByteArray((File)outputXml);
                String encoding = Sender.detectXmlEncoding(bytes);
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                return new String(bytes, encoding);
            }
            return null;
        }
    }
}

