/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.mailwatcher;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.ComputerListener;
import hudson.slaves.OfflineCause;
import hudson.util.DescribableList;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.mailwatcher.MailWatcherMailer;
import org.jenkinsci.plugins.mailwatcher.MailWatcherNotification;
import org.jenkinsci.plugins.mailwatcher.WatcherNodeProperty;

@Extension
public class WatcherComputerListener
extends ComputerListener {
    private final MailWatcherMailer mailer;
    private final String jenkinsRootUrl;

    public WatcherComputerListener() {
        this(new MailWatcherMailer(Jenkins.get()), Jenkins.get().getRootUrl());
    }

    public WatcherComputerListener(MailWatcherMailer mailer, String jenkinsRootUrl) {
        if (mailer == null) {
            throw new IllegalArgumentException("No mailer provided");
        }
        this.mailer = mailer;
        this.jenkinsRootUrl = jenkinsRootUrl;
    }

    public void onOffline(Computer c) {
        this.getNotification().online(false).subject("marked offline").send(c);
    }

    public void onOffline(@NonNull Computer c, OfflineCause cause) {
        if (cause == null) {
            this.onOffline(c);
            return;
        }
        this.getNotification().online(false).subject("marked offline").body(cause.toString()).send(c);
    }

    public void onOnline(Computer c, TaskListener listener) {
        this.getNotification().online(true).subject("marked online").send(c);
    }

    public void onTemporarilyOffline(Computer c, OfflineCause cause) {
        String causeString = "";
        if (cause != null) {
            causeString = cause.toString();
        }
        this.getNotification().online(false).subject("marked temporarily offline").body(causeString).send(c);
    }

    public void onTemporarilyOnline(Computer c) {
        this.getNotification().online(true).subject("marked online (was temporarily offline)").send(c);
    }

    private Notification.Builder getNotification() {
        return new Notification.Builder(this.mailer, this.jenkinsRootUrl);
    }

    private static class Notification
    extends MailWatcherNotification {
        public Notification(Builder builder) {
            super(builder);
        }

        @Override
        protected String getSubject() {
            return String.format("Computer %s %s", this.getName(), super.getSubject());
        }

        private static class Builder
        extends MailWatcherNotification.Builder {
            private boolean online;

            public Builder(MailWatcherMailer mailer, String jenkinsRootUrl) {
                super(mailer, jenkinsRootUrl);
            }

            public Builder online(boolean online) {
                this.online = online;
                return this;
            }

            @Override
            public void send(Object o) {
                Computer computer = (Computer)o;
                WatcherNodeProperty property = Builder.getWatcherNodeProperty(computer);
                if (property != null) {
                    String recipients = this.online ? property.getOnlineAddresses() : property.getOfflineAddresses();
                    this.recipients(recipients);
                }
                this.url(computer.getUrl());
                this.name(computer.getDisplayName());
                new Notification(this).send();
            }

            private static WatcherNodeProperty getWatcherNodeProperty(Computer computer) {
                DescribableList properties1;
                Node node = computer.getNode();
                if (node == null) {
                    return null;
                }
                DescribableList properties = node instanceof Jenkins ? ((properties1 = ((Jenkins)node).getGlobalNodeProperties()) == null || properties1.isEmpty() ? node.getNodeProperties() : properties1) : node.getNodeProperties();
                return (WatcherNodeProperty)properties.get(WatcherNodeProperty.class);
            }
        }
    }
}

