/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.mailwatcher;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.listeners.RunListener;
import hudson.slaves.OfflineCause;
import hudson.tasks.Mailer;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.mailwatcher.MailWatcherMailer;
import org.jenkinsci.plugins.mailwatcher.MailWatcherNotification;

@Extension
public class NodeAwailabilityListener
extends RunListener<Run<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(NodeAwailabilityListener.class.getName());
    private static final List<String> IGNORED_CLASSES = Collections.singletonList("org.jenkinsci.plugins.workflow.job.WorkflowRun");
    private final MailWatcherMailer mailer;
    private final String jenkinsRootUrl;

    public NodeAwailabilityListener() {
        this(new MailWatcherMailer(Jenkins.get()), Jenkins.get().getRootUrl());
    }

    public NodeAwailabilityListener(MailWatcherMailer mailer, String jenkinsRootUrl) {
        if (mailer == null) {
            throw new IllegalArgumentException("No mailer provided");
        }
        this.mailer = mailer;
        this.jenkinsRootUrl = jenkinsRootUrl;
    }

    private boolean isIgnoredRunClass(Run<?, ?> r) {
        String runClassName = r.getClass().getCanonicalName();
        return IGNORED_CLASSES.contains(runClassName);
    }

    public void onFinalized(Run<?, ?> r) {
        if (this.isIgnoredRunClass(r)) {
            return;
        }
        Computer computer = this.computer(r);
        if (computer == null) {
            String msg = String.format("Unable to identify the slave of %s (%s)", r, r.getClass());
            LOGGER.log(Level.INFO, msg, new Exception());
            return;
        }
        if (!computer.isTemporarilyOffline()) {
            return;
        }
        User user = this.user(computer);
        if (user == null) {
            return;
        }
        if (!this.isIdle(computer)) {
            return;
        }
        String address = ((Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)).getAddress();
        String subject = "Jenkins computer '" + computer.getDisplayName() + "' you have put offline is no longer occupied";
        this.getNotification().subject(subject).url(computer.getUrl()).recipients(address).initiator(user).send(r);
    }

    @CheckForNull
    private User user(Computer computer) {
        OfflineCause cause = computer.getOfflineCause();
        if (cause instanceof OfflineCause.UserCause) {
            return ((OfflineCause.UserCause)cause).getUser();
        }
        return null;
    }

    @CheckForNull
    private Computer computer(Run<?, ?> r) {
        Node node;
        if (r instanceof AbstractBuild && (node = ((AbstractBuild)r).getBuiltOn()) != null) {
            return node.toComputer();
        }
        return null;
    }

    private boolean isIdle(Computer computer) {
        Thread current = Thread.currentThread();
        for (Executor e : computer.getExecutors()) {
            if (e.isIdle() || e == current) continue;
            return false;
        }
        for (Executor e : computer.getOneOffExecutors()) {
            if (e.isIdle() || e == current) continue;
            return false;
        }
        return true;
    }

    private Notification.Builder getNotification() {
        return new Notification.Builder(this.mailer, this.jenkinsRootUrl);
    }

    private static class Notification
    extends MailWatcherNotification {
        public Notification(Builder builder) {
            super(builder);
        }

        private static class Builder
        extends MailWatcherNotification.Builder {
            public Builder(MailWatcherMailer mailer, String jenkinsRootUrl) {
                super(mailer, jenkinsRootUrl);
            }

            @Override
            public void send(Object o) {
                new Notification(this).send();
            }
        }
    }
}

