/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.pipeline;

import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;
import jenkins.plugins.logstash.LogstashConfiguration;
import jenkins.plugins.logstash.pipeline.GlobalDecorator;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.WorkspaceAction;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStep;
import org.jenkinsci.plugins.workflow.support.steps.StageStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class LogstashStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(LogstashStep.class.getName());

    @DataBoundConstructor
    public LogstashStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context);
    }

    public static class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;

        public Execution(StepContext context) {
            super(context);
        }

        public void onResume() {
        }

        public boolean start() throws Exception {
            StepContext context = this.getContext();
            BodyInvoker invoker = context.newBodyInvoker().withCallback(BodyExecutionCallback.wrap((FutureCallback)context));
            if (LogstashConfiguration.getInstance().isEnableGlobally()) {
                ((TaskListener)context.get(TaskListener.class)).getLogger().println("The logstash step is unnecessary when logstash is enabled for all builds.");
            } else {
                invoker.withContext((Object)this.getMergedDecorator(context));
            }
            invoker.start();
            return false;
        }

        private TaskListenerDecorator getMergedDecorator(StepContext context) throws IOException, InterruptedException {
            LabelAction labelAction;
            Run run = (Run)context.get(Run.class);
            FlowNode node = (FlowNode)context.get(FlowNode.class);
            FlowNode stageNode = this.getStageNode(node);
            String stageName = null;
            if (stageNode != null && (labelAction = (LabelAction)stageNode.getAction(LabelAction.class)) != null) {
                stageName = labelAction.getDisplayName();
            }
            String agentName = this.getAgentName(node);
            return TaskListenerDecorator.merge((TaskListenerDecorator)((TaskListenerDecorator)context.get(TaskListenerDecorator.class)), (TaskListenerDecorator)new GlobalDecorator((WorkflowRun)run, stageName, agentName));
        }

        private String getAgentName(FlowNode node) {
            for (BlockStartNode bsn : node.iterateEnclosingBlocks()) {
                WorkspaceAction workspaceAction;
                StepDescriptor descriptor;
                if (!(bsn instanceof StepNode) || !((descriptor = ((StepNode)bsn).getDescriptor()) instanceof ExecutorStep.DescriptorImpl) || (workspaceAction = (WorkspaceAction)bsn.getAction(WorkspaceAction.class)) == null) continue;
                return workspaceAction.getNode();
            }
            return null;
        }

        private FlowNode getStageNode(FlowNode node) {
            for (BlockStartNode bsn : node.iterateEnclosingBlocks()) {
                if (!this.isStageNode((FlowNode)bsn)) continue;
                return bsn;
            }
            return null;
        }

        private boolean isStageNode(FlowNode node) {
            LabelAction labelAction;
            StepDescriptor descriptor;
            return node instanceof StepNode && (descriptor = ((StepNode)node).getDescriptor()) instanceof StageStep.DescriptorImpl && (labelAction = (LabelAction)node.getAction(LabelAction.class)) != null;
        }

        public void stop(@NonNull Throwable cause) throws Exception {
            this.getContext().onFailure(cause);
        }
    }

    @Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Send individual log lines to Logstash";
        }

        public String getFunctionName() {
            return "logstash";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, Run.class, FlowNode.class);
            return Collections.unmodifiableSet(context);
        }
    }
}

